/**
 * Copyright wrotenodoc ( http://wonderfl.net/user/wrotenodoc )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eQC5
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField
    import flash.events.MouseEvent
    public class FlashTest extends Sprite {
        private var sticks:Array
        private var blocks:Array
        private var blockContainer:Sprite
        private var pos:Array
        private const bheight:Number = 6 // block height
        private var state:int = 0
        private var info:TextField
        public function FlashTest() {
            // write as3 code here..
            sticks = createStick(3)
            blockContainer = new Sprite
            addChild(blockContainer)
            blocks = createBlock(20, blockContainer)
            pos = []
            for(var i:int=0; i<blockContainer.numChildren; i++){
                pos[i] = 0
            }
            
            info = new TextField
            addChild(info)
            info.text = "Click first stick and then second click"
            info.autoSize = "left"
            
            render(sticks, blocks, pos)
            stage.addEventListener("mouseDown", stage_md)
        }
        private function createStick(num:int):Array {
            var sticks:Array = []
            for(var i:int=0; i<num; i++){
                sticks[i] = new Sprite
                sticks[i].graphics.beginFill(0x996600)
                sticks[i].graphics.drawRect(-7, -180, 14, 180)
                sticks[i].x = 100 + 120 * i
                sticks[i].y = stage.stageHeight * .75
                addChild(sticks[i])
            }
            return sticks
        }
        private function createBlock(num:int, container:Sprite):Array {
            var blocks:Array = []
            for(var i:int=0; i<num; i++){
                blocks[i] = new Sprite
                blocks[i].graphics.lineStyle(1, 0x0)
                blocks[i].graphics.beginFill(0x123456, 0.5)
                var bwidth:Number = 20 + i*4
                blocks[i].graphics.drawRect(-bwidth/2, -bheight, bwidth, bheight)
                container.addChild(blocks[i])
            }
            return blocks
        }
        private function render(sticks:Array, blocks:Array, pos:Array):void {
            var stack:Array = []
            for(var i:int=0; i<sticks.length; i++) stack[i] = []
            for(i=0; i<blocks.length; i++){
                stack[pos[i]].unshift(blocks[i])
            }
            for(i=0; i<stack.length; i++){
                for(var j:int=0; j<stack[i].length; j++){
                    stack[i][j].x = sticks[i].x
                    stack[i][j].y = sticks[i].y - j * bheight
                }
            }
        }
        private var selectedStick:int
        private function stage_md(e:MouseEvent):void {
            if(state == 0){
                for(var i:int=0; i<sticks.length; i++){
                    if(sticks[i].hitTestPoint(e.stageX, e.stageY, true) && getTop(i) != -1){
                        sticks[i].alpha = 0.5
                        state = 1
                        selectedStick = i
                        break
                    }
                }
            }else if(state == 1){
                for(i=0; i<sticks.length; i++){
                    if(sticks[i].hitTestPoint(e.stageX, e.stageY, true)){
                        sticks[selectedStick].alpha = 1
                        state = 0
                        if(selectedStick == i){
                            //
                        }else{
                            var block1:int = getTop(selectedStick)
                            var block2:int = getTop(i)
                            if(block1 != -1 && (block1 < block2 || block2 == -1)){
                                pos[block1] = i
                            }
                        }
                        break
                    }
                }
            }
            render(sticks, blocks, pos)
        }
        private function getTop(stick:int):int {
            var top:int = -1
            for(var i:int=0; i<blocks.length; i++){
                if(pos[i] == stick && (top == -1 || i < top)){
                    top = i
                }
            }
            return top
        }
    }
}