/**
 * Copyright mrcabrera ( http://wonderfl.net/user/mrcabrera )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ePxx
 */

package  {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    /**
     * @author Mark Paolo Cabrera
     * Submitted for 2011 Phlashers.com 5KB Challenge
     */
    [SWF(backgroundColor="0x000000", width="800", height="600")]
    public class RainbowDraw extends Sprite {
        private static const COLOR_HEIGHT:Number = 15;
        private static const COLORS:Array = [0xFF0000, 0xFF7F00, 0xFFFF00, 0x00FF00, 0x0000FF, 0x6600FF, 0x8B00FF];
        private static const GAME_WIDTH:Number = 800;
        private static const GAME_HEIGHT:Number = 600;
        private var _anchorPoint:Point;
        private var _currentDrawPoint:Point;
        private var _localMousePoint:Point;
        private var _targetDrawPoint:Point;
        private var _leftPoint:Point;
        private var _rightPoint:Point;
        private var _velocity:Point;
        private var _drawMatrix:Matrix;
        private var _drawRectangle:Rectangle;
        private var _canvas:Sprite;
        private var _bmpData:BitmapData;
        private var _bmp:Bitmap;
        private var _stage:Stage;
        public function RainbowDraw () {
            if ( stage ) {
                init();
            } else {
                addEventListener( Event.ADDED_TO_STAGE, init );
            }
        }
        private function init ( event:Event = null ):void {
            removeEventListener( Event.ADDED_TO_STAGE, init );
            _stage = stage;
            _canvas = new Sprite();
            
            _anchorPoint             = new Point();
            _currentDrawPoint         = new Point();
            _localMousePoint         = new Point();
            _targetDrawPoint         = new Point();
            _leftPoint                 = new Point();
            _rightPoint             = new Point();
            _velocity                 = new Point( 30, 0 );
            _drawMatrix             = new Matrix();
            _drawRectangle             = new Rectangle( 0, 0, 0, GAME_HEIGHT );
            
            _bmpData = new BitmapData( GAME_WIDTH, GAME_HEIGHT, true, 0x00000000 );
            _bmp = new Bitmap( _bmpData );
            addChild( _bmp );
            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
        }
        public function drawInitialPlatform ():void {
            _anchorPoint.x = 0;
            _anchorPoint.y = 100;
            
            drawRainbow( 500, 200 );
            
            _anchorPoint.x -= _velocity.x;
            _currentDrawPoint.x = _anchorPoint.x;
            _currentDrawPoint.y = _anchorPoint.y;
        }
        private function drawRainbow ( xPos:Number, yPos:Number ):void {
            var a:int;
            _leftPoint.x = 0
            _leftPoint.y = _anchorPoint.y
            _rightPoint.x = xPos - _anchorPoint.x;
            _rightPoint.y = yPos;
            
            _canvas.graphics.clear();
            var colorLen:int = COLORS.length;
            for ( a = 0; a < colorLen; a++ ) {
                _canvas.graphics.beginFill( COLORS[a] );
                _canvas.graphics.moveTo( _leftPoint.x, _leftPoint.y + COLOR_HEIGHT * a );
                _canvas.graphics.lineTo( _leftPoint.x, _leftPoint.y + COLOR_HEIGHT * ( a + 1 ) );
                _canvas.graphics.lineTo( _rightPoint.x, _rightPoint.y + COLOR_HEIGHT * ( a + 1 ) );
                _canvas.graphics.lineTo( _rightPoint.x, _rightPoint.y + COLOR_HEIGHT * a );
                _canvas.graphics.lineTo( _leftPoint.x, _leftPoint.y + COLOR_HEIGHT * a );
                _canvas.graphics.endFill();
            }
            
            drawToBitmapData( xPos, yPos );
            _anchorPoint.x = xPos;
            _anchorPoint.y = yPos;
        }
        private function drawToBitmapData ( xPos:Number, yPos:Number ):void {
            _drawMatrix.tx = _anchorPoint.x;
            _drawRectangle.x = _drawMatrix.tx;
            _drawRectangle.width = xPos - _anchorPoint.x;
            _bmpData.draw( _canvas, _drawMatrix, null, null, _drawRectangle );
        }
        public function update ():void {
            _bmpData.lock();
            _bmpData.scroll( -Math.floor( _velocity.x ), 0 );
            
            _localMousePoint.x = _stage.mouseX;
            _localMousePoint.y = _stage.mouseY;
            
            if ( _localMousePoint.x > GAME_WIDTH ) {
                _localMousePoint.x = GAME_WIDTH;
            } else if ( _localMousePoint.x < 0 ) {
                _localMousePoint.x = 0;
            }
            
            if ( _localMousePoint.y > GAME_HEIGHT) {
                _localMousePoint.y = GAME_HEIGHT;
            } else if ( _localMousePoint.y < 0 ) {
                _localMousePoint.y = 0;
            }
            
            _localMousePoint = _canvas.globalToLocal( _localMousePoint );
            
            if ( 
                ( _anchorPoint.x == 0 )
                && ( _anchorPoint.y == 0 )
            ) {
                _anchorPoint.y = _localMousePoint.y;
            }
            
            _targetDrawPoint.x = _localMousePoint.x;
            _targetDrawPoint.y = _localMousePoint.y;
            
            seekDrawPoint();
            
            if ( _currentDrawPoint.x >= _anchorPoint.x ) {
                drawRainbow( Math.floor( _currentDrawPoint.x ), Math.floor( _currentDrawPoint.y ) );
            }
            
            if ( _anchorPoint ) {
                _anchorPoint.x += -Math.floor( _velocity.x );
            }
            
            _bmpData.unlock();
        }
        private function seekDrawPoint ():void {
            if ( 
                ( _targetDrawPoint.x != _currentDrawPoint.x )
                || ( _targetDrawPoint.y != _currentDrawPoint.y )
            ) {
                if ( Point.distance( _targetDrawPoint, _currentDrawPoint ) > 5 ) {
                    _currentDrawPoint = Point.interpolate( _targetDrawPoint, _currentDrawPoint, .05 );
                } else {
                    _currentDrawPoint = _targetDrawPoint.clone();
                }
            }
        }
        private function enterFrameHandler ( event:Event ):void {
            update();
        }
    }
}