/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eO0C
 */

package {
	import flash.display.Sprite;
	import flash.filters.DropShadowFilter;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	import caurina.transitions.Tweener;
	/**
	 * ...
	 * @author ...
	 */
	public class Main extends Sprite {
		
		public function Main() {
			
			//デフォルト値
			var balloon0:FukidashiBalloon = new FukidashiBalloon();
			balloon0.x = 50;
			balloon0.y = 50;
			balloon0.filters = [new DropShadowFilter()];
			balloon0.name = "b1";
			this.addChild(balloon0);
			
			
			
			//カスタム値
			var kuchi0:Object = { x0:350, y0:50, x1:330, y1:45, x2:330, y2:55, color:0x00FF00 };
			var kuchi1:Object = { x0:350, y0:50, x1:330, y1:45, x2:330, y2:55, color:0xCCCCFF };
			var body0:Object = { x:282, y:25, width:50, height:50, r:50, color:0x00FF00 };
			var body1:Object = { x:32, y:-25, width:300, height:100, r:16, color:0xCCCCFF };
			
			var text0:TextField = new TextField();
			text0.defaultTextFormat = new TextFormat("_sans", 28,0xFFFFFF,true);
			text0.text = "?";
			text0.autoSize = "left";
			
			var text1:TextField = new TextField();
			text1.defaultTextFormat = new TextFormat("_sans", 28,0x000000,true);
			text1.text = "FukidashiBalloon";
			text1.autoSize = "left";
			
			var balloon1:FukidashiBalloon = new FukidashiBalloon(body0, kuchi0, body1, kuchi1, text0, text1);
			balloon1.x = 100;
			balloon1.y = 300;
			balloon1.filters = [new DropShadowFilter()];
			balloon1.name = "b2";
			this.addChild(balloon1);
			
			
			
			//イベントリスナー
			this.addEventListener(MouseEvent.MOUSE_OVER, onOver);
			this.addEventListener(MouseEvent.MOUSE_OUT, onOut);
		}
		private function onOver(event:MouseEvent):void {
			if(event.target.name.length == 2){
				Tweener.addTween(event.target, { draw:1, time:0.6, transition:"easeInOutSine" } );
			}
		}
		private function onOut(event:MouseEvent):void {
			if(event.target.name.length == 2){
				Tweener.addTween(event.target, { draw:0, time:0.6, transition:"easeInOutSine" } );
			}
		}
	}
}


import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.Sprite;

class FukidashiBalloon extends Sprite {
	private var _0kuchi:Object = { x0:0, y0:50, x1:20, y1:45, x2:20, y2:55, color:0xFF0000 };
	private var _1kuchi:Object = { x0:0, y0:50, x1:20, y1:45, x2:20, y2:55, color:0x0000FF };
	private var _0body:Object = { x:18, y:25, width:50, height:50, r:50, color:0xFF0000 };
	private var _1body:Object = { x:18, y:0, width:100, height:100, r:8, color:0x0000FF };
	private var _0content:Bitmap;
	private var _1content:Bitmap;
	
	public function FukidashiBalloon(body0:Object = null, kuchi0:Object = null, body1:Object = null, kuchi1:Object = null, BitmapDrawable0:DisplayObject = null, BitmapDrawable1:DisplayObject = null):void {
		var str:String;
		
		//くちばし
		if(kuchi1){
			for (str in kuchi0) {
				_0kuchi[str] = kuchi0[str];
			}
			for (str in kuchi1) {
				_1kuchi[str] = kuchi1[str];
			}
		}else if(kuchi0){
			for (str in kuchi0) {
				_0kuchi[str] = kuchi0[str];
				_1kuchi[str] = kuchi0[str];
			}
		}
		
		//本体
		if(body1){
			for (str in body0) {
				_0body[str] = body0[str];
			}
			for (str in body1) {
				_1body[str] = body1[str];
			}
		}else if(body0){
			for (str in body0) {
				_0body[str] = body0[str];
				_1body[str] = body0[str];
			}
		}
		
		//BitmapDataにdrawできるオブジェクトがある場合は、bitmap化して貼り付ける
		if(BitmapDrawable0){
			var bitmapData0:BitmapData = new BitmapData(BitmapDrawable0.width, BitmapDrawable0.height, true, 0x000000);
			bitmapData0.draw(BitmapDrawable0);
			_0content = new Bitmap(bitmapData0);
			this.addChild(_0content);
		}
		if(BitmapDrawable1){
			var bitmapData1:BitmapData = new BitmapData(BitmapDrawable1.width, BitmapDrawable1.height, true, 0x000000);
			bitmapData1.draw(BitmapDrawable1);
			_1content = new Bitmap(bitmapData1);
			this.addChild(_1content);
		}
		draw = 0;
	}
	private var _draw:Number;
	public function get draw():Number { return _draw };
	public function set draw(value:Number):void {
		if (_draw == value) { return };
		_draw = value;
		
		//くちばし
		var kx0:Number = _0kuchi.x0 * (1 - value) + _1kuchi.x0 * value;
		var ky0:Number = _0kuchi.y0 * (1 - value) + _1kuchi.y0 * value;
		var kx1:Number = _0kuchi.x1 * (1 - value) + _1kuchi.x1 * value;
		var ky1:Number = _0kuchi.y1 * (1 - value) + _1kuchi.y1 * value;
		var kx2:Number = _0kuchi.x2 * (1 - value) + _1kuchi.x2 * value;
		var ky2:Number = _0kuchi.y2 * (1 - value) + _1kuchi.y2 * value;
		var kc:Number = rgbMix(value, _0kuchi.color, _1kuchi.color);
		
		this.graphics.clear();
		this.graphics.beginFill(kc, 1);
		this.graphics.moveTo(kx0, ky0);
		this.graphics.lineTo(kx1, ky1);
		this.graphics.lineTo(kx2, ky2);
		this.graphics.lineTo(kx0, ky0);
		this.graphics.endFill();
		
		//本体
		var dx:Number = _0body.x * (1 - value) + _1body.x * value;
		var dy:Number = _0body.y * (1 - value) + _1body.y * value;
		var dw:Number = _0body.width * (1 - value) + _1body.width * value;
		var dh:Number = _0body.height * (1 - value) + _1body.height * value;
		var dr:Number = _0body.r * (1 - value) + _1body.r * value;
		var dc:Number = rgbMix(value, _0body.color, _1body.color);
		
		this.graphics.beginFill(dc);
		this.graphics.drawRoundRect(dx, dy, dw, dh, dr, dr);
		this.graphics.endFill();
		
		
		if(_0content){
			_0content.x = dx + Math.round((dw - _0content.width) / 2);
			_0content.y = dy + Math.round((dh - _0content.height) / 2);
			_0content.alpha = 1 - (value * 10);
			_0content.visible = _0content.width < dw && _0content.alpha > 0;
			if (value == 0) {
				_0content.x = Math.round(_0content.x);
				_0content.y = Math.round(_0content.y);
			}
		}
		
		if(_1content){
			_1content.x = dx + ((dw - _1content.width) / 2);
			_1content.y = dy + ((dh - _1content.height) / 2);
			_1content.alpha = (value-0.9) * 10;
			_1content.visible = _1content.width < dw && _1content.alpha > 0;
			if (value == 1) {
				_1content.x = Math.round(_1content.x);
				_1content.y = Math.round(_1content.y);
			}
		}
	}
	public function rgbMix(value:Number, aColor:uint, bColor:uint):uint {
		var aR:int = (aColor >> 16 & 0xFF);
		var aG:int = (aColor >> 8 & 0xFF);
		var aB:int = (aColor & 0xFF);
		
		var bR:int = (bColor >> 16 & 0xFF);
		var bG:int = (bColor >> 8 & 0xFF);
		var bB:int = (bColor & 0xFF);
		
		var R:uint = aR * (1 - value) + bR * value;
		var G:uint = aG * (1 - value) + bG * value;
		var B:uint = aB * (1 - value) + bB * value;
		
		return (R << 16) + (G << 8) + B;
	}
}