/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eNnn
 */

package {
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _prev:uint;

        private var w:uint = 232;
        private var h:uint = 232;
        
        public function FlashTest() {
            init();

            this.addEventListener(Event.ENTER_FRAME, proc);
        }
        
        private function proc(e:Event):void {
            var date:Date = new Date();
            var current:uint = ((date.hours * 60 * 60) + (date.minutes * 60) + (date.seconds)) / (24 * 60 * 60) * (w * h);
            if (current > _prev) {
                var x:uint = current % w;
                var y:uint = current / w;
                
                this.graphics.beginFill(0xffffff);
                this.graphics.drawCircle(x * 2 + 1, y * 2 + 1, 1);
                this.graphics.endFill();
            }
            else if (current < _prev) {
                init();
            }

            _prev = current;
        }
        
        private function init():void {
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0, 0, 464, 464);
            this.graphics.endFill();

            var date:Date = new Date();
            var current:uint = ((date.hours * 60 * 60) + (date.minutes * 60) + (date.seconds)) / (24 * 60 * 60) * (w * h);
            for (var index:uint = 0; index < w * h; ++index) {
                var x:uint = index % w;
                var y:uint = index / w;
                
                var past:Boolean = (current >= index);
                
                var color:uint = past ? 0xffffff : 0x808080;
                this.graphics.beginFill(color);
                this.graphics.drawCircle(x * 2 + 1, y * 2 + 1, 1);
                this.graphics.endFill();
            }            
        }


    }
}