/**
 * Copyright blamfantastico ( http://wonderfl.net/user/blamfantastico )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eMjv
 */

// forked from blamfantastico's forked from: Circles/Squares
// forked from noonat's Circles/Squares
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    
    public class Squares extends Sprite {
        static protected const RAD_TO_DEG:Number = 180 / Math.PI;
        protected var _angleOffset:Number = 15;
        protected var _rings:Array = [];
        protected var _text:TextField;
        
        function Squares() {
            addChild(_text = new TextField());
            addEventListener(Event.ADDED_TO_STAGE, onAddedToStage, false);
            addEventListener(Event.ENTER_FRAME, onEnterFrame, false);
        }
        
        protected function onAddedToStage(event:Event):void {
            stage.frameRate = 30;
            
            graphics.beginFill(0x606060);
            graphics.drawRect(-2000, -2000, 4000, 4000);
            graphics.endFill();
            
            var centerX:Number = 0;//stage.stageWidth / 2;
            var centerY:Number = 0;//stage.stageHeight / 2;
            
            var angleOffset:Number = _angleOffset;
            var radius:Number = 50;
            var squares:Number = 10;
            var squareSpacing:Number = (Math.PI / 10) * radius;
            for (var i:uint = 0; i < 4; ++i) {
                _rings[i] = [];
                var color:uint = 0x0000ff;
                var angleIncrement:Number = (((2 * Math.PI) * radius) / squares) / radius;
                for (var j:uint = 0; j < squares; ++j) {
                    color = (color == 0xdddddd) ? 0x222222 : 0xdddddd;
                    var angle:Number = j * angleIncrement;
                    var x:Number = centerX + Math.sin(angle) * radius;
                    var y:Number = centerY - Math.cos(angle) * radius;
                    var square:Square = new Square(x, y, angle, color);
                    square.rotation = (angle * RAD_TO_DEG) + angleOffset;
                    _rings[i].push(square);
                    addChild(square);
                }
                angleOffset *= -1;
                radius += 38;
                squares += 15;
            }
        }
        
        protected function onEnterFrame(event:Event):void {
            x = stage.stageWidth / 2;
            y = stage.stageHeight / 2;
            //rotation -= 1;
            //rotateSquares();
        }
        
        protected function rotateSquares():void {
            _angleOffset = (_angleOffset + 1) % 360;
            var angleOffset:Number = _angleOffset;
            for each (var ring:Array in _rings) {
                for each (var square:Square in ring) {
                    square.rotation = (square.angle * RAD_TO_DEG) + angleOffset;
                }
                angleOffset *= -1;
            }
        }
    }
}

import flash.display.Sprite;

class Square extends Sprite {
    static protected const RAD_TO_DEG:Number = 180 / Math.PI;
    public var angle:Number;
    
    function Square(x:Number, y:Number, angle:Number, color:uint) {
        graphics.clear();
        //graphics.beginFill(color);
        graphics.lineStyle(5, color, 1, true, 'none', 'miter', 'square');
        graphics.drawRect(-4, -4, 8, 8);
        this.angle = angle;
        this.x = x;
        this.y = y;
    }
}