/**
 * Copyright atsushi015 ( http://wonderfl.net/user/atsushi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eK8n
 */

package {
	/* コンピュータの描画技術は驚異的な進化を遂げ、人類を脅かしつつある。
	 * 我々がこの脅威に対抗するにはどうすればよいだろうか？
	　*
	 * 答え：コンピュータがヘタになればよい。
	 *
	 * マウスで画面をドラッグするとヘタな線を書きます。
	 */
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.*;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            graphics.lineStyle(1, 0x6666FF); 
            moveTo(100, 100);
            hetaLineTo(300, 200);
            hetaLineTo(400, 100);
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
        }
        
        public function mouseDown(e:MouseEvent):void {
            graphics.lineStyle(1, 0x6666FF); 
        		moveTo(e.stageX, e.stageY);
        }
        
        public function mouseMove(e:MouseEvent):void {
        		if (e.buttonDown)
        			hetaLineTo(e.stageX, e.stageY);
        }
        
        private var lineX:Number;
        private var lineY:Number;
        private var lineDgr:Number;
        private const lineInterval:Number = 8;
        
        public function moveTo(x:Number, y:Number):void {
        		lineX = x;
        		lineY = y;
        		graphics.moveTo(x, y);
        }
        
        public function hetaLineTo(x:Number, y:Number):void {
	        	var xDiff:Number = x - lineX;
	        	var yDiff:Number = y - lineY;
	        	var length:Number = Math.sqrt(xDiff*xDiff + yDiff*yDiff);
        		
        		while (length > 0) {
	        		var xDiff:Number = x - lineX;
	        		var yDiff:Number = y - lineY;
	        		
	        		// 書こうとしてるラインの角度所得
        			lineDgr = Math.atan2(yDiff, xDiff);
        			
        			lineDgr = lineDgr - Math.random() + Math.random();
        			xDiff = Math.cos(lineDgr) * (lineInterval > length ? length : lineInterval);
        			yDiff = Math.sin(lineDgr) * (lineInterval > length ? length : lineInterval);
        			
        			lineX += xDiff;
        			lineY += yDiff;
        			graphics.lineTo(lineX, lineY);
        			length -= lineInterval;
        		}
        }
    }
}