/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eItS
 */

package {
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
       
            cw=32;ch=32;
            initEmpty(16,16);
            
            var i:int;
            for (i=0;i<64;i+=1)
            { setTile(Math.random()*16,Math.random()*16,1); }             
            
            for (i=0;i<16;i+=1)
            { setTile(i, 0,1); setTile(0,i,1); setTile(i,14,1); setTile(14,i,1); }


             myObj = new xObj();
             myObj.cx = 230;
             myObj.cy = 230;

           stage.addEventListener(KeyboardEvent.KEY_DOWN, onKdown);
           stage.addEventListener(KeyboardEvent.KEY_UP, onKup);
           stage.addEventListener(Event.ENTER_FRAME, onEnter);    
        }//ctor
        
        public function onKdown(e:KeyboardEvent):void { vecKey[e.keyCode] = true; }
        public function onKup(e:KeyboardEvent):void { vecKey[e.keyCode] = false; }
        
        public function isKeyDown(k:int):Boolean { return vecKey[k]; }
        public var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,false);  
          
        public var vecGrid:Vector.<int>;
        public var mw:int = 0;         public var mh:int = 0;
        public var cw:Number = 32;     public var ch:Number = 32;

        public function isWall(ax:int, ay:int):Boolean
        { if (ax<0||ax>=mw||ay<0||ay>=mh){return true;}  return vecGrid[ay*mw+ax] > 0;  } 
        
        public function setTile(ax:int, ay:int, t:int):void
        { if (ax<0||ax>=mw||ay<0||ay>=mh) {return;} vecGrid[ay*mw+ax]=t; }

        public function initEmpty(aw:int, ah:int):void
        { mw=aw; mh=ah; vecGrid = new Vector.<int>(aw*ah, false); }
      
      
          public var myObj:xObj;  

        public function onEnter(e:Event):void
        {
          graphics.clear();
           graphics.lineStyle(2, 0);  
            
            var i:int; var k:int; var yt:int; var t:int;
            for (i=0;i<mh;i++)
            {
             yt = i * mw;
             for (k=0;k<mw;k++)
             {
               t = vecGrid[k+yt];
               if (t > 0)
               {
                 graphics.beginFill(0x404040, 1);
                   graphics.drawRect(k*cw,i*ch,cw,ch);               
                 graphics.endFill();  
                   continue;
               }//endif
             }//nextk
            }//nexti 

            var a:xObj;
            a = myObj;
            
            var ms:Number; ms = 0.2;
            if (isKeyDown(Keyboard.LEFT)) { a.vx -= ms; }
            if (isKeyDown(Keyboard.RIGHT)) { a.vx += ms; }
            if (isKeyDown(Keyboard.UP)) { a.vy -= 0.5; }
            
            a.vx *= 0.95;            
            a.vy +=0.2;
            
            ms = 8;
            if (a.vx > ms) { a.vx = ms; } else if (a.vx < -ms) { a.vx = -ms; }
            if (a.vy > ms) { a.vy = ms; } else if (a.vy < -ms) { a.vy = -ms; }
            
            gridTest(a);
            gridTest(a);
            a.cx +=a.vx;
            a.cy +=a.vy;
            
            graphics.drawCircle(a.cx,a.cy, a.rad);
              
            
        }//onenter
        

        public function getMag(ax:Number, ay:Number):Number
        { return Math.sqrt(ax * ax + ay * ay); }

        public function gridTest(a:xObj):void
        {
          var i:int; var k:int;
          var ax:int; var ay:int;
          var ix:Number; var iy:Number;
          var d:Number; var ta:Number;
          var nx:Number; var ny:Number;
          var dot:Number;
          var bx:Number; var by:Number;
          
          ax = a.cx / cw; ay = a.cy / ch;
          for (i = -1; i <= 1; i += 1) 
          for (k = -1; k <= 1; k += 1) 
          {
            if (isWall(ax+k, ay+i)==false) { continue; }

             bx = (ax+k)*cw; by = (ay+i)*ch;
                
             if (a.cx < bx) {ix = bx; }
             else if (a.cx > bx+cw)  { ix = bx+ cw; }
             else {ix=a.cx;}
             if (a.cy < by) {iy = by; }
             else if (a.cy > by+ch)  { iy = by+ ch; }
             else {iy=a.cy;}
             
               d = getMag(a.cx-ix, a.cy-iy);
               if (d > a.rad) { continue; }
               
                ta = Math.atan2(iy - a.cy, ix - a.cx);
                a.cx += Math.cos(ta) * (d - a.rad)*0.5;
                a.cy += Math.sin(ta) * (d - a.rad)*0.5;
                nx = Math.cos(ta); ny = Math.sin(ta);  
    
               dot = a.vy * ny + a.vx * nx;
               if (dot > 0)
               {  a.vx -=  nx * dot;  a.vy -=  ny * dot;  }
          }//nextki
    
        }//gridtest
        
        
        
    }//classend
}

internal class xObj
{
  public var cx:Number = 0;  public var cy:Number = 0;
  public var vx:Number = 0;  public var vy:Number = 0;   
  public var rad:Number = 16;  
    
}//xobj


