/**
 * Copyright tonpoo ( http://wonderfl.net/user/tonpoo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eIOv
 */

package {
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	public class FlashTest extends Sprite {
		public function FlashTest() {
			//Btnインスタンスを100コ生成
			for (i = 0; i < 100; i++ ) {
				//Btnインスタンスの生成と表示リストへの追加
				btn = new Btn();
				this.addChild(btn);
				//各インスタンスのidプロパティに数値iを記録
				btn.id = i;
				//イベントリスナーを登録
				btn.addEventListener(MouseEvent.CLICK, onBtnClick, false, 0, true);
				//ステージ上のランダムな場所に配置
				btn.x = Math.floor(Math.random() * this.stage.stageWidth);
				btn.y = Math.floor(Math.random() * this.stage.stageHeight);
			}
			//出力表示用TextFieldの生成
			traceField = new TextField();
			this.addChild(traceField);
			traceField.width = this.stage.stageWidth;
			traceField.height = 20;
			traceField.border = true;
			traceField.background = true;
		}

		private var traceField:TextField;
		private var btn:Btn;
		private var i:uint;

		private function onBtnClick(e:MouseEvent):void {
			//Btnインスタンスのidプロパティの値を出力
			btn = e.target as Btn;
			traceField.text = "私のIDは" + String(btn.id) + "です。";
		}
	}
}

/*
 * Spriteクラスを拡張したボタン用クラス。
 * */
import flash.display.Sprite;
class Btn extends Sprite {
	public function Btn() {
		//赤丸の描画
		this.graphics.beginFill(0xFF0000);
		this.graphics.drawCircle(0, 0, 6);
		this.graphics.endFill();
		//ハンドカーソルの有効化
		this.buttonMode = true;
	}
	public var id:uint;	//idプロパティを用意
}