/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eHvy
 */

package {
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.display.StageAlign;
    import flash.events.Event;
    import flash.geom.Point;
    import net.hires.debug.Stats;
    
    [SWF(backgroundColor=0x000000)]
    public class FlashTest extends Sprite {
        
        private var particles:Array;
        private var numParticles:uint = 30;
        private var minDist:Number = 200;
        private var springAmount:Number = 0.0002;
        
        public function FlashTest() {
            // write as3 code here..
            addChild(new Stats);
            init();
        }
        
        private function init():void
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            particles = new Array();
            
            for(var i:uint = 0;i < numParticles; i++)
            {
                var particle:Ball = new Ball(3, 0xFFFFFF);
                particle.x = Math.random() * stage.stageWidth;
                particle.y = Math.random() * stage.stageHeight;
                particle.vx = Math.random() * 4 - 3;
                particle.vy = Math.random() * 4 - 3;
                stage.addChild(particle);
                particles.push(particle);
            }
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            graphics.clear();
            for(var i:uint = 0;i < numParticles; i++)
            {
                var particle:Ball = particles[i];
                particle.x += particle.vx;
                particle.y += particle.vy;
                if(particle.x >= stage.stageWidth)
                {
                    particle.x = 0;
                }
                else if(particle.x < 0)
                {
                    particle.x = stage.stageWidth - 1;
                    
                }
                
                if(particle.y >= stage.stageHeight)
                {
                    particle.y = 0;
                }
                else if(particle.y < 0)
                {
                    particle.y = stage.stageHeight - 1;
                }
            }
            
            for(i = 0;i < numParticles - 1;i++)
            {
                var partA:Ball = particles[i];
                for(var j:uint = i + 1;j < numParticles; j++)
                {
                    var partB:Ball = particles[j];
                    spring(partA, partB);
                }

            }

        }
        
        private function spring(partA:Ball, partB:Ball):void
        {
            var dx:Number = partB.x - partA.x;
            var dy:Number = partB.y - partA.y;
            var dist:Number = Math.sqrt(dx * dx + dy * dy);
            
            if(dist < minDist)
            {
                graphics.lineStyle(1, 0xFFFFFF, 1 - dist / minDist);
                graphics.moveTo(partA.x, partA.y);
                graphics.lineTo(partB.x, partB.y);
                
                var ax:Number = dx * springAmount;
                var ay:Number = dy * springAmount;
                
                partA.vx += ax;
                partA.vy += ay;
                partB.vx -= ax;
                partB.vy -= ay;
            }

        }


    }
}

import flash.display.Sprite;

class Ball extends Sprite
{
    private var _color:uint;
    private var _radius:Number;
    private var _vx:Number;
    private var _vy:Number;
    
    public function Ball(radius:Number, color:uint = 0xFFFFFF)
    {
        _radius = radius;
        _color = color;
        draw();
    }
    
    public function draw():void
    {
        graphics.clear();
        graphics.lineStyle(0);
        graphics.beginFill(_color, 0.5);
        graphics.drawCircle(0, 0, _radius);
        graphics.endFill();
        graphics.drawCircle(0, 0, 1);
    }
    
    public function update():void
    {
        x += _vx;
        y += _vy;
    }
    
    public function set color(value:uint):void
    {
        _color = value;
        draw();
    }
    
    public function get color():uint
    {
        return _color;
    }
    
    public function set radius(value:Number):void
    {
        _radius = value;
        draw();
    }
    
    public function get radius():Number
    {
        return _radius;
    }
    
    public function set vx(value:Number):void
    {
        _vx = value;
    }
    
    public function get vx():Number
    {
        return _vx;
    }
    
    public function set vy(value:Number):void
    {
        _vy = value;
    }
    
    public function get vy():Number
    {
        return _vy;
    }
}