/**
 * Copyright yotsu42keisuke ( http://wonderfl.net/user/yotsu42keisuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eHgg
 */

// forked from yabuchany's DrawSound
// http://wsapl.blogspot.com/2010/09/as3.html の「AS3で筆順再生をやってみた」の記事のソースを元にしました。
// http://wonderfl.net/c/5N1Lの「Particle Light」のソースを参考にStarDustでパーティクルを発生させて、
// http://wonderfl.net/c/ovlEの「Arpeggiatorを使う」のソースのマウス座標で音が変化する部分を筆順再生する時の各座標に変更しています。
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.MovieClip;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.filters.GlowFilter;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.emitters.Emitter;
    import idv.cjcat.stardust.common.renderers.Renderer;
    import idv.cjcat.stardust.twoD.renderers.BitmapRenderer;
    import frocessing.color.ColorHSV;
    
    //sion----------------------------------------------------------
    import org.si.sion.SiONData;
    import org.si.sion.SiONDriver;
    import org.si.sion.events.SiONEvent;
    import org.si.sion.utils.Scale;
    import org.si.sion.utils.SiONPresetVoice;
    import org.si.sound.Arpeggiator;    
    //sion----------------------------------------------------------
    
    //bit101--------------------------------------------------------
    import com.bit101.components.*;
    //bit101--------------------------------------------------------
    
    

    [SWF(width = "465", height = "465", backgroundColor = "0x000000", frameRate = "60")]

    public class DrawSound extends Sprite {
        private var ball:Ball = new Ball();
        private var shape:Shape = new Shape();
        private var line:Graphics = shape.graphics;
        private var linearray:Array = new Array();
        private var mouse:Boolean;
        private var count:int;
        private var now_play:Boolean;
        protected var emitter:Emitter;// エミッター
        protected var renderer:Renderer;// レンダラー
        private const stw:uint = stage.stageWidth,sth:uint = stage.stageHeight;
        private var _hsv:ColorHSV;
        private var _bmd:BitmapData;
        private var _blurBmd:BitmapData;
        private var _ctf:ColorTransform;
        
        private var bm:Bitmap;
        private var bbm:Bitmap;
        //color---------------------------------------------------------
        
        //sion----------------------------------------------------------
        private var arpeggiator:Arpeggiator;
        public var driver:SiONDriver = new SiONDriver();
        private var rythmLoop:SiONData;
        private var presetVoice:SiONPresetVoice = new SiONPresetVoice();
        
        private var px:Number=0;
        private var py:Number=0;
        //sion----------------------------------------------------------
        
        public function DrawSound():void {
            Wonderfl.capture_delay(30);
            addChild(shape);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mousedownHandler);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mousemoveHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseupHandler);
            //bit101--------------------------------------------------------
            new PushButton(this, stage.stageWidth/2-50, 445, "CLEAR", playstop);
            //bit101--------------------------------------------------------
        }
        public function mousedownHandler(event:MouseEvent):void{
            if(area(mouseX,mouseY)){
                if (! now_play) {
                    linearray = new Array();
                    //line.clear();
                    line.lineStyle(0,0xffffff,.5,true);
                    line.moveTo(mouseX,mouseY);
                    mouse = true;
                    linearray.push(new Point(mouseX,mouseY));
                }
            }
        }

        public function mousemoveHandler(event:MouseEvent):void{
            if(area(mouseX,mouseY)){
                if(mouse){
                line.lineTo(mouseX,mouseY);
                linearray.push(new Point(mouseX,mouseY));
                }
            }
        }

        public function mouseupHandler(event:MouseEvent):void{
            if(!now_play && mouse){
                mouse = false;
                play_lines();
            }
        }

        public function play_lines():void{
            count = 0;
            now_play = true;
            line.clear();
            addChild(ball);
            count++;
            _hsv = new ColorHSV(0, .8, .95);
            _bmd = new BitmapData(465, 430, false, 0);
            _ctf = new ColorTransform(.95, .9, .7);
            bm = new Bitmap(_bmd);
            bbm = new Bitmap(_blurBmd = _bmd.clone());
            bbm.blendMode = "add"
            addChild(bm);
            addChild(bbm);
            // パーティクルシステムの構築
            //
            // [1]clockを作成 [2]エミッターを作成
            emitter = new MyEmitter(new SteadyClock(6)); // エミッターに1フレームに発生させたい数値を指定
            // [3]レンダラーを作成 (MCを指定)
            renderer = new BitmapRenderer(_bmd);
            // [4]レンダラーにエミッターを追加
            renderer.addEmitter(emitter);
                //sion----------------------------------------------------------
                initSound();
                soundStart();
                //sion----------------------------------------------------------
            addEventListener(Event.ENTER_FRAME,startHandler);
        }

        public function startHandler(event:Event):void {
            linearray.reverse();
            if(count<linearray.length){
                ball.x = linearray[count].x;
                ball.y = linearray[count].y;
                _ctf.redMultiplier = (_hsv.value >> 16 & 0xff) / 255;
                _ctf.greenMultiplier = (_hsv.value >> 8 & 0xff) / 255;
                _ctf.blueMultiplier = (_hsv.value & 0xff) / 255
                //
                _bmd.colorTransform(_bmd.rect, _ctf)
                _bmd.applyFilter(_bmd, _bmd.rect, new Point(), new BlurFilter(8, 8, 3))
                _blurBmd.copyPixels(_bmd, _bmd.rect, new Point())
                //
                MyEmitter(emitter).point.x = linearray[count].x;
                MyEmitter(emitter).point.y = linearray[count].y;
                //
                _hsv.h++;
                emitter.step();
                count++;
            }
            else{
                removeEventListener(Event.ENTER_FRAME,startHandler);
                //linearray = new Array();
                now_play = false;
                removeChild(ball);
                removeChild(bm);
                removeChild(bbm);
                play_lines2();
                
            }
        }
        public function play_lines2():void{
            count = 0;
            now_play = true;
            line.clear();
            addChild(ball);
            count++;
            _hsv = new ColorHSV(0, .8, .95);
            _bmd = new BitmapData(465, 430, false, 0);
            _ctf = new ColorTransform(.95, .9, .7);
            //
            bm = new Bitmap(_bmd);
            bbm = new Bitmap(_blurBmd = _bmd.clone());
            bbm.blendMode = "add"
            addChild(bm);
            addChild(bbm);
            // パーティクルシステムの構築
            //
            // [1]clockを作成 [2]エミッターを作成
            emitter = new MyEmitter(new SteadyClock(6)); // エミッターに1フレームに発生させたい数値を指定
            // [3]レンダラーを作成 (MCを指定)
            renderer = new BitmapRenderer(_bmd);
            // [4]レンダラーにエミッターを追加
            renderer.addEmitter(emitter);
            addEventListener(Event.ENTER_FRAME, startHandler);
        }

        public function area(xx:Number,yy:Number):Boolean{
            var bool:Boolean;
            if((xx>0&&xx<465)&&(yy>0&&yy<445)){
                bool = true;
            }
            return bool;
        }
        
        
        
        private function initSound():void {
            var mml:String = "t132;";
            rythmLoop = driver.compile(mml);
            rythmLoop.setVoice(0, presetVoice["valsound.percus1"]);
            arpeggiator = new Arpeggiator(new Scale("o1Ajap"), 1, [0,1,2,5,4,3]);
            //arpeggiator.voice = presetVoice["valsound.piano8"];
            //arpeggiator.voice = presetVoice["valsound.wind1"];
            //arpeggiator.voice = presetVoice["valsound.guitar2"];
            //arpeggiator.voice = presetVoice["valsound.percus25"];
            arpeggiator.voice = presetVoice["valsound.percus1"];    // おもしろい
            //arpeggiator.voice = presetVoice["valsound.lead25"];
            //arpeggiator.voice = presetVoice["valsound.percus13"];
            arpeggiator.quantize = 4;
            arpeggiator.volume = 0.3;
            arpeggiator.noteQuantize = 8;
            
            
            driver.addEventListener(SiONEvent.STREAM, onStreamHandler);
            driver.play(rythmLoop);
            
            //bug??
            //arpeggiator.noteOn();
            //arpeggiator.noteOff();
            arpeggiator.pattern = [0,1,2,5,4,3];
        }
        
        
        private function onStreamHandler(e:SiONEvent):void {
            // update arpeggiator pitch and length
            setPxPy();
            arpeggiator.scaleIndex = px * 24;
            arpeggiator.noteLength = [0.5,1,1,2,4][int(py * 4 + 0.99)];
        }
        
        public function soundStart():void {
            setPxPy();
            arpeggiator.scaleIndex = px*24;
            arpeggiator.noteLength = [0.5,1,1,2,4][int(py * 4 + 0.99)];
            // start arpeggio
            arpeggiator.play();
        }
        
        private function setPxPy():void {
            px = ball.x/ 465;
            py = ball.y/ 430;
            if(px<0)px=0;
            if(px>0.9)px=0.9;
            if(py<0)py=0;
            if(py>0.9)py=0.9;
        }
        private function playstop(e:MouseEvent):void{
            //driver.sequenceOff(0, 0, 0);
                removeEventListener(Event.ENTER_FRAME,startHandler);
                linearray = new Array();
                now_play = false;
                removeChild(ball);
                removeChild(bm);
                removeChild(bbm);
                //sion----------------------------------------------------------
                driver.stop();
                //sion----------------------------------------------------------
                mouse = true;                
        }
    }
}

//エミッター
import idv.cjcat.stardust.common.actions.*;
import idv.cjcat.stardust.common.clocks.*;
import idv.cjcat.stardust.common.initializers.*;
import idv.cjcat.stardust.common.math.*;
import idv.cjcat.stardust.twoD.actions.*;
import idv.cjcat.stardust.twoD.emitters.*;
import idv.cjcat.stardust.twoD.initializers.*;
import idv.cjcat.stardust.twoD.zones.*;
import idv.cjcat.stardust.twoD.renderers.*;
import idv.cjcat.stardust.twoD.fields.BitmapField;
import idv.cjcat.stardust.twoD.fields.UniformField;

class MyEmitter extends Emitter2D {
    public var point:SinglePoint = new SinglePoint(); // パーティクルの発生位置
    
    public function MyEmitter(clock:Clock = null) {
        //-- パーティクルシステムの構築
        super(clock);
        // [5]イニシャライザーを登録;
        // パーティクルのアイテムを指定
        addInitializer(new DisplayObjectClass(Ball));
        // パーティクルにかかる力を指定;
        addInitializer(new Velocity(new LazySectorZone(0.1, .4)));
        // パーティクルのライフ(生存)を指定;
        addInitializer(new Life(new UniformRandom(40, 20)));
        addInitializer(new Position(point));        

        // [6]アクションを登録
        addAction(new AlphaCurve(20,40));
        
        addAction(new Age());
        // 寿命を有効化;
        addAction(new DeathLife());
        // 消えるを有効化;
        addAction(new Accelerate(0.05));
        // 加速を有効化;
        addAction(new Move());
        // 移動を有効化;
        
        var bmpField:BitmapField = new BitmapField();
        bmpField.max = 0.1;
        bmpField.massless = false;
        bmpField.scaleX = bmpField.scaleY = 0;
        
        // 重力;
        var gravity:Gravity = new Gravity();
        gravity.addField(bmpField);
        gravity.addField(new UniformField( 0, 0.01)); // x , y
        addAction(gravity);
    }
}

import flash.display.Shape;
class Ball extends Shape {
    public function Ball() {
        graphics.beginFill (0xFFFFFF,1.0);
        graphics.drawCircle(0, 0, Math.random()*30 | 0);
        graphics.endFill()
    }
}