/**
 * Copyright osamX ( http://wonderfl.net/user/osamX )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eHQK
 */

package 
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	
	[SWF(width=465, height=465, backgroundColor=0x000000, frameRate=30)]
	public class Main extends Sprite 
	{
		private const SIZE:Number = 50;
		private const NUM:uint = 10;
		private const PI:Number = Math.PI;
		private var g:Graphics;
		private var mouseP:Point = new Point();
		
		public function Main():void 
		{
			g = this.graphics;
			var r:Number = 0;
			addEventListener(Event.ENTER_FRAME, function (e:Event):void {
				mouseP.x += (stage.mouseX - mouseP.x) / 5;
				mouseP.y += (stage.mouseY - mouseP.y) / 5;
				r = (r + 6) % 360;
				g.clear();
				render(r, Math.atan((465/2-mouseP.y)/(465/2-mouseP.x)));
			});
		}
		
		private function render(offsetR:Number, mouseR:Number):void {
			var offsetY:Number = 465/2-NUM/2, radian:Number, color:uint, dif:Number,
				lastP:Point = new Point(), currentP:Point = new Point();
			for (var yy:int = 0; yy < NUM; yy++) {
				radian = (5 * yy + offsetR) % 360;
				for (var xx:int = 0; xx < 465; xx++) {
					currentP.x = xx;
					currentP.y = SIZE * Math.sin(PI*radian/180) + yy + offsetY;
					if (!xx) {
						g.moveTo(currentP.x, currentP.y);
					}
					else {
						dif = Math.abs( mouseR - Math.atan((currentP.y - lastP.y) / (currentP.x - lastP.x)) );
						if (dif > PI / 2) dif = PI - dif;
						color = 0xFF*dif/(PI/2);
						g.lineStyle(1, color<<16|color<<8|color);
						g.lineTo(currentP.x, currentP.y);
					}
					lastP.x = currentP.x;
					lastP.y = currentP.y;
					radian = (radian + 1) % 360;
				}
			}
			g.lineStyle(1, color<<16|color<<8|color);
			g.moveTo(mouseP.x, mouseP.y);
			g.lineTo(465 / 2, 465 / 2);
		}
	}
}