/**
 * Copyright Mick.Surdenik ( http://wonderfl.net/user/Mick.Surdenik )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eHHn
 */

// forked from bkzen's Sound fall
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.utils.getTimer;
    import frocessing.color.ColorHSV;
    
    /**
     * sound by AlainMikuni
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000000", frameRate = "60", width = "512", height = "512")]
    public class Test8 extends Sprite 
    {
        private var sound: Sound;
        private var bmd: BitmapData;
        private var bytes: ByteArray = new ByteArray();
        private var color: ColorHSV = new ColorHSV();
        
        public function Test8() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            //
            addChild(new Bitmap(bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0), "auto", true));
            initSound();
        }
        
        private function initSound():void 
        {
            var url: String = "http://caster.fnshosting.com:8118/live";
            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, onCompLoadSound);
            sound.load(new URLRequest(url), new SoundLoaderContext(10, true));
        }
        
        private function onCompLoadSound(e: Event): void 
        {
            sound.removeEventListener(Event.COMPLETE, onCompLoadSound);
            var channel: SoundChannel = sound.play(0, 10, new SoundTransform(0.5));
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e: Event): void 
        {
            var i: int, n: Number, t: Number = getTimer() / 200;
            bytes.length = 0;
            SoundMixer.computeSpectrum(bytes, true);
            
            bmd.lock();
            for (i = 0; i < 256; i++) 
            {
                n = bytes.readFloat();
                color.v = n * 3;
                color.h = 360 * i / 256 + t;
                bmd.setPixel(256 - i, 0, color.value);
            }
            for (; i < 512; i++) 
            {
                n = bytes.readFloat();
                color.v = n * 3;
                color.h = 360 * i / 256 + t;
                bmd.setPixel(i, 0, color.value);
            }
            bmd.scroll(0, 1);
            bmd.unlock();
        }
        
    }

}