/**
 * Copyright hacker_d0o9tz6n ( http://wonderfl.net/user/hacker_d0o9tz6n )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eH6e
 */

// forked from clockmaker's Text Particle by Tweener
/**
* 昔のファイルを降り起こしたら出てきたので、
* リサイクル的なスタンスで投稿。オリジナルは08/05/27頃に作成。
* マウスの位置からテキストパーティクルがでてきます。
*/
package
{
    
    // Tweener
    import caurina.transitions.Tweener;
    
    // Flash
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.text.*;
    import flash.utils.*;
    
    [SWF(width="465",height="465",frameRate="60",backgroundColor="0x0")]
    
    public class ParticlePlayGround extends Sprite
    {
        // 定数
        private const PARTICLE_ROUND   :int = 100;
        private const PARTICLE_AMOUNT  :int = 4;
        private const PARTICLE_INTERVAL:int = 20;
        private const MOUSE_INTERVAL   :int = 10;
        private const FONT_SIZE        :int = 64;
        
        // マウス追随用の変数
        private var oldX:Number;
        private var oldY:Number;
        private var world:Sprite;
        
        /**
         * コンストラクタ 
         */            
        public function ParticlePlayGround()
        {
            graphics.beginFill(0x0);
            graphics.drawRect(0,0,465,465);
            
            // パーティクル生成タイマー
            var particleTimer:Timer = new Timer(PARTICLE_INTERVAL);
            particleTimer.start();
            particleTimer.addEventListener(TimerEvent.TIMER, createParticle );
            
            // マウス追随タイマー
            var mouseTimer:Timer = new Timer(MOUSE_INTERVAL);
            mouseTimer.start();
            mouseTimer.addEventListener(TimerEvent.TIMER, drawMouseLine );
        }
        
        
        /**
         * パーティクル生成 
         * @param event
         */        
        private function createParticle(event:TimerEvent):void
        {
            if(oldX == mouseX && oldY == mouseY) return;
            
            for(var i:int=0; i<PARTICLE_AMOUNT; i++)
            {
                var mc:MovieClip = new MovieClip();
                
                //テキストフォーマット作成
                var fontsize:int = Math.random() * FONT_SIZE | 0;
                
                var fmt:TextFormat = new TextFormat();
                fmt.size  = fontsize;
                fmt.align = TextFormatAlign.LEFT;
                fmt.color = 0xffffff * Math.random();
                
                // ランダムにアルファベットを設定(文字コードから算出)
                var charCode:uint = (Math.random() * 25) | 0 + 65;
                
                //テキストフィールド作成
                var tf:TextField = new TextField();
                tf.defaultTextFormat = fmt;
                tf.text = String.fromCharCode(charCode);
                tf.selectable = false;
                
                //表示
                mc.addChild(tf);
                mc.x = mouseX;
                mc.y = mouseY;
                
                if(fontsize > FONT_SIZE * .8)      {mc.filters = [ new BlurFilter(8, 8, 1) ];mc.blendMode = BlendMode.ADD;}
                else if(fontsize > FONT_SIZE * .6) mc.filters = [ new BlurFilter(4, 4, 1) ]
                else                               mc.filters = [ new BlurFilter(1, 1, 1) ]
                
                Tweener.addTween(mc,
                {
                    x : mouseX + Math.random()*PARTICLE_ROUND - PARTICLE_ROUND/2 - (mouseX - oldX)*2,
                    y : mouseY + Math.random()*PARTICLE_ROUND - PARTICLE_ROUND/2 - (mouseY - oldY)*2,
                    alpha      : 0,
                    time       : 3,
                    transition : "easeOutExpo",
                    onCompleteParams:[this, mc],
                    onComplete : function(w:Sprite, obj:MovieClip):void{ w.removeChild(obj) }
                });
                
                this.addChild(mc);
                
            }
        }
        
        /**
         * マウス追随を描画 
         * @param event
         */        
        private function drawMouseLine(event:TimerEvent):void
        {
            
            var sp:Sprite = new Sprite();
            sp.graphics.lineStyle(1, 0x0099CC);
            sp.graphics.moveTo(oldX, oldY);
            sp.graphics.lineTo(mouseX, mouseY);
            addChild(sp);
            
            oldX = mouseX;
            oldY = mouseY;
            
            Tweener.addTween(sp,
            {
                alpha      : 0,
                time       : 3,
                onComplete : function():void{ removeChild(sp); }
            });
            
        }
    }
}
