/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eH1t
 */

package {
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {

            deb = new TextField();
             deb.width =320; deb.height=240;
             deb.mouseEnabled = false;
            addChild(deb);

          stage.addEventListener(MouseEvent.CLICK, onClick);
          stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor

        public var deb:TextField;

        public function onClick(e:MouseEvent):void
        {
            rad = 32 + Math.random()*256;
        }//onclick
        
        public var rad:Number = 128;

        public function onEnter(e:Event):void
        {
            var mx:Number;      var my:Number;
            var ax:Number;      var ay:Number;
            
            mx = stage.mouseX;
            my = stage.mouseY;
            
            ax = 230;
            ay = 230;
            
            
            graphics.clear();
            graphics.lineStyle(2,0);
            
            graphics.beginFill(0,1);
            graphics.drawCircle(ax,ay, 8);
            graphics.endFill();
            
            graphics.drawCircle(mx,my, 8);
            
            
            var d:Number;
            d = getDist(mx-ax,my-ay);
            if (d < 1 ) { d = 1; }
            
            var m:Number;
            m = 1.0 - ( d / rad );
            if (m < 0) { m = 0; }
            deb.text = " " + d + " \n" +m;
            
            graphics.drawCircle(ax,ay, rad);
            
            graphics.lineStyle(4*m, 0, m);
            graphics.drawCircle(ax,ay, d);
            
            var nx:Number; var ny:Number;
            var ang:Number;
            ang = Math.atan2(my-ay,mx-ax);
            nx = Math.cos(ang);
            ny = Math.sin(ang);
            
            graphics.lineStyle(2,0);
            graphics.moveTo(mx,my);
            graphics.lineTo(mx+nx*32*m, my+ny*32*m);
            
            
        }//onenter
        
        public function getDist(ax:Number, ay:Number):Number
        { return Math.sqrt(ax*ax+ay*ay); }
        
        
    }//classend
}