/**
 * Copyright mtok ( http://wonderfl.net/user/mtok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eGvY
 */

package  
{
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensyTimeline;
	import flash.utils.setInterval;
	import flash.utils.clearInterval;
	import flash.display.Sprite;
	import fl.motion.easing.Linear;
	import fl.motion.easing.Exponential;
	[SWF(width="465", height="465")]
	/**
	 * Tweensy のupdateToのサンプル。
         * ドキュメントが分りづらかったのでコードで確認。
         * durationの残り時間が０の時にupdateToするとエラーは出ないが、
         * 当然おかしな計算結果になる。
         * updateToを使ってトゥィーンしているときに、挙動がおかしなときは
         * 疑ってみるべし。
         *
	 * @author Motoki Matsumoto
	 */
	
	public class UpdateToExample extends Sprite
	{
		private var _N:int = 30;
		private var _interval:int;
		public function UpdateToExample() 
		{
			var tl:TweensyTimeline;
			var p:Particle;
			
			addChild(p = new Particle());
			tl = Tweensy.to(p, { x:460, y:460 }, 5);
			//tl.ease = Linear.easeNone;
			tl.ease = Exponential.easeInOut;
			tl.repeatType = TweensyTimeline.YOYO;

			_interval = setInterval(function():void { 
				tl.updateTo(p, { x:460, y:0 } );
				trace('update Point');
				clearInterval(_interval);
			}, 2500);

		}
		private function randomColor():uint {
			return 0x00ff00;
		}
	}
}
import flash.display.Sprite;
class Particle extends Sprite
{
	private var _color:uint = 0x000000;
	public function Particle() {
		_redraw();
	}
	private function _redraw():void {
		graphics.clear();
		graphics.beginFill(_color);
		graphics.drawCircle(0, 0, 10);
		graphics.endFill();
	}
	
	public function get color():uint { return _color; }
	
	public function set color(value:uint):void 
	{
		_color = value;
		_redraw();
	}
}