/**
 * Copyright o_healer ( http://wonderfl.net/user/o_healer )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eGtx
 */

/*

「１文字削り（1 char game）」

・指定した１文字でスコアを競うゲーム



概要

・文字を１つ指定し、削りの種類と数に応じたスコアを競うゲーム

・スコアは使用した数を掛けあわせたもの



操作方法（How to Play）

・タイトル（Title）

　・文字を入力（Input string）

　　・１文字まで（1 char limit）

　　・キーボード入力 or 漢字リストからの入力が可能（by Keyboard or Chinese Language Panel）

・ゲーム（Game）

　・ラインをクリック（Click a line）

　　・指定したラインに移動（Move）

　・クリックしたまま（Keep Touching）

　　・ハイスピード（High Speed Mode）



比較用

・Android版（Air）

　・https://play.google.com/store/apps/details?id=air.showohealer.game.airprototype





メモ

・基本的には漢字が強い

　・ただし、爆弾でギリギリ削ることでペンキの回数を増やせるカナがあったりもする

・まんべんなく取ったほうがスコアは高い

　・１０×１０×１０＝１０００が１つの目安

・爆弾で位置を調整し、横線で分断して、ペンキの数を増やすのが基本的なセオリー

　・あとはそれぞれで削る量を小さくすることで回数を増やすなどしていく

*/





/*

- wonderflへのリンクとAndroidへのリンクを分ける

-- wonderflリンク＋wonderflタグ、画像のロード対応

-- Androidリンク



もう少し攻略要素を増やしたい

・今は「こういう処理があるからこういう漢字が強い」という処理ありきの思考パターン

→これを「この漢字ならこういう処理でハイスコアが狙えそう」という文字ありきの思考パターンにしたい

*/



package {

    import flash.display.*;

    import flash.events.*;

    import flash.filters.*;

    import flash.geom.*;

    import flash.net.*;

    import flash.system.*;

    import flash.text.*;

    import flash.utils.*;

    import net.wonderfl.utils.WonderflAPI;



    [SWF(width="465", height="465", frameRate="30", backgroundColor="0x000000")]

    public class TenChar extends Sprite {

        //クラス名がTenCharなのはもともと１０文字だった名残り



        //==File==

//*

        static public const BITMAP_URL:String = "http://assets.wonderfl.net/images/related_images/b/b4/b423/b4233cd0104d89a07dc5549430554799ec9b3ca1";

/*/

        [Embed(source='Result.png')]

         private static var Bitmap_Graphic: Class;

//*/





        //==Const==



        //使用する文字数

        static public const USE_CHAR_NUM:int = 1;//10



        //プレイヤーの表示位置

        static public const PLAYER_X:int = 8;

        static public const HIT_X:int = PLAYER_X + 32;



        //画面の大きさ

        static public const VIEW_W:int = 465;

        static public const VIEW_H:int = 465;

        //UI

        static public const UI_H:int = 234;

        static public const UI_LW:int = 231;

        static public const UI_MINI_W:int = 78;

        //Game

        static public const SCORE_H:int = 33;

        static public const LINE_H:int = 66;



        //文字フォントの大きさ

        static public const STR_W:int = 64;

        //文字表示画像の大きさ

        static public const BMD_W:int = 78;//３の倍数にすることで、1/3を塗りつぶす処理に端数が出ないようにしておく



        //ラインの数

        static public const LINE_NUM:int = 3;



        //スクロール速度

        static public const SCROLL_VEL:Number = 80;//150;

        static public const HIGH_SCROLL_VEL_RATIO:Number = 4;

        static public const HIGH_SCROLL_LERP_RATIO:Number = 0.1;



        //ボムで消される半径

        static public const MINIBOMB_RAD:int= STR_W / 5;

        static public const BOMB_RAD:int    = STR_W / 2;



        //横線で消される高さ

        static public const ERASE_LINE_H:int = 6;



        //トラップの種類

        static public var s_TrapIter:int = 0;

        static public const TRAP_BOMB    :int = s_TrapIter++;

        static public const TRAP_LINE    :int = s_TrapIter++;

        static public const TRAP_FILL    :int = s_TrapIter++;

        static public const TRAP_NUM    :int = s_TrapIter;



        //モード

        static public var s_ModeIter:int = 0;

        static public const MODE_TITLE        :int = s_ModeIter++;

        static public const MODE_GAME        :int = s_ModeIter++;

        static public const MODE_GAMEOVER    :int = s_ModeIter++;

        static public const MODE_NUM        :int = s_ModeIter;



        //Util

        static public const POINT_ZERO:Point = new Point(0,0);







        //==Var==



        //Pseudo Singleton

        static public var Instance:TenChar;



        //モード

        public var m_Mode:int = MODE_TITLE;



        //レイヤー

        public var m_Layer_Root            :Sprite = new Sprite();

        public var  m_Layer_Title        :Sprite = new Sprite();

        public var  m_Layer_Game        :Sprite = new Sprite();

        public var   m_Layer_Game_Main    :Sprite = new Sprite();

        public var   m_Layer_Game_UI    :Sprite = new Sprite();

        public var  m_Layer_GameOver    :Sprite = new Sprite();



        //タイトルUI

        public var m_StartButton:Button;

        public var m_CharWindow:ChineseCharacterWindow;

        public var m_TextField_Input:TextField = new TextField();



        //GameOverUI

        public var m_TweetButton:Button;

        public var m_RetryButton:Button;

        public var m_TextField_CountResult:Vector.<Vector.<TextField> >;

        public var m_TextField_ScoreResult:TextField;



        //入力された文字とそのBitmapデータ

        public var m_InputString:String = "";

        public var m_BitmapData_String_Ori:Vector.<BitmapData> = new Vector.<BitmapData>(USE_CHAR_NUM);

        public var m_BitmapData_String:Vector.<BitmapData> = new Vector.<BitmapData>(USE_CHAR_NUM);



        //トラップの元画像

        public var m_BitmapData_Trap:Vector.<BitmapData> = new Vector.<BitmapData>(TRAP_NUM);



        //ゲームUI

        public var m_Bitmap_NowString:Bitmap = new Bitmap();

        public var m_Bitmap_Listed:Vector.<Bitmap> = new Vector.<Bitmap>(USE_CHAR_NUM);

        public var m_Bitmap_Trap:Vector.<Bitmap> = new Vector.<Bitmap>(LINE_NUM);

        public var m_Bitmap_SelectedLine:Bitmap = new Bitmap(new BitmapData(1,1,false,0xFFCC88));

        public var m_TextField_Count:Vector.<TextField> = new Vector.<TextField>(LINE_NUM);

        public var m_TextField_Score:TextField;



        //今居るライン

        public var m_SelectedLine:int = 0;



        //今表示してる文字のIter

        public var m_ViewStrIter:int = 0;



        //スクロールまわり

        public var m_RestOffset:Number = VIEW_W;

        public var m_HighSpeedFlag:Boolean = false;

        public var m_ScrollVelRatio:Number = 1;



        //破壊まわり

        public var m_IterX:int = 0;

        public var m_IterY:int = 0;

        public var m_Bitmap_Iter:Bitmap = new Bitmap(new BitmapData(BMD_W, BMD_W, true, 0x00000000));



        //スコア

        public var m_Score:int = 0;

        public var m_UseCount:Vector.<int> = new Vector.<int>(LINE_NUM);

        public var m_Count:Vector.<Vector.<int> >;







        //==Function==



        //Init

        public function TenChar():void {

            if(stage != null){

                Load(null);

            }else{

                addEventListener(

                    Event.ADDED_TO_STAGE,//ステージに追加されたら

                    Load

                );

            }

        }

        public function Load(e:Event):void{

//*

            //wonderfl用：Bitmapを外部からロードする場合



            //Load

            var loader:Loader = new Loader();

            loader.load(new URLRequest(BITMAP_URL), new LoaderContext(true));//画像のロードを開始して

            loader.contentLoaderInfo.addEventListener(

                Event.COMPLETE,//ロードが完了したら

                function(e:Event):void{

                    OnLoad(loader.content);//それを保持した後

                }

            );

/*/

            //ローカル用：Bitmapを事前ロードできる場合



            //ブロック画像のセット（＆その他初期化）

            OnLoad(new Bitmap_Graphic());

//*/

        }

        //OnLoad

        public function OnLoad(in_Graphic:DisplayObject):void{

            ImageManager.Init(in_Graphic);



//            //Static Init

//            ScoreWindowLoader.init(this, new WonderflAPI(loaderInfo.parameters));



            Init();

        }

        public function Init():void

        {

            var i:int;



            //Pseudo Singleton

            {

                Instance = this;

            }



            //Layer

            {

                addChild(m_Layer_Root);

                    m_Layer_Root.addChild(m_Layer_Title);

                    m_Layer_Root.addChild(m_Layer_Game);

                        m_Layer_Game.addChild(m_Layer_Game_Main);

                        m_Layer_Game.addChild(m_Layer_Game_UI);

                    m_Layer_Root.addChild(m_Layer_GameOver);

            }



            //Param

            {

                for(i = 0; i < m_UseCount.length; ++i){

                    m_UseCount[i] = 0;

                }

            }



            //Init Mode

            {

                Init_Title();

                Init_Game();

                Init_GameOver();



                m_Layer_Title.visible        = (m_Mode == MODE_TITLE);

                m_Layer_Game.visible        = (m_Mode == MODE_GAME);

                m_Layer_GameOver.visible    = (m_Mode == MODE_GAMEOVER);

            }



            //Touch

            {

                stage.addEventListener(KeyboardEvent.KEY_DOWN, OnKeyDown);

                stage.addEventListener(KeyboardEvent.KEY_UP, OnKeyUp);

                stage.addEventListener(MouseEvent.MOUSE_DOWN, OnMouseDown);

                stage.addEventListener(MouseEvent.MOUSE_UP,   OnMouseUp);

                stage.addEventListener(MouseEvent.MOUSE_MOVE, OnMouseMove);

            }



            //Update

            {

                addEventListener(Event.ENTER_FRAME, Update);

            }



            //OnEnd

            {

                addEventListener(Event.REMOVED_FROM_STAGE, Finish);

            }

        }



        public function Init_Title():void{

            //m_StartButton

            {

                m_StartButton = Util.CreateButton(128, 64, "Start", 32);

                m_Layer_Title.addChild(m_StartButton);



                m_StartButton.x = VIEW_W*3/4 - 128/2;

                m_StartButton.y = VIEW_H*1/4 - 64/2;

            }



            //ChineseCharacterWindow

            {

                m_CharWindow = new ChineseCharacterWindow(m_TextField_Input);

                m_Layer_Title.addChild(m_CharWindow);



                m_CharWindow.x = 0;

                m_CharWindow.y = VIEW_H - ChineseCharacterWindow.PANEL_H * ChineseCharacterWindow.NUM_Y;

            }



            //m_TextField_Input

            const InputW:int = 200;

            const InputH:int = 200;

            const InputStrW:int = 90;

            {//BG

                var input_bg:NinePatch = ImageManager.CreateNinePatch_Input(InputW, InputH);

                input_bg.x = VIEW_W*1/4 - InputW/2;

                input_bg.y = 8;



                m_Layer_Title.addChild(input_bg);

            }

            {//Input

                m_TextField_Input.x = ImageManager.BUTTON_NINEPATCH_RAD;

                m_TextField_Input.y = ImageManager.BUTTON_NINEPATCH_RAD;



                m_TextField_Input.scaleX = m_TextField_Input.scaleY = 2;

                m_TextField_Input.width  = (InputW - 2*ImageManager.BUTTON_NINEPATCH_RAD) / m_TextField_Input.scaleX;

                m_TextField_Input.height = (InputH - 2*ImageManager.BUTTON_NINEPATCH_RAD) / m_TextField_Input.scaleY;

                m_TextField_Input.maxChars = USE_CHAR_NUM;

                m_TextField_Input.multiline = false;

                //m_TextField_Input.restrict = "0-9\\-";

                m_TextField_Input.type = TextFieldType.INPUT;

//                m_TextField_Input.autoSize = TextFieldAutoSize.LEFT;

                m_TextField_Input.defaultTextFormat = new TextFormat("_明朝", InputStrW, 0x000000, true);

                m_TextField_Input.text = m_InputString;



//                m_TextField_Input.addEventListener(

//                    TextEvent.TEXT_INPUT,

//                    OnInput

//                );



//                m_TextField_Input.addEventListener(

//                    Event.CHANGE,

//                    OnTextChange

//                );



                input_bg.addChild(m_TextField_Input);

            }

        }

//        public function OnTextChange(e:Event):void{

//            while(m_TextField_Input.text.length < USE_CHAR_NUM){

//                m_TextField_Input.appendText("　");

//            }

//        }



        public function Init_Game():void{

            var i:int, j:int;

            var bmp:Bitmap;

            var bmd:BitmapData;

            var rect:Rectangle = new Rectangle();

            var tf:TextField;



            //BG

            {

                bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF);



                //横線

                rect.width = VIEW_W; rect.height = 1;

                rect.x = 0;    rect.y = 0;                        bmd.fillRect(rect, 0x000000);

                rect.x = 0;    rect.y = UI_H-1;                bmd.fillRect(rect, 0x000000);

                rect.x = 0;    rect.y = VIEW_W-1 - 0*LINE_H;    bmd.fillRect(rect, 0x000000);

                rect.x = 0;    rect.y = VIEW_W-1 - 1*LINE_H;    bmd.fillRect(rect, 0x000000);

                rect.x = 0;    rect.y = VIEW_W-1 - 2*LINE_H;    bmd.fillRect(rect, 0x000000);

                rect.x = 0;    rect.y = VIEW_W-1 - 3*LINE_H;    bmd.fillRect(rect, 0x000000);

/*

                //9:横線

                rect.width = UI_MINI_W*3; rect.height = 1;

                rect.x = UI_LW;    rect.y = 0*UI_MINI_W;        bmd.fillRect(rect, 0x000000);

                rect.x = UI_LW;    rect.y = 1*UI_MINI_W;        bmd.fillRect(rect, 0x000000);

                rect.x = UI_LW;    rect.y = 2*UI_MINI_W;        bmd.fillRect(rect, 0x000000);

                //9:縦線

                rect.width = 1; rect.height = UI_MINI_W*3;

                rect.x = UI_LW+0*UI_MINI_W;    rect.y = 0;        bmd.fillRect(rect, 0x000000);

                rect.x = UI_LW+1*UI_MINI_W;    rect.y = 0;        bmd.fillRect(rect, 0x000000);

                rect.x = UI_LW+2*UI_MINI_W;    rect.y = 0;        bmd.fillRect(rect, 0x000000);

//*/

                m_Layer_Game_Main.addChild(new Bitmap(bmd));

            }



            //m_Bitmap_SelectedLine

            {

                m_Layer_Game_Main.addChild(m_Bitmap_SelectedLine);

                m_Bitmap_SelectedLine.scaleX = VIEW_W;

                m_Bitmap_SelectedLine.scaleY = LINE_H-1;

            }



            //m_BitmapData_String

            {

                for(i = 0; i < USE_CHAR_NUM; ++i){

                    m_BitmapData_String_Ori[i] = new BitmapData(BMD_W, BMD_W, true, 0x00000000);

                    m_BitmapData_String[i] = m_BitmapData_String_Ori[i].clone();

                }

            }



            //m_Bitmap_Listed

            {

                for(i = 0; i < USE_CHAR_NUM; ++i){

                    bmp = new Bitmap();

                    bmp.bitmapData = m_BitmapData_String[i];

                    m_Layer_Game_UI.addChild(bmp);



/*

                    if(i == 0){

                        //大きく表示

                        bmp.x = 0;

                        bmp.y = 0;

                        bmp.scaleX = bmp.scaleY = 3;

                    }else{

                        //残りとして小さく並べて表示

                        var index:int = i - 1;

                        bmp.x = int(index % 3) * BMD_W + VIEW_W - 3*BMD_W;

                        bmp.y = int(index / 3) * BMD_W;

                    }

/*/

                    bmp.x = VIEW_W/2 - BMD_W*3/2;

                    bmp.y = 0;

                    bmp.scaleX = bmp.scaleY = 3;

//*/

                    m_Bitmap_Listed[i] = bmp;

                }

            }

            

            //m_Bitmap_Iter

            {

                m_Layer_Game_UI.addChild(m_Bitmap_Iter);

                m_Bitmap_Iter.x = m_Bitmap_Listed[0].x;

                m_Bitmap_Iter.y = m_Bitmap_Listed[0].y;

                m_Bitmap_Iter.scaleX = m_Bitmap_Iter.scaleY = 3;

            }





            //m_BitmapData_Trap

            {

                for(i = 0; i < TRAP_NUM; ++i){

                    m_BitmapData_Trap[i] = ImageManager.GetBitmapData_Trap(i);

                }

            }



            //m_Bitmap_Trap

            {

                for(i = 0; i < LINE_NUM; ++i){

                    m_Bitmap_Trap[i] = new Bitmap();

                    m_Layer_Game_Main.addChild(m_Bitmap_Trap[i]);

                    m_Bitmap_Trap[i].y = VIEW_H + (i - 2.5) * LINE_H - 32/2;

                }

                m_Bitmap_Trap[0].bitmapData = m_BitmapData_Trap[TRAP_BOMB];

                m_Bitmap_Trap[1].bitmapData = m_BitmapData_Trap[TRAP_LINE];

                m_Bitmap_Trap[2].bitmapData = m_BitmapData_Trap[TRAP_FILL];

            }



            //m_Bitmap_NowString

            {

                m_Layer_Game_Main.addChild(m_Bitmap_NowString);

                m_Bitmap_NowString.bitmapData = m_BitmapData_String[0];

                m_Bitmap_NowString.x = PLAYER_X;

                m_Bitmap_NowString.y = VIEW_H + (m_SelectedLine - (LINE_NUM-1) - 0.5)*LINE_H - BMD_W/2;

            }



            //Score

            {

                var ScoreOffset:int = VIEW_W * 22/100;

                var ScoreIconOffset:int = -8;

                var ScoreY:int = VIEW_H - LINE_NUM * LINE_H - SCORE_H;



                for(i = 0; i < LINE_NUM; ++i){

                    //Icon

                    bmp = new Bitmap(m_Bitmap_Trap[i].bitmapData);

                    bmp.x = i * ScoreOffset;

                    bmp.y = ScoreY;

                    m_Layer_Game_UI.addChild(bmp);



                    //Num

                    tf = new TextField();

                    tf.selectable = false;

                    tf.autoSize = TextFieldAutoSize.RIGHT;

                    tf.defaultTextFormat = new TextFormat("_明朝", SCORE_H * 0.9, 0x000000, true);

                    tf.x = (i+1) * ScoreOffset + ScoreIconOffset;

                    tf.y = bmp.y;

                    tf.text = "";

                    m_Layer_Game_UI.addChild(tf);

                    m_TextField_Count[i] = tf;

                }

                {

                    tf = new TextField();

                    tf.selectable = false;

                    tf.autoSize = TextFieldAutoSize.LEFT;

                    tf.defaultTextFormat = new TextFormat("_明朝", SCORE_H * 0.9, 0x000000, true);

                    tf.x = LINE_NUM * ScoreOffset;

                    tf.y = ScoreY;//bmp.y;

                    tf.text = "＝0";

                    m_Layer_Game_UI.addChild(tf);

                    m_TextField_Score = tf;

                }

            }



            //m_Count

            {

                m_Count = new Vector.<Vector.<int> >(USE_CHAR_NUM);

                for(i = 0; i < USE_CHAR_NUM; ++i){

                    m_Count[i] = new Vector.<int>(TRAP_NUM);

                    for(j = 0; j < TRAP_NUM; ++j){

                        m_Count[i][j] = 0;

                    }

                }

            }

        }



        //

        public function Init_GameOver():void{

            var i:int, j:int;

            var bmd:BitmapData;

            var bmp:Bitmap;

            var rect:Rectangle = new Rectangle();

            var tf:TextField;



            var LineH:int = VIEW_H / 6;

            var LineW:int = VIEW_W / 6;



            //BG

            {

                bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFFFFFF);



                //横線

                rect.x = 0; rect.width = VIEW_W; rect.height = 1;

                for(i = 0; i < 3; ++i){

                    rect.y = i*LineH;    bmd.fillRect(rect, 0x000000);

                }

                //縦線

                rect.y = 0; rect.width = 1; rect.height = 2*LineH;

                for(i = 0; i < 5; ++i){

                    rect.x = i*LineW;    bmd.fillRect(rect, 0x000000);

                }

                m_Layer_GameOver.addChild(new Bitmap(bmd));

            }



            //Icon

            {

                for(i = 0; i < TRAP_NUM; ++i){

                    bmd = m_BitmapData_Trap[i];



                    bmp = new Bitmap(bmd);

                    bmp.x = (i + 1.5) * LineW - bmd.width/2;

                    bmp.y = LineH/2 - bmd.height/2;



                    m_Layer_GameOver.addChild(bmp);

                }

            }



            //String

            //- m_BitmapData_Stringを流用して表示

            {

                for(i = 0; i < USE_CHAR_NUM; ++i){

                    bmd = m_BitmapData_String_Ori[i];



                    bmp = new Bitmap(bmd);

                    bmp.y = (i + 1) * LineH;

                    bmp.scaleX = bmp.scaleY = Math.min(1.0 * LineW / BMD_W, 1.0 * LineH / BMD_W);



                    m_Layer_GameOver.addChild(bmp);

                }

            }



            //Count

            m_TextField_CountResult = new Vector.<Vector.<TextField> >(USE_CHAR_NUM);

            for(i = 0; i < USE_CHAR_NUM; ++i){

                m_TextField_CountResult[i] = new Vector.<TextField>(TRAP_NUM);

                for(j = 0; j < TRAP_NUM; ++j){

                    tf = new TextField();

                    tf.selectable = false;

                    tf.autoSize = TextFieldAutoSize.CENTER;

                    tf.defaultTextFormat = new TextFormat("_明朝", LineW / 3, 0x000000, true);

                    tf.x = (j + 1.5) * LineW;

                    tf.y = (i + 1.3) * LineH;

                    tf.text = "";

                    m_Layer_GameOver.addChild(tf);



                    m_TextField_CountResult[i][j] = tf;

                }

            }



            //m_TextField_ScoreResult

            {

                tf = new TextField();

                tf.selectable = false;

                tf.autoSize = TextFieldAutoSize.CENTER;

                tf.defaultTextFormat = new TextFormat("_明朝", LineH * 0.9, 0x000000, true);

                tf.x = 5 * LineW;

                tf.y = LineH;

                tf.text = "";

                m_Layer_GameOver.addChild(tf);



                m_TextField_ScoreResult = tf;

            }



            //m_TweetButton

            {

                m_TweetButton = Util.CreateButton(128, 64, "Tweet", 32);

                m_Layer_GameOver.addChild(m_TweetButton);



                m_TweetButton.x = VIEW_W/2 - 128/2;

                m_TweetButton.y = VIEW_H*2/4;

            }



            //m_RetryButton

            {

                m_RetryButton = Util.CreateButton(128, 64, "Retry", 32);

                m_Layer_GameOver.addChild(m_RetryButton);



                m_RetryButton.x = VIEW_W/2 - 128/2;

                m_RetryButton.y = VIEW_H*3/4;

            }

        }



        //Reset

        //- TitleからGameに遷移する際に呼ぶこと

        public function Reset_Game():void

        {

            var i:int, j:int;

            var bmd:BitmapData;



            //m_TextField_Input => m_InputString

            {

                m_InputString = m_TextField_Input.text;

            }



            //m_InputString => m_BitmapData_String

            {

                var text_sprite:Sprite = new Sprite();

                var tf:TextField = new TextField();

                //var mtx:Matrix = new Matrix();

                {

                    tf.selectable = false;

                    tf.autoSize = TextFieldAutoSize.CENTER;

                    tf.defaultTextFormat = new TextFormat("_明朝", STR_W, 0x000000, true);

                    tf.text = "";

                    tf.x = BMD_W/2;

                    tf.y = BMD_W/2 - STR_W/2;

                    text_sprite.addChild(tf);

//                    mtx.tx = BMD_W/2;

//                    mtx.ty = BMD_W/2 - STR_W/2;

                }



                for(i = 0; i < USE_CHAR_NUM; ++i){

                    bmd = m_BitmapData_String[i];

                    bmd.fillRect(bmd.rect, 0x00000000);



                    if(i < m_InputString.length){

                        //Draw Char

                        tf.text = m_InputString.charAt(i);

//                        bmd.draw(tf, mtx);

                        bmd.draw(text_sprite);

                        bmd.threshold(bmd, bmd.rect, POINT_ZERO, "!=", 0xFF000000, 0x00000000);

                    }



                    m_BitmapData_String_Ori[i].copyPixels(bmd, bmd.rect, POINT_ZERO);

                }



                m_ViewStrIter = 0;

                m_Bitmap_NowString.bitmapData = m_BitmapData_String[m_ViewStrIter];

                for(i = 0; i < USE_CHAR_NUM; ++i){

                    if(i + m_ViewStrIter < USE_CHAR_NUM){

                        m_Bitmap_Listed[i].bitmapData = m_BitmapData_String[i + m_ViewStrIter];

                    }else{

                        m_Bitmap_Listed[i].bitmapData = null;

                    }

                }

            }



            //m_SelectedLineまわり

            {

                m_SelectedLine = 0;

                m_Bitmap_NowString.y = VIEW_H + (m_SelectedLine - (LINE_NUM-1) - 0.5)*LINE_H - BMD_W/2;

                m_Bitmap_SelectedLine.y = VIEW_H - (LINE_NUM - m_SelectedLine) * LINE_H;

            }



            //Iter

            {

                m_IterX = m_IterY = 0;

                SearchIter();

            }



            //m_Count

            {

                m_Score = 0;

                m_TextField_Score.text = m_Score.toString();

                for(j = 0; j < TRAP_NUM; ++j){

                    m_UseCount[j] = 0;

                    m_TextField_Count[j].text = m_UseCount[j].toString() + ((j < TRAP_NUM-1)? "×": "＝");

                    for(i = 0; i < USE_CHAR_NUM; ++i){

                        m_Count[i][j] = 0;

                    }

                }

            }

        }



        //

        public function Reset_GameOver():void{

            var i:int, j:int;

            for(i = 0; i < USE_CHAR_NUM; ++i){

                for(j = 0; j < TRAP_NUM; ++j){

                    //Count

//                    m_TextField_CountResult[i][j].text = m_Count[i][j].toString();

                    m_TextField_CountResult[i][j].text = m_Count[i][j].toString() + ((j < TRAP_NUM-1)? "×": "＝");

                }

            }

            m_TextField_ScoreResult.text = m_Score.toString();

        }





        //Finish

        public function Finish(e:Event):void{

            removeEventListener(Event.ADDED_TO_STAGE, Init);

            removeEventListener(Event.ENTER_FRAME, Update);

            removeEventListener(Event.REMOVED_FROM_STAGE, Finish);

        }



        //Touch

        private function OnMouseDown(e:MouseEvent):void{

            m_HighSpeedFlag = true;

            switch(m_Mode){

            case MODE_TITLE:

                if(m_CharWindow.OnMouseDown()){

                    return;

                }

                if(m_StartButton.Contains()){

                    Reset_Game();

                    m_Mode = MODE_GAME;

                    m_Layer_Title.visible = false;

                    m_Layer_Game.visible = true;

                }

                break;

            case MODE_GAME:

                OnTouch_Game();

                break;

            case MODE_GAMEOVER:

                if(m_TweetButton.Contains()){

                    var tweet_str:String = "「" + m_InputString + "」で" + m_Score + "点をゲット！ #一文字削り";



                    var api:WonderflAPI = new WonderflAPI(loaderInfo.parameters);

                    navigateToURL(new URLRequest(

                        "http://twitter.com/share?" +

                        "text=" + escapeMultiByte(tweet_str + " #wonderfl") +

                        "&url=" + escapeMultiByte("http://wonderfl.net/c/" + api.appID)

                        //"&url=" + escapeMultiByte("https://play.google.com/store/apps/details?id=air.showohealer.game.airprototype")

                    ));

                }

                if(m_RetryButton.Contains()){

                    m_Mode = MODE_TITLE;

                    m_Layer_Title.visible = true;

                    m_Layer_GameOver.visible = false;

                }

                break;

            }

        }

        private function OnMouseMove(e:MouseEvent):void{

            if(e.buttonDown){

                switch(m_Mode){

                case MODE_TITLE:

                    break;

                case MODE_GAME:

                    OnTouch_Game();

                    break;

                case MODE_GAMEOVER:

                    break;

                }

            }

        }

        private function OnMouseUp(e:MouseEvent):void{

            m_HighSpeedFlag = false;

        }

        private function OnTouch_Game():void{

            for(var i:int = 0; i < LINE_NUM; ++i){

                if(VIEW_H - (1+i)*LINE_H <= mouseY){

                    m_SelectedLine = LINE_NUM-1 - i;

                    m_Bitmap_NowString.y = VIEW_H + (m_SelectedLine - (LINE_NUM-1) - 0.5)*LINE_H - BMD_W/2;

                    m_Bitmap_SelectedLine.y = VIEW_H - (LINE_NUM - m_SelectedLine) * LINE_H;

                    RefreshPreview();

                    return;

                }

            }

        }

        private function OnKeyDown(event:KeyboardEvent):void{

        }

        private function OnKeyUp(e:KeyboardEvent):void{

        }



        //ドットがあるところまでIterを進める

        //- 現在のBitmapDataが全て空白になったらTrueを返す

        public function SearchIter():Boolean

        {

            var result:Boolean = SearchIter_Innner();



//            m_Bitmap_Iter.x = (m_IterX - 1) * 3;

//            m_Bitmap_Iter.y = (m_IterY - 1) * 3;



            //Preview

            RefreshPreview();



            return result;

        }

        public function SearchIter_Innner():Boolean

        {

            var bmd:BitmapData = m_BitmapData_String[m_ViewStrIter];



            for(; m_IterX < BMD_W; ++m_IterX){

                for(; m_IterY < BMD_W; ++m_IterY){

                    var color:uint = bmd.getPixel32(m_IterX, m_IterY);



                    //ドットがなければスキップ

                    if((color & 0xFF000000) == 0x00000000){

                        continue;

                    }



                    //ドットがあればここで終了

                    return false;//文字があるのでfalseを返す

                }



                m_IterY = 0;

            }



            //ドットが見当たらなかったのでこの画像はもう終了

            return true;

        }



        public function RefreshPreview():void{

            var bmd:BitmapData = m_Bitmap_Iter.bitmapData;

            bmd.copyPixels(m_BitmapData_String[m_ViewStrIter], bmd.rect, POINT_ZERO);



            var color_fill:uint = 0xFFFF8800;

            switch(m_SelectedLine){

            case 0:

                Trap_Bomb(bmd, color_fill, MINIBOMB_RAD);

                break;

            case 1:

                Trap_Line(bmd, color_fill);

                break;

            case 2:

                Trap_Fill(bmd, color_fill);

                break;

            }



            var color_cursor:uint = 0xFFFF0000;

            bmd.setPixel32(m_IterX+0, m_IterY+0, color_cursor);

            bmd.setPixel32(m_IterX+1, m_IterY+0, color_cursor);

            bmd.setPixel32(m_IterX-1, m_IterY+0, color_cursor);

            bmd.setPixel32(m_IterX+0, m_IterY+1, color_cursor);

            bmd.setPixel32(m_IterX+0, m_IterY-1, color_cursor);

        }





        //Update

        public function Update(e:Event=null):void{

            var DeltaTime:Number = 1.0 / 30.0;



            switch(m_Mode){

            case MODE_TITLE:

//                Update_Title();

                break;

            case MODE_GAME:

                Update_Game(DeltaTime);

                break;

            case MODE_GAMEOVER:

//                Update_GameOver();

                break;

            }

        }



        //Update : Game

        public function Update_Game(in_DeltaTime:Number):void

        {

            var i:int;



            if(m_HighSpeedFlag){

                m_ScrollVelRatio = Lerp(m_ScrollVelRatio, HIGH_SCROLL_VEL_RATIO, HIGH_SCROLL_LERP_RATIO);

            }else{

                m_ScrollVelRatio = 1;

            }

            m_RestOffset -= m_ScrollVelRatio * SCROLL_VEL * in_DeltaTime;

            if(0 < m_RestOffset){

                //まだ触れてないので位置の設定だけして終了

                for(i = 0; i < LINE_NUM; ++i){

                    m_Bitmap_Trap[i].x = HIT_X + m_RestOffset;

                }

            }else{

                //触れたので色々と処理する



                //まずは触れたやつの処理を発動

                switch(m_SelectedLine){

                case 0:

                    Trap_Bomb(m_BitmapData_String[m_ViewStrIter], 0x00000000, MINIBOMB_RAD);

                    break;

                case 1:

                    Trap_Line(m_BitmapData_String[m_ViewStrIter], 0x00000000);

                    break;

                case 2:

                    Trap_Fill(m_BitmapData_String[m_ViewStrIter], 0x00000000);

                    break;

                }

                m_RestOffset = VIEW_W;



                //スコアの再計算

                ++m_UseCount[m_SelectedLine];

                ++m_Count[m_ViewStrIter][m_SelectedLine];

                for(i = 0 ; i < m_UseCount.length; ++i){

                    if(i == 0){

                        m_Score = m_UseCount[i];

                    }else{

                        m_Score *= m_UseCount[i];

                    }

                }

                m_TextField_Count[m_SelectedLine].text = m_UseCount[m_SelectedLine].toString() + ((m_SelectedLine < TRAP_NUM-1)? "×": "＝");

                m_TextField_Score.text = m_Score.toString();



                //ドットが全てなくなったら次のやつを呼ぶ（空白はスキップし、最後まで終わったらここでゲームオーバー）

                while(SearchIter()){

                    m_IterX = m_IterY = 0;

                    ++m_ViewStrIter;



                    //全部終わったらゲームオーバーへ

                    if(USE_CHAR_NUM <= m_ViewStrIter){

                        m_Mode = MODE_GAMEOVER;

                        m_Layer_Game.visible = false;

                        m_Layer_GameOver.visible = true;

                        Reset_GameOver();

                        return;

                    }



                    //そうでなければ次の文字に移る

                    for(i = 0; i < USE_CHAR_NUM; ++i){

                        if(i + m_ViewStrIter < USE_CHAR_NUM){

                            m_Bitmap_Listed[i].bitmapData = m_BitmapData_String[i + m_ViewStrIter];

                        }else{

                            m_Bitmap_Listed[i].bitmapData = null;

                        }

                    }

                    m_Bitmap_NowString.bitmapData = m_BitmapData_String[m_ViewStrIter];

                }



                //触れた種類や消えたドット数に応じて、次のやつまでの距離を設定

                for(i = 0; i < LINE_NUM; ++i){

                    m_Bitmap_Trap[i].x = HIT_X + m_RestOffset;

                }

            }

        }







        //Trap : Bomb

        public function Trap_Bomb(io_BMD:BitmapData, in_Color:uint, in_Rad:int):void

        {

            var bmd:BitmapData = io_BMD;



            //消去

            var erase_count:int = 0;

            for(var GapY:int = -in_Rad; GapY < in_Rad; ++GapY){

                for(var GapX:int = -in_Rad; GapX < in_Rad; ++GapX){

                    var distance:Number = Math.sqrt(GapX*GapX + GapY*GapY);

                    if(distance < in_Rad - 0.5){

                        var xx:int = m_IterX + GapX;

                        var yy:int = m_IterY + GapY;



                        //範囲チェック

                        if(xx < 0){continue;}

                        if(BMD_W <= xx){continue;}

                        if(yy < 0){continue;}

                        if(BMD_W <= yy){continue;}



                        //ドットチェック

                        var color:uint = bmd.getPixel32(xx, yy);

                        if((color & 0xFF000000) == 0x00000000){continue;}



                        //消去

                        bmd.setPixel32(xx, yy, in_Color);

                        ++erase_count;

                    }

                }

            }



            //消した数に応じたオフセットを返す

//            return OFFSET_INIT_BOMB + OFFSET_RATIO_BOMB * erase_count;

        }



        //Trap : Line

        public function Trap_Line(io_BMD:BitmapData, in_Color:uint):void

        {

            var bmd:BitmapData = io_BMD;



            //消去

            for(var xx:int = 0; xx < BMD_W; ++xx){

                for(var yy:int = m_IterY - 1; yy < m_IterY + ERASE_LINE_H - 1; ++yy){

                    //範囲チェック

                    if(yy < 0){continue;}

                    if(BMD_W <= yy){continue;}



                    //ドットチェック

                    var color:uint = bmd.getPixel32(xx, yy);

                    if((color & 0xFF000000) == 0x00000000){continue;}



                    //消去

                    bmd.setPixel32(xx, yy, in_Color);

                }

            }

        }



        //Trap : Fill

        public function Trap_Fill(io_BMD:BitmapData, in_Color:uint):void

        {

/*

            //消去

            var erase_count:int = Trap_Fill_Recursive(m_IterX, m_IterY);



            //消した数に応じたオフセットを返す

            return OFFSET_INIT_FILL + OFFSET_RATIO_FILL * erase_count;

//*/

//*

            //スキャンライン・シードフィル法

            //参考：http://www40.atwiki.jp/spellbound/pages/315.html

            var erase_count:int = 0;



            var bmd:BitmapData = io_BMD;

            var rect:Rectangle = new Rectangle(0,0,1,1);



            var point_arr:Vector.<Point> = new Vector.<Point>();

            point_arr.push(new Point(m_IterX, m_IterY));



            while(0 < point_arr.length){

                var point:Point = point_arr.shift();



                //色チェック

                var color:uint = bmd.getPixel32(point.x, point.y);

                if((color & 0xFF000000) == 0x00000000 || color == in_Color){

                    continue;

                }



                //端の位置のチェック

                var lx:int, rx:int;

                for(lx = point.x; 0 < lx; --lx){

                    color = bmd.getPixel32(lx-1, point.y);

                    if((color & 0xFF000000) == 0x00000000 || color == in_Color){

                        break;

                    }

                }

                for(rx = point.x; lx < BMD_W-1; ++rx){

                    color = bmd.getPixel32(rx+1, point.y);

                    if((color & 0xFF000000) == 0x00000000 || color == in_Color){

                        break;

                    }

                }



                //左端から右端までを塗りつぶし

                rect.x = lx;

                rect.width = rx - lx + 1;

                rect.y = point.y;

                bmd.fillRect(rect, in_Color);



                //

                erase_count += rect.width;



                //上下のラインの塗りつぶし開始位置を検索＆格納

                if(0 < point.y){

                    scanLine(lx, rx, point.y-1, bmd, point_arr);

                }

                if(point.y < BMD_W-1){

                    scanLine(lx, rx, point.y+1, bmd, point_arr);

                }

            }



            //消した数に応じたオフセットを返す

//            return OFFSET_INIT_FILL + OFFSET_RATIO_FILL * erase_count;

//*/

        }

/*

        public function Trap_Fill_Recursive(in_X:int, in_Y:int, in_Count:int = 0):int

        {

            //ちょっと呼び出しにムダが多いので、連結の多い漢字で処理が重くなるようなら高速化すること

            //→速度以前に再帰呼び出しがオーバフローしてしまったので却下



            var bmd:BitmapData = m_BitmapData_String[m_ViewStrIter];



            //空白なら何も加算せずに返す

            var color:uint = bmd.getPixel32(in_X, in_Y);

            if((color & 0xFF000000) == 0x00000000){

                return in_Count;

            }



            //そうでなければ＋＋しつつ上下左右に拡散

            bmd.setPixel32(in_X, in_Y, 0x00000000);

            var Count:int = in_Count + 1;



            if(0 < in_X){

                Count = Trap_Fill_Recursive(in_X-1, in_Y, Count);

            }

            if(in_X < BMD_W-1){

                Count = Trap_Fill_Recursive(in_X+1, in_Y, Count);

            }

            if(0 < in_Y){

                Count = Trap_Fill_Recursive(in_X, in_Y-1, Count);

            }

            if(in_Y < BMD_W-1){

                Count = Trap_Fill_Recursive(in_X, in_Y+1, Count);

            }



            return Count;

        }

//*/

//*

        public function scanLine(in_LX:int, in_RX:int, in_Y:int, in_BMD:BitmapData, out_PointArr:Vector.<Point>):void{

            var connect_flag:Boolean = false;



            for(var iter_x:int = in_RX; in_LX <= iter_x; --iter_x){

                //空白はスキップ

                var color:uint = in_BMD.getPixel32(iter_x, in_Y);

                if((color & 0xFF000000) == 0x00000000){

                    connect_flag = false;

                    continue;

                }



                //前回登録したものとつながっているならスキップ

                if(connect_flag){

                    continue;

                }



                //右端のようなので登録

                out_PointArr.push(new Point(iter_x, in_Y));

            }

        }



//*/

        public function Lerp(in_Src:Number, in_Dst:Number, in_Ratio:Number):Number{

            return (in_Src * (1 - in_Ratio)) + (in_Dst * in_Ratio);

        }

    }

}





import flash.display.*;

import flash.events.*;

import flash.filters.*;

import flash.geom.*;

import flash.net.*;

import flash.system.*;

import flash.text.*;

import flash.ui.*;

//import net.wonderfl.utils.WonderflAPI;





class NinePatch extends Sprite

{

    //==Function==



    //Init

    public function NinePatch(in_BMD:BitmapData, in_Rad:int, in_W:int, in_H:int){

        var OriW:int = in_BMD.width;

        var OriH:int = in_BMD.height;



        var edge_w:int = OriW - in_Rad*2;

        var edge_h:int = OriH - in_Rad*2;



        var bmd:BitmapData = new BitmapData(in_W, in_H, true, 0x00000000);



        var src_rect:Rectangle = new Rectangle(0,0,1,1);

        var dst_pos:Point = new Point(0,0);

        var offset_x:int;

        var offset_y:int;



        //Corner

        {

            src_rect.width  = in_Rad;

            src_rect.height = in_Rad;

            //- LU

            src_rect.x = 0;

            src_rect.y = 0;

            dst_pos.x = 0;

            dst_pos.y = 0;

            bmd.copyPixels(in_BMD, src_rect, dst_pos);

            //- RU

            src_rect.x = OriW-in_Rad;

            src_rect.y = 0;

            dst_pos.x = in_W-in_Rad;

            dst_pos.y = 0;

            bmd.copyPixels(in_BMD, src_rect, dst_pos);

            //- LD

            src_rect.x = 0;

            src_rect.y = OriH-in_Rad;

            dst_pos.x = 0;

            dst_pos.y = in_H-in_Rad;

            bmd.copyPixels(in_BMD, src_rect, dst_pos);

            //- RD

            src_rect.x = OriW-in_Rad;

            src_rect.y = OriH-in_Rad;

            dst_pos.x = in_W-in_Rad;

            dst_pos.y = in_H-in_Rad;

            bmd.copyPixels(in_BMD, src_rect, dst_pos);

        }



        //Edge

        {

            //UD

            src_rect.x = in_Rad;

            src_rect.width = edge_w;

            src_rect.height = in_Rad;

            for(offset_x = in_Rad; offset_x < in_W - in_Rad; offset_x += edge_w){

                dst_pos.x = offset_x;

                if(in_W - in_Rad < offset_x + edge_w){

                    src_rect.width = (in_W - in_Rad) - offset_x;

                }

                //U

                src_rect.y = 0;

                dst_pos.y = 0;

                bmd.copyPixels(in_BMD, src_rect, dst_pos);

                //D

                src_rect.y = OriH-in_Rad;

                dst_pos.y = in_H-in_Rad;

                bmd.copyPixels(in_BMD, src_rect, dst_pos);

            }



            //LR

            src_rect.y = in_Rad;

            src_rect.width = in_Rad;

            src_rect.height = edge_h;

            for(offset_y = in_Rad; offset_y < in_H - in_Rad; offset_y += edge_h){

                dst_pos.y = offset_y;

                if(in_H - in_Rad < offset_y + edge_h){

                    src_rect.height = (in_H - in_Rad) - offset_y;

                }

                //L

                src_rect.x = 0;

                dst_pos.x = 0;

                bmd.copyPixels(in_BMD, src_rect, dst_pos);

                //R

                src_rect.x = OriW-in_Rad;

                dst_pos.x = in_W-in_Rad;

                bmd.copyPixels(in_BMD, src_rect, dst_pos);

            }

        }



        //Center

        {

            src_rect.x = in_Rad;

            src_rect.y = in_Rad;

            for(offset_x = in_Rad; offset_x < in_W - in_Rad; offset_x += edge_w){

                dst_pos.x = offset_x;

                if(in_W - in_Rad < offset_x + edge_w){

                    src_rect.width = (in_W - in_Rad) - offset_x;

                }else{

                    src_rect.width = edge_w;

                }



                for(offset_y = in_Rad; offset_y < in_H - in_Rad; offset_y += edge_h){

                    dst_pos.y = offset_y;

                    if(in_H - in_Rad < offset_y + edge_h){

                        src_rect.height = (in_H - in_Rad) - offset_y;

                    }else{

                        src_rect.height = edge_h;

                    }



                    bmd.copyPixels(in_BMD, src_rect, dst_pos);

                }

            }

        }



        addChild(new Bitmap(bmd));

    }

}





class Button extends Sprite

{

    //==Var==



    //BMD

    public var m_BitmapData:BitmapData;





    //==Function==



    //Init

    public function Button(in_W:int, in_H:int){

        addChild(ImageManager.CreateNinePatch_Button(in_W, in_H));



        m_BitmapData = new BitmapData(in_W, in_H, true, 0x00000000);

        addChild(new Bitmap(m_BitmapData));

    }



    //Check

    public function Contains():Boolean{

        return m_BitmapData.rect.contains(mouseX, mouseY);

    }

}





class ChineseCharacterWindow extends Sprite

{

    //==Const==



    //表示するUNICODE

    static public const UNICODE_CHAR_MIN:int = 0x4E00;

    static public const UNICODE_CHAR_MAX:int = 0x9FA5;



    //

    static public const PANEL_W    :int = 64;

    static public const PANEL_H    :int = 48;

    static public const STR_W    :int = 44;



    //

    static public const NUM_X:int = 5;

    static public const NUM_Y:int = 5;

    //

    static public const PAGE_NUM:int = (UNICODE_CHAR_MAX-UNICODE_CHAR_MIN+1 + NUM_X*NUM_Y-1) / (NUM_X*NUM_Y);





    //==Var==



    public var m_Iter:int = 0;



    public var m_Button:Vector.<Vector.<Button> >;//ボタンのベース画像

    public var m_BitmapData:Vector.<Vector.<BitmapData> >;//文字画像

    public var m_ButtonL:Button;

    public var m_ButtonR:Button;



    public var m_TextField_Page:TextField = new TextField();



    public var m_TextField_Input:TextField;





    //==Function==



    //Init

    public function ChineseCharacterWindow(out_TextField_Input:TextField){

        var btn:Button;

        var bmd:BitmapData;



        var lw:int = TenChar.VIEW_W/2 - (PANEL_W * NUM_X)/2;

        var rw:int = TenChar.VIEW_W - lw - (PANEL_W * NUM_X);



        //Param

        {

            m_TextField_Input = out_TextField_Input;

        }



        //m_Button

        {

            m_Button = new Vector.<Vector.<Button> >(NUM_Y);

            m_BitmapData = new Vector.<Vector.<BitmapData> >(NUM_Y);

            for(var yy:int = 0; yy < NUM_Y; ++yy){

                m_Button[yy] = new Vector.<Button>(NUM_X);

                m_BitmapData[yy] = new Vector.<BitmapData>(NUM_X);

                for(var xx:int = 0; xx < NUM_X; ++xx){

                    btn = new Button(PANEL_W, PANEL_H);



                    btn.x = xx * PANEL_W + lw;

                    btn.y = yy * PANEL_H;

                    addChild(btn);



                    bmd = new BitmapData(PANEL_W, PANEL_H, true, 0x00000000);

                    btn.addChild(new Bitmap(bmd));



                    m_Button[yy][xx] = btn;

                    m_BitmapData[yy][xx] = bmd;

                }

            }

        }



        //m_ButtonL & R

        {

            m_ButtonL = Util.CreateButton(lw, PANEL_H * NUM_Y, "←", lw * 0.8);

            m_ButtonL.x = 0;

            addChild(m_ButtonL);



            m_ButtonR = Util.CreateButton(rw, PANEL_H * NUM_Y, "→", lw * 0.8);

            m_ButtonR.x = lw + NUM_X * PANEL_W;

            addChild(m_ButtonR);

        }



        //

        {

            m_TextField_Page.selectable = false;

            m_TextField_Page.autoSize = TextFieldAutoSize.RIGHT;

            m_TextField_Page.defaultTextFormat = new TextFormat("_明朝", 16, 0xFFFFFF, true);

            m_TextField_Page.x = TenChar.VIEW_W;

            m_TextField_Page.y = -16;

            addChild(m_TextField_Page);

        }



        Refresh();

    }



    //Refresh

    public function Refresh():void{

        var tf:TextField = new TextField();

        //var mtx:Matrix = new Matrix();

        {

            tf.selectable = false;

            tf.autoSize = TextFieldAutoSize.CENTER;

            tf.defaultTextFormat = new TextFormat("_明朝", STR_W, 0x000000, true);

            tf.text = "";

            tf.x = PANEL_W/2;

            tf.y = PANEL_H/2 - STR_W/2;

        }



        var text_sprite:Sprite = new Sprite();

        text_sprite.addChild(tf);



        for(var yy:int = 0; yy < NUM_Y; ++yy){

            for(var xx:int = 0; xx < NUM_X; ++xx){

                var bmd:BitmapData = m_BitmapData[yy][xx];

                bmd.fillRect(bmd.rect, 0x00000000);



                var unicode_index:int = UNICODE_CHAR_MIN + m_Iter + xx + yy*NUM_X;

                if(unicode_index <= UNICODE_CHAR_MAX){

                    tf.text = String.fromCharCode(unicode_index);

                    bmd.draw(text_sprite);

                }

            }

        }



        //

        {

            m_TextField_Page.text = (m_Iter/(NUM_X*NUM_Y) + 1).toString() + "/" + PAGE_NUM;

        }

    }



    //OnMouseDown

    public function OnMouseDown():Boolean{

        for(var yy:int = 0; yy < NUM_Y; ++yy){

            for(var xx:int = 0; xx < NUM_X; ++xx){

                var btn:Button = m_Button[yy][xx];

                if(! btn.Contains()){

                    continue;

                }



/*

                if(m_TextField_Input.text.length < m_TextField_Input.maxChars){

                    var unicode_index:int = UNICODE_CHAR_MIN + m_Iter + xx + yy*NUM_X;

                    m_TextField_Input.appendText(String.fromCharCode(unicode_index));

                }

/*/

                var unicode_index:int = UNICODE_CHAR_MIN + m_Iter + xx + yy*NUM_X;

                m_TextField_Input.text = String.fromCharCode(unicode_index);

//*/



                return true;

            }

        }



        if(m_ButtonL.Contains()){

            m_Iter -= NUM_X * NUM_Y;

            if(m_Iter < 0){

                m_Iter += PAGE_NUM * NUM_X * NUM_Y;

            }

            Refresh();

            return true;

        }

        if(m_ButtonR.Contains()){

            m_Iter += NUM_X * NUM_Y;

            if(PAGE_NUM * NUM_X * NUM_Y <= m_Iter){

                m_Iter -= PAGE_NUM * NUM_X * NUM_Y;

            }

            Refresh();

            return true;

        }



        return false;

    }

}





class ImageManager

{

    //==Const==



    static public const BUTTON_NINEPATCH_RAD:int = 8;





    //==Var==



    static public var m_BitmapData_Trap:Vector.<BitmapData> = new Vector.<BitmapData>(TenChar.TRAP_NUM);

    static public var m_BitmapData_Button:BitmapData = new BitmapData(32, 32, true, 0x00000000);

    static public var m_BitmapData_Input:BitmapData = new BitmapData(32, 32, true, 0x00000000);



    //==Function==

    static public function Init(in_Graphic:DisplayObject):void{

        var i:int;

        var bmd:BitmapData;

        var mtx:Matrix = new Matrix();



        //m_BitmapData_Trap

        {

            for(i = 0; i < TenChar.TRAP_NUM; ++i){

                bmd = new BitmapData(32, 32, true, 0x00000000);



                //Draw

                switch(i){

                case TenChar.TRAP_BOMB:    mtx.tx = -3*32;    mtx.ty =   0;    break;

                case TenChar.TRAP_LINE:    mtx.tx = -2*32;    mtx.ty =   0;    break;

                case TenChar.TRAP_FILL:    mtx.tx = -1*32;    mtx.ty =   0;    break;

                }

                bmd.draw(in_Graphic, mtx);



                m_BitmapData_Trap[i] = bmd;

            }

        }



        //m_BitmapData_Button

        {

            mtx.tx = -0 * 32;

            mtx.ty = -2 * 32;

            m_BitmapData_Button.draw(in_Graphic, mtx);

        }



        //m_BitmapData_Input

        {

            mtx.tx = -1 * 32;

            mtx.ty = -2 * 32;

            m_BitmapData_Input.draw(in_Graphic, mtx);

        }

    }

    static public function GetBitmapData_Trap(in_Index:int):BitmapData{

        return m_BitmapData_Trap[in_Index];

    }

    static public function CreateNinePatch_Button(in_W:int, in_H:int):NinePatch{

        return new NinePatch(m_BitmapData_Button, BUTTON_NINEPATCH_RAD, in_W, in_H);

    }

    static public function CreateNinePatch_Input(in_W:int, in_H:int):NinePatch{

        return new NinePatch(m_BitmapData_Input, BUTTON_NINEPATCH_RAD, in_W, in_H);

    }

}





class Util

{

    static public function CreateButton(in_W:int, in_H:int, in_Str:String, in_StrW:int):Button

    {

        var button:Button = new Button(in_W, in_H);

        var bmd:BitmapData = button.m_BitmapData;



        var tf:TextField = new TextField();

        //var mtx:Matrix = new Matrix();

        {

            tf.selectable = false;

            tf.autoSize = TextFieldAutoSize.CENTER;

            tf.defaultTextFormat = new TextFormat("_明朝", in_StrW, 0x000000, true);

            tf.x = in_W/2;

            tf.y = in_H/2 - in_StrW/2;

        }



        var text_sprite:Sprite = new Sprite();

        text_sprite.addChild(tf);



        tf.text = in_Str;

        bmd.draw(text_sprite);



        return button;

    }

}

