/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eGkX
 */

package
{
	import flash.display.Sprite;
 
	public class Main extends Sprite
	{
		public function Main()
		{
			graphics.beginFill(0x0);
			graphics.drawRect(0, 0, 465, 465);
			graphics.endFill();
 
			var window:Window = new Window();
			addChild(window);
		}
	}
}
 
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import com.bit101.components.Label;
 
class Window extends Sprite
{
	public function Window(width:int = 200, height:int = 200, title:String = "Window", close:Boolean = true)
	{
		var label:Label = new Label(this, 2, 2, title);
		label.scaleX = label.scaleY = 1.3;
 
		var matrix:Matrix = new Matrix();
		matrix.createGradientBox(width, height, 90 * Math.PI / 180);
 
		graphics.beginGradientFill("linear", [0x696969, 0x1C1C1C], [1.0, 1.0], [0, height / 10], matrix);
		graphics.drawRoundRect(0, 0, width, height, 10, 10);
		graphics.endFill();
 
		if (close)
		{
			var button:Sprite = new Sprite();
			button.graphics.beginFill(0x0, 0);
			button.graphics.drawRect(-10, -10, 20, 20);
			button.graphics.endFill();
 
			button.graphics.lineStyle(1.0, 0xBBBBBB);
			button.graphics.moveTo(-4, -4);
			button.graphics.lineTo( 4,  4);
			button.graphics.moveTo( 4, -4);
			button.graphics.lineTo(-4,  4);
			button.x = width - 13;
			button.y = 13;
			button.addEventListener(MouseEvent.MOUSE_DOWN, closeWindow);
			addChild(button);
		}
 
		addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
	}
 
	private function onMouseDown(event:MouseEvent):void
	{
		startDrag();
 
		addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
	}
 
	private function onMouseUp(event:MouseEvent):void
	{
		stopDrag();
 
		removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
	}
 
	private function closeWindow(event:MouseEvent = null):void
	{
		if (this.parent != null)
		{
			this.parent.removeChild(this);
		}
	}
}
