/**
 * Copyright Glidias ( http://wonderfl.net/user/Glidias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eFkY
 */

package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    public class SimpleEllipsoidOverlapCheck extends Sprite {
        
        private var pEclipse:Eclipse;
        private var other:Eclipse;

        public function SimpleEllipsoidOverlapCheck() {
            // write as3 code here..
            addChild(pEclipse = new Eclipse(16, 32, 0xFF0000));
            addChild(other = new Eclipse(46,24 , 0x0000FF));
            other.x = 144;
            other.y = 155;
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
        }
        
        private function onEnterFrame(e:Event):void 
        {
            var px:Number;
            var py:Number;
            var ox:Number = other.x;
            var oy:Number = other.y;
            
            pEclipse.x = px = mouseX;
            pEclipse.y = py = mouseY;
            var rx:Number = pEclipse.rx + other.rx;
            var ry:Number = pEclipse.ry + other.ry;
            var pRadius:Number = rx > ry ? rx :ry;
            var prScaleX:Number =  pRadius / rx;
            var prScaleY:Number =  pRadius / ry;
            
            // check if overlap
            var dx:Number = ox - px;
            var dy:Number = oy - py; 
            //var dz:Number = pz - oz;
            dx *= prScaleX;
            dy *= prScaleY;

            var d:Number = dx * dx + dy * dy;
            if (d <= pRadius*pRadius) {
                 pEclipse.alpha = .5;
            }
            else pEclipse.alpha = 1;
            
        }
    }
}
import flash.display.Shape;

class Eclipse extends Shape {
    public var rx:Number;
    public var ry:Number;
    public function Eclipse(rx:Number, ry:Number, color:uint):void {
        graphics.beginFill(color, 1);
        graphics.drawCircle(0,0,1);
        scaleX = rx;
        scaleY = ry;
        this.rx = rx;
        this.ry = ry;
        
    }
    
}