/**
 * Copyright s26 ( http://wonderfl.net/user/s26 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eFbe
 */

//つかんでなげる。
package  {
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	
	public class user1 extends Sprite {
		var _ball:Ball
		public function user1() {
			var _sp:Sprite = new Sprite();
			_sp.graphics.beginFill(0x666666, 1);
			_sp.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
			_sp.graphics.endFill();
			addChild(_sp)
			init();
			setEvent();
		}
		
		var _ballArr:Array
		private function init() {
			_ballArr = new Array();
			for (var i:Number = 0 ; i < 40 ; i++ ) {
				var _b:Sprite = new Ball(30 - i*i/160)
				_b.x = stage.stageWidth / 2;
				_b.y = stage.stageHeight / 2;
				_b.alpha = 0.8
				//_b.blendMode = BlendMode.ADD
				addChild(_b)
				_ballArr.push(_b)
				_b.filters = [new BlurFilter(5, 5, BitmapFilterQuality.HIGH)];
			}
			for (var j:Number = 0 ; j < 40 ; j++ ) {
				var _d:Sprite = new Ball(20 + j*j/160)
				_d.x = stage.stageWidth / 2;
				_d.y = stage.stageHeight / 2;
				_d.alpha = 0.8
				//_d.blendMode = BlendMode.ADD
				addChild(_d)
				_ballArr.push(_d)
				_d.filters = [new BlurFilter(5, 5, BitmapFilterQuality.HIGH)];
			}
			_ball= new Ball(20,0xff9900);
			addChild(_ball)
			_ball.blendMode = BlendMode.OVERLAY
			_ball.x = stage.stageWidth / 2;
			_ball.y = stage.stageHeight / 2;
			
			
		}
		
		private function setEvent():void {
			_ball.buttonMode = true;
			_ball.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			stage.addEventListener(Event.ENTER_FRAME, enterframeHandler)
			
			var _dragFlag:Boolean = false
			
			function mouseDownHandler():void {
				_ball.startDrag();
				stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
				_dragFlag = true
			}
			function mouseUpHandler():void {
				stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
				_ball.stopDrag();
				_dragFlag = false
			}
			
			var oldX:Number = stage.stageWidth / 2;
			var oldY:Number = stage.stageHeight / 2;
			var _friction:Number = 0.9
			function enterframeHandler():void {
				_ballArr[0].x +=(_ball.x - _ballArr[0].x)/1.2
				_ballArr[0].y += (_ball.y - _ballArr[0].y)/1.2
				for (var i:Number = 1 ; i < _ballArr.length; i++ ) {
					_ballArr[i].x += (_ballArr[i - 1].x - _ballArr[i].x) / 2;
					_ballArr[i].y += (_ballArr[i - 1].y - _ballArr[i].y) / 2;
				}
				if (_dragFlag==false) {
					_ball.x += _ball.vx
					_ball.y += _ball.vy
					_ball.vx *= 0.95
					_ball.vy *= 0.95;
					_ball.vy += 0.4
				}else {
					_ball.vx = _ball.x-oldX;
					_ball.vy = _ball.y-oldY;
					oldX = _ball.x
					oldY = _ball.y
				}
				
				if (_ball.y + _ball.height / 2 > stage.stageHeight) {
					_ball.y -= (_ball.y + _ball.height / 2 - stage.stageHeight) * _friction;
					_ball.vy = -_ball.vy
				}
				if (_ball.y - _ball.height / 2 < 0) {
					_ball.y += (_ball.height / 2-_ball.y) * _friction;
					_ball.vy = -_ball.vy
				}
				if (_ball.x + _ball.width / 2 > stage.stageWidth) {
					_ball.x -= (_ball.x + _ball.width / 2 - stage.stageWidth) * _friction;
					_ball.vx = -_ball.vx
				}
				if (_ball.x - _ball.width / 2 < 0) {
					_ball.x += (_ball.width / 2-_ball.x) * _friction;
					_ball.vx = -_ball.vx
				}
			}
		}
		
	}	
}

import flash.display.*;

class Ball extends Sprite {
	
	public var vx:Number = 0
	public var vy:Number = 0
	
	function Ball(_r:Number, _color=0xFF0000) {
		var _sp:Sprite = new Sprite();
		_sp.graphics.beginFill(_color, 1);
		_sp.graphics.drawCircle(0, 0, _r);
		_sp.graphics.endFill();
		addChild(_sp);
	}
	
}