/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eEva
 */

package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.BitmapDataChannel;
	import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.Loader;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    public class NetaCho001 extends Sprite {	

		// RGBボタン
  		private var r_btn:Sprite;
 		private var g_btn:Sprite;
 		private var b_btn:Sprite;

		// RGBチャンネルのビットマップ
		private var rBmp:Bitmap;
		private var gBmp:Bitmap;
		private var bBmp:Bitmap;
		
		// ビットマップを左・中・右に移動させるときのx座標
		private var lx:Number;
		private var cx:Number;
		private var rx:Number;
		
		// 赤緑青チャンネルのビットマップ到達点とするx座標
		private var rX:Number;
		private var gX:Number;
		private var bX:Number;
		
 		public function NetaCho001() {

 		    // 画像
 		    // 素材は「フリー素材／花・華・はな」よりお借りしました。
 		    // http://yuyusya.hp.infoseek.co.jp/hana-sozai.html 
			
			// 画像はhttp://assets.wonderfl.net/～じゃないとダメっぽい
			// Nicolasさんに感謝。
 		    var image_url:String = "http://assets.wonderfl.net/images/related_images/d/d0/d040/d040fecb6fc53edd51159d2499f5c5de0546d8f3";
            var urlReq:URLRequest = new URLRequest(image_url);
			var loader:Loader = new Loader();           
			loader = new Loader();           
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComp);
			loader.load(urlReq, new LoaderContext(true));
		
			// add 3 color butoons

 			r_btn = new Sprite();
 			r_btn.buttonMode = true;    	      
			r_btn.graphics.beginFill(0x00FFFF);
			r_btn.graphics.drawCircle(150, 350, 10);
			addChild(r_btn);
		       
	    		g_btn = new Sprite();
	    		g_btn.buttonMode = true;
			g_btn.graphics.beginFill(0xFF00FF);
			g_btn.graphics.drawCircle(200, 350, 10);
			addChild(g_btn);  

			b_btn = new Sprite();
			b_btn.buttonMode = true;
			b_btn.graphics.beginFill(0xFFFF00);
			b_btn.graphics.drawCircle(250, 350, 10);
			addChild(b_btn);	

//			addChild(loader);
 		}
		
		private function loadComp(evt:Event):void {
			var loader:Loader = Loader(evt.target.loader);
			// ロードしたデータからbitmaDataを作成する。
			var photoBmd:BitmapData = new BitmapData(loader.width, loader.height);
			photoBmd.draw(loader);

			// ビットマップデータを生成
			var rBmd:BitmapData = new BitmapData(photoBmd.width, photoBmd.height);
			var gBmd:BitmapData = new BitmapData(photoBmd.width, photoBmd.height);
			var bBmd:BitmapData = new BitmapData(photoBmd.width, photoBmd.height);

			// 画像の赤緑青チャンネルをそれぞれのBMPデータのチャンネルにコピー
			rBmd.copyChannel(photoBmd, photoBmd.rect, new Point(), 
								BitmapDataChannel.RED, BitmapDataChannel.RED);
			gBmd.copyChannel(photoBmd, photoBmd.rect, new Point(), 
								BitmapDataChannel.GREEN, BitmapDataChannel.GREEN);
			bBmd.copyChannel(photoBmd, photoBmd.rect, new Point(), 
								BitmapDataChannel.BLUE, BitmapDataChannel.BLUE);
			
			// BMPデータからBMP作成
			rBmp = new Bitmap(rBmd);
			gBmp = new Bitmap(gBmd);
			bBmp = new Bitmap(bBmd);
			
			// ブレンドモードの設定
			rBmp.blendMode = BlendMode.MULTIPLY;
			gBmp.blendMode = BlendMode.MULTIPLY;
			bBmp.blendMode = BlendMode.MULTIPLY;
			
			// ビットマップを左・中・右に移動させるときのx座標を設定
			lx = -photoBmd.width;
			cx = stage.stageWidth / 2 - photoBmd.width / 2;
			rx = stage.stageWidth;
			
			// 各チャンネルのビットマップの初期x座標を設定
			rBmp.x = lx;
			gBmp.x = cx;
			bBmp.x = rx;

			// 各チャンネルのビットマップの初期y座標を設定
			rBmp.y = 20;
			gBmp.y = 20;
			bBmp.y = 20;
			
			// ビットマップを表示リストに追加する
			addChild(rBmp);
			addChild(gBmp);
			addChild(bBmp);
						
			// x位置を中央に設定する
			centerX();
			
			// フレームが再生されるたびにonEnterframeを実行
			addEventListener(Event.ENTER_FRAME, onEnterframe);
			
			// ボタンにロールオーバーしたときの処理を設定
			r_btn.addEventListener(MouseEvent.ROLL_OVER, onROver);
			g_btn.addEventListener(MouseEvent.ROLL_OVER, onGOver);
			b_btn.addEventListener(MouseEvent.ROLL_OVER, onBOver);
			
			// ボタンにロールアウトしたときの処理を設定
			r_btn.addEventListener(MouseEvent.ROLL_OUT, onOut);
			g_btn.addEventListener(MouseEvent.ROLL_OUT, onOut);
			b_btn.addEventListener(MouseEvent.ROLL_OUT, onOut);
		}
		// 毎フレーム処理
		private function onEnterframe(evt:Event):void {
			var easing:Number = 0.2;
			rBmp.x += (rX - rBmp.x) * easing;
			gBmp.x += (gX - gBmp.x) * easing;
			bBmp.x += (bX - bBmp.x) * easing;
		}

		// r_btn マウスオーバー
		private function onROver(evt:MouseEvent):void {
			rX = cx;
			gX = lx;
			bX = rx;
		}

		// g_btn マウスオーバー
		private function onGOver(evt:MouseEvent):void {
			rX = rx;
			gX = cx;
			bX = lx;
		}

		// b_btn マウスオーバー
		private function onBOver(evt:MouseEvent):void {
			rX = lx;
			gX = rx;
			bX = cx;
		}

		// ボタンアウト
		private function onOut(evt:MouseEvent):void {
			centerX();
		}

		// センタリング
		private function centerX():void {
			rX = cx;
			gX = cx;
			bX = cx;
		}
	}
}
