/**
 * Copyright Antonio.Meneses ( http://wonderfl.net/user/Antonio.Meneses )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eEXi
 */

// forked from ll_koba_ll's Papervisionで作る「3D Flash」サンプルコード
package  {
    import caurina.transitions.Tweener;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import org.papervision3d.cameras.Camera3D
    import org.papervision3d.core.math.Matrix3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.primitives.Cylinder;
    import org.papervision3d.materials.WireframeMaterial
    import org.papervision3d.render.BasicRenderEngine
    import org.papervision3d.view.Viewport3D

    
    public class C2_1 extends Sprite
    {
        private var _viewport:Viewport3D;
        private var _scene:Scene3D;
        private var _camera:Camera3D;
        private var _container:DisplayObject3D;
        private var _sphere:Sphere;
        private var _cylinder:Cylinder;
        private var _renderer:BasicRenderEngine;
        private var _surface:Sprite;
        private var _transformed:Boolean;
        private var _rad:Number;

        public function C2_1() {
            init3D();
            addEventListener(
            Event.ENTER_FRAME, enterFrameHander);
        }
        
        private function init3D():void{
            _transformed = false;
            _rad = 0;
            
            //土台を作る
            _viewport = new Viewport3D(500,500);
            addChild( _viewport );
            _scene = new Scene3D();
            _camera = new Camera3D();
            _camera.z = -1300;
            
            //球を作る
            _sphere = new Sphere(
                new WireframeMaterial(0x0000AA),
                600, 24, 24);
            _sphere.x = -250;
            
            //円柱を作る
            _cylinder = new Cylinder(
                new WireframeMaterial(0xAA0000), 
                200, 200, 12, 12);
            _cylinder.x = 250;
            
            //コンテナを作る
            _container = new DisplayObject3D();
            _container.addChild(_sphere);
            _container.addChild(_cylinder);
            
            //カメラの視点をコンテナに固定する
            _camera.target = _container;
            _scene.addChild(_container);
            
            //レンダリングを設定する
            _renderer = new BasicRenderEngine();
            _renderer.renderScene(_scene, _camera, _viewport);
            
            //マウスインタラクションの追加
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
        }

        private function mouseUpHandler(event:MouseEvent):void {
            //拡大倍率
            var trans:Number = 2;
            //頂点をカウント
            var i:int = 0;
            for each(var p:* in _sphere.geometry.vertices) {
                if (i++% 9 ==1){
                    if(!_transformed){
                    Tweener.addTween(p, {
                      x:p.x*trans, y:p.y*trans,
                      z:p.z*trans, time:1,
                      transition:"lienar"
                    });
                    }else {
                    Tweener.addTween(p, { 
                      x:p.x/trans, y:p.y/trans,
                      z:p.z/trans, time:1,
                      transition:"lienar"
                    });  
                    }
                }
            }
            
            i = 0;
            for each(p in _cylinder.geometry.vertices) {
                if (i % 10 == 1) {
                    if (!_transformed) {
                    Tweener.addTween(p, {
                      x:p.x*trans, y:p.y*trans,
                      z:p.z*trans, time:1,
                      transition:"lienar"
                    });
                    }else {
                    Tweener.addTween(p, { 
                      x:p.x/trans, y:p.y/trans,
                      z:p.z/trans, time:1,
                      transition:"lienar"
                    });    
                    }
                }
                i++;
            }
            _transformed = !_transformed
        }

        private function enterFrameHander(event:Event):void{
            //回転速度をマウス座標から生成
            _rad  += (_viewport.width / 2 - mouseX) * .0005;
            
            //カメラの回転・移動
            _camera.x = Math.sin(_rad) * 1000
            _camera.y = (_viewport.height / 2 - mouseY) * 10;
            _camera.z = Math.cos(_rad) * -1000
            
            //再レンダリングする
            _renderer.renderScene(_scene, _camera, _viewport);
        }

    }
    
}
