/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eEUB
 */

package
{
    import com.bit101.components.Label;
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import com.bit101.components.TextArea;
    import flash.display.Sprite;
    import flash.events.Event;
 
    public class Main extends Sprite
    {
        private var textArea:TextArea;
        private var outputLabel:Label;
        
        public function Main()
        {
            Style.embedFonts = false;
            Style.fontName = "Terminal";
            Style.fontSize = 15;
            textArea = new TextArea(this);
            textArea.width = 465;
            textArea.height = 360;
            textArea.text =
            "v @_       v\r" + 
            ">0\"!dlroW\"v \r" +
            "v  :#     < \r" +
            ">\" ,olleH\" v\r" +
            "   ^       <";

            new PushButton(this, 365, 360, "OK", buttonHandler);
            outputLabel = new Label(this, 10, 420, "output: ");
            buttonHandler();
        }
        
        private function buttonHandler(event:Event = null):void 
        {
            var map:Array = [];
            var data:Array = textArea.text.split("\r");
            for (var i:int = 0; i < data.length; i++)
            {
                var array:Array = data[i].split("");
                map.push(array.concat(new Array(Befunge.WIDTH - array.length).map(function(...a):*{ return " "; } )));
            }
            
            var height:int = Befunge.HEIGHT - data.length;
            for (i = 0; i < height; i++)
            {
                map.push(new Array(Befunge.WIDTH).map(function(...a):*{ return " "; } ));
            }
            
            outputLabel.text = "output: " + new Befunge(map).execute();
        }
    }
}

class Befunge
{
    public static const WIDTH:int = 80;
    public static const HEIGHT:int = 25;
    private static const DIRECTION:Array = [ { x:0, y: -1 }, { x:1, y:0 }, { x:0, y:1 }, { x:-1, y:0 } ];
    private static const UP:int = 0, RIGHT:int = 1, DOWN:int = 2, LEFT:int = 3;
    
    private var x:int = 0;
    private var y:int = 0;
    private var dir:int = RIGHT;
    private var map:Array;
    private var stack:Vector.<int> = new Vector.<int>();
    private var skip:Boolean = false;
    private var charFlag:Boolean = false;
    private var outputText:String = "";
    
    public function Befunge(map:Array)
    {
        this.map = map;
    }
    
    public function execute():String
    {
        for (var i:int = 0; i < 10000; i++)
        {
            if (skip) skip = false;
            else
            {
                var char:String = map[y][x];
                if (charFlag)
                {
                    if (char == "\"") charFlag = false;
                    else stack.push(char.charCodeAt(0));
                }
                else
                {
                    if ("0" <= char && char <= "9") stack.push(int(char));
                    else if ("+-*/%`!:\\$gp".indexOf(char) != -1)
                    {
                        var ty:int = stack.pop();
                        if ("!:$".indexOf(char) == -1) var tx:int = stack.pop();
                        if (char == "p") var tv:int = stack.pop();
                        
                        switch (char)
                        {
                            case "+": stack.push(tx + ty);                              break;
                            case "-": stack.push(tx - ty);                              break;
                            case "*": stack.push(tx * ty);                              break;
                            case "/": stack.push(int(tx / ty));                         break;
                            case "%": stack.push(tx % ty);                              break;
                            case "`": stack.push((tx > ty) ? 1 : 0);                    break;
                            case "!": stack.push((ty == 0) ? 1 : 0);                    break;
                            case ":": stack.push(ty); stack.push(ty);                   break;
                            case "\\":stack.push(ty); stack.push(tx);                   break;
                            case "g": stack.push(map[ty][tx].charCodeAt(0));            break;
                            case "p": map[ty][tx] = String.fromCharCode(tv);            break;
                        }
                    }
                    else
                    {
                        switch(char)
                        {
                            case "<": dir = LEFT;                                       break;
                            case ">": dir = RIGHT;                                      break;
                            case "^": dir = UP;                                         break;
                            case "v": dir = DOWN;                                       break;
                            case "_": (stack.pop() == 0) ? dir = RIGHT : dir = LEFT;    break;
                            case "|": (stack.pop() == 0) ? dir = DOWN  : dir = UP;      break;
                            case "?": dir = DIRECTION.length * Math.random();           break;
                            case "#": skip = true;                                      break;
                            case "@": return outputText;
                            case "\"": charFlag = true;                                 break;
                            case ".": outputText += stack.pop() + " ";                  break;
                            case ",": outputText += String.fromCharCode(stack.pop());   break;
                        }            
                    }
                }
            }
            
            var o:Object = DIRECTION[dir];
            x += o.x;
            y += o.y;
            x = uint(x) % WIDTH;
            y = uint(y) % HEIGHT;
        }
        
        return outputText;
    }
}