/**
 * Copyright Wataru.Miyazaki ( http://wonderfl.net/user/Wataru.Miyazaki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eDsf
 */

// forked from Hiroki.Nigorinuma's forked from: forked from: Label機能
// forked from Wataru.Miyazaki's forked from: Label機能
// forked from Hiroki.Nigorinuma's Label機能
// forked from oshige's TextField_INPUT
package {
    import flash.ui.Mouse;
    import flash.geom.Rectangle;
    import flash.geom.Matrix;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.KeyboardEvent;
    import com.actionscriptbible.Example;
    public class CreateBaseBox extends Example {
        
        private var baseSprite:Sprite;
        private var baseTextField:TextField;
        private var baseMarker:BaseMarker;
        private var mouseMove:Boolean;
        private var sizing:Boolean;
        private var baseRect:Rectangle;
        
        public function CreateBaseBox(){
              
            baseRect = new Rectangle(100,100,300,24);  
              
            // フラグ
            mouseMove = false;
            sizing    = false;
            
            // ベースのオブジェクト
            baseSprite = new Sprite();
            //rect.graphics.beginFill(0xCCCCCC);
            baseSprite.graphics.drawRect(baseRect.x,baseRect.y,baseRect.width,baseRect.height);
            baseSprite.buttonMode = true;
            addChild(baseSprite);
            
            // テキストの書式
            var textFormat:TextFormat = new TextFormat();
            textFormat.font = "_typewriter";
            textFormat.size = 18;
            
            //テキスト入力フィールドの作成
            baseTextField = new TextField();
            //baseTextField.type = TextFieldType.INPUT;
            baseTextField.defaultTextFormat = textFormat;
            baseTextField.x = baseRect.x;
            baseTextField.y = baseRect.y;
            baseTextField.width = baseRect.width;
            baseTextField.height = baseRect.height;
            baseTextField.border = true;
            baseSprite.addChild(baseTextField);
            
            // 拡大縮小のボタン（BaseMarker）の作成
            baseMarker = new BaseMarker();
            baseMarker.x = baseRect.x+baseRect.width;
            baseMarker.y = baseRect.y+baseRect.height;
            baseSprite.addChild(baseMarker);
                        
            // イベント実装
            baseSprite.addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
            baseSprite.addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
            baseSprite.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            baseSprite.addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        
            baseMarker.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDownButton);
            baseMarker.addEventListener(MouseEvent.MOUSE_UP, onMouseUpButton);
            
        }
//=============================================================================
// ドラッグ移動 baseSpriteのマウスイベント        
        private function onMouseDown(e:MouseEvent):void{
            trace("onMouseDown");
            if (!sizing) {
                e.currentTarget.startDrag();
            }
        }
        private function onMouseUp(e:MouseEvent):void{
            //trace("onMouseUp");
            trace(e.currentTarget.x,e.currentTarget.y);
            if (!sizing) {
                e.currentTarget.stopDrag();
            }
        }
//=============================================================================
// 選択時に色づけ baseSpriteのマウスイベント                        
        private function onMouseOver(e:MouseEvent):void{
            //trace("onMouseOver");
            baseTextField.borderColor = 0xFF0000;
        }
        private function onMouseOut(e:MouseEvent):void{
            //trace("onMouseOut",baseSprite.x);
            baseTextField.borderColor = 0x000000;
        }
//=============================================================================
// 拡大縮小の種類を判別 baseMarkerのマウスイベント                
        private function onMouseDownButton(e:MouseEvent):void{
            trace("onMouseDownButton");
            mouseMove = true;
            sizing = true;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            e.currentTarget.startDrag();
        }
        private function onMouseUpButton(e:MouseEvent):void{
            trace("onMouseUpButton");
            mouseMove = false;
            sizing = false;
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            e.currentTarget.stopDrag();
        }
        private function onMouseMove(e:MouseEvent):void{
            //trace("onMouseMove",e.stageX,e.currentTarget.x,fld.x);
            stretchRight(e.stageX-baseTextField.x-baseSprite.x);     
            stretchDown(e.stageY-baseTextField.y-baseSprite.y);
            
        }        
//=============================================================================
// 拡大縮小 baseMarkerのマウスイベント          
        private function stretchRight(width:Number):void{
            baseTextField.width = width;
        }
        private function stretchLeft(width:Number):void{
            //baseTextField.width = width;
        }
        private function stretchDown(height:Number):void{
            baseTextField.height = height;
        }
        private function stretchUp(width:Number):void{
            //baseTextField.width = width;
        }
    }
}
//=============================================================================
// 拡大縮小ボタン
import flash.display.Sprite;

class BaseMarker extends Sprite{
    
    public var markerType:String;
    
    public function BaseMarker(){
        graphics.lineStyle(1, 0x999999);
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle(0, 0, 6);
    }
}