/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eDk8
 */

// forked from kotobuki's forked from: RGBCube for AS3
// forked from kotobuki's RGBCube for AS3
package {
    import flash.events.Event;

    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.*;

    import funnel.*;

    [SWF(backgroundColor="0x808080")]

    public class MeasuringTheTilt_Accelerometer extends BasicView {
        // 立方体
        private var cube:Cube;

        private var gio:Gainer;
        private var xAxisPin:Pin;
        private var yAxisPin:Pin;

        public function MeasuringTheTilt_Accelerometer() {
            gio = new Gainer();

            // 立方体のためのマテリアルを準備
            var materialsList:MaterialsList = new MaterialsList();
            materialsList.addMaterial(new ColorMaterial(0xFF0000), "front");
            materialsList.addMaterial(new ColorMaterial(0x00FF00), "back");
            materialsList.addMaterial(new ColorMaterial(0x0000FF), "right");
            materialsList.addMaterial(new ColorMaterial(0xFFFF00), "left");
            materialsList.addMaterial(new ColorMaterial(0xFF00FF), "top");
            materialsList.addMaterial(new ColorMaterial(0x00FFFF), "bottom");

            // 立方体のインスタンスを生成
            cube = new Cube(materialsList, 200, 200, 200);
            scene.addChild(cube);

            // カメラをセット
            camera.x = 0;
            camera.y = 0;
            camera.z = -500;
            camera.focus = 500;
            camera.zoom = 1;

            xAxisPin = gio.analogInput(0);
            xAxisPin.addFilter(new Scaler(0.3, 0.7, -1, 1, Scaler.LINEAR, true));
            xAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));

            yAxisPin = gio.analogInput(1);
            yAxisPin.addFilter(new Scaler(0.3, 0.7, -1, 1, Scaler.LINEAR, true));
            yAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));

            // レンダリング開始
            startRendering();
        }

        override protected function onRenderTick(event:Event = null):void {
            // 立方体の角度をセット
            cube.rotationZ = Math.asin(-yAxisPin.value) / Math.PI * 180;
            cube.rotationX = Math.asin(-xAxisPin.value) / Math.PI * 180;;

            // シーンをレンダリング
            renderer.renderScene(scene, camera, viewport);
        }
    }
}