/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eDJT
 */

package 
{
    import adobe.utils.CustomActions;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import flash.net.NetConnection;
    import flash.net.NetGroup;
    import flash.net.GroupSpecifier;
    import flash.net.NetGroupSendMode;
    import flash.events.NetStatusEvent;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    
    /**
     * ...
     * @author okoi
     */
    public class Main extends Sprite 
    {
        private const SERVER:String = "rtmfp:";
        private const DEVKEY:String = "";
            
        private var nc:NetConnection;
        private var netGroup:NetGroup;
            
        [Bindable]
        private var user:String;
            
        [Bindable]
        private var connected:Boolean = false;    
        
        private var particleList:/*Particle*/Array = [];
        
        private var isShoot:Boolean = false;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.addEventListener( MouseEvent.MOUSE_DOWN, mouseDown );
            stage.addEventListener( MouseEvent.MOUSE_UP, mouseUp );
            addEventListener( Event.ENTER_FRAME, enterFrameHandler );
            
            connect();
        }
        
        private function connect():void{
            nc = new NetConnection();
            nc.addEventListener(NetStatusEvent.NET_STATUS,netStatus);
            nc.connect(SERVER+DEVKEY);    
        }
            
        private function netStatus(event:NetStatusEvent):void{
            //write(event.info.code);
            //trace(event.info.code);
                
            switch(event.info.code){
                    case "NetConnection.Connect.Success":
                        trace("NetConnection.Connect.Success");
                        setupGroup()
                        break;
                    
                    case "NetGroup.Connect.Success":
                    trace("NetGroup.Connect.Success");
                        connected = true;
                        
                        break;
                    
                    case "NetGroup.Posting.Notify":
                        receiveParticle(event.info.message);
                        break;
                    case "NetGroup.SendTo.Notify":
                        receiveParticle(event.info.message);
                        break;
                }
            }
            
            private function setupGroup():void{
                var groupspec:GroupSpecifier = new GroupSpecifier("myGroup/particle");
                groupspec.serverChannelEnabled = true;
                groupspec.postingEnabled = true;
                groupspec.ipMulticastMemberUpdatesEnabled = true;
                groupspec.routingEnabled = true;
                groupspec.addIPMulticastAddress("239.225.0.1:30303");
                
                trace("Groupspec: "+groupspec.groupspecWithAuthorizations());
                
                netGroup = new NetGroup(nc,groupspec.groupspecWithAuthorizations());
                netGroup.addEventListener(NetStatusEvent.NET_STATUS,netStatus);
            
                
                user = "user"+Math.round(Math.random()*10000);
            }
        
        private function mouseDown( e:MouseEvent ) : void
        {
            isShoot = true;
        }
        private function mouseUp( e:MouseEvent ) : void
        {
            isShoot = false;
        }
        
        private function shoot( e:MouseEvent = null ) : void 
        {    
            var message:Object = new Object();
            message.sender = netGroup.convertPeerIDToGroupAddress(nc.nearID);    
            message.user = "okoi";
            message.x = stage.mouseX;
            message.y = stage.mouseY;
            
            netGroup.sendToAllNeighbors(message);
            
            receiveParticle(message);
        }
        
        private function receiveParticle( obj:Object ) : void
        {
            var particle:Particle = new Particle( obj.x, obj.y );
            
            particleList.push( particle );
        }
        
        private function enterFrameHandler( e:Event ) : void
        {
            
            graphics.clear();
            graphics.lineStyle( 1, 0 ); 
            for ( var i:int = particleList.length - 1; i >= 0; i-- ) {
                
                graphics.drawCircle( particleList[i].x, particleList[i].y, 5 );
                
                particleList[i].move();
                if ( particleList[i].x < 0 || particleList[i].x > 465 || particleList[i].y < 0 || particleList[i].y > 465 ) {
                    particleList.splice(i, 1);
                }
            }
        
            if ( isShoot ) shoot();
        }
        
    }
    
}

    /**
     * 
     * @author okoi
     */
    class Particle 
    {
        public var x:Number;
        public var y:Number;
        public var vx:Number;
        public var vy:Number;
    
        public function Particle(x:Number, y:Number) 
        {
            this.x = x;
            this.y = y;
            
            var angle:Number = Math.random() * 360;
            vx = Math.cos( angle * Math.PI / 180 ) * 5;
            vy = Math.sin( angle * Math.PI / 180 ) * 5;
            
            
        }
        
        public function move() : void 
        {
            x += vx;
            y += vy;
        }
        
    }