/**
 * Copyright hacker_6i2s2wey ( http://wonderfl.net/user/hacker_6i2s2wey )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eClF
 */

// forked from k__'s Jellyfish
package {
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.utils.*;
	
	
	public class Main extends Sprite {
		private var canvas:BitmapData;
		private var canvasRect:Rectangle;
		private var brush:Shape;
		private var cx:Number,cy:Number;
		private var verts:Vector.<Number>;
		private var pVerts:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var pmtx:Matrix3D;
		private var pers:PerspectiveProjection;
		private var xr:Number = 0, yr:Number = 0;
		private var nodes:Vector.<Node>;
		private var initNum:uint = 36;
		private var cldNum:Number =1;
		private var level:uint = 18;
		private var particles:Vector.<Vector3D>;
		
		public function Main() {
			cx = stage.stageWidth / 2;
			cy = stage.stageWidth / 2;
			pVerts = new Vector.<Number>();
			pmtx = new Matrix3D();
			pers = new PerspectiveProjection();
			uvts = new Vector.<Number>();
			particles = new Vector.<Vector3D>();
			
			addChild(new Bitmap(canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000)));
			canvasRect = canvas.rect;
			brush = new Shape();
			
			
			nodes = new Vector.<Node>();
			var temp:Vector.<Node> = new Vector.<Node>;
			var temp2:Vector.<Node>;
			var n:Node = new Node();
			temp.push(n);
			nodes.push(n);
			n.index = 0;
			n.z = -30;
			var ind:uint = 1;
			for (var i:uint = 0; i < level; i ++) {
				temp2 = new Vector.<Node>;
				for (var j:uint = 0; j < temp.length ; j ++) {
					var childNum:uint = (i ==0) ? initNum : cldNum;
					for (var k:uint = 0; k < childNum; k ++) {
						n = new Node();
						n.parent = temp[j];
						if (temp2.length > 0) {
							n.siblings.push(temp2[temp2.length -1]);
						}
						n.d = 10;
						n.rz = Math.PI * 2 / temp.length / childNum * temp2.length;
						if (i > 0) {
							n.rz = Math.PI * 2 / temp.length / childNum * k - Math.PI * 2 / temp.length / childNum * (childNum / 2 - 0.5);
						}
						n.ry = 0.1;
						n.vr = Math.random() / 10
						
						n.index = ind;

						temp2.push(n);
						nodes.push(n);
						ind ++;
						
					}
				}
				temp2[0].siblings.push(temp2[temp2.length - 1]);
				temp = temp2;
			}
			addEventListener(Event.ENTER_FRAME, h_enterframe);
		}
		
		private function h_enterframe(evt:Event):void {
			yr += (cx - mouseX) / 200;
			xr += (cy - mouseY) / 200;
			render();
		}
		
		private function render():void {
			verts = new Vector.<Number>();
			var i:uint, j:uint;
			for (i = 0; i < nodes.length;i ++) {
				nodes[i].r += nodes[i].vr;
				if (nodes[i].parent) {
					var d2:Number;
					nodes[i].troty = nodes[i].ry + nodes[i].parent.troty + Math.sin(nodes[i].r) / 10;
					nodes[i].trotz = nodes[i].rz + nodes[i].parent.trotz;
					nodes[i].z = Math.sin(nodes[i].troty) * nodes[i].d + nodes[i].parent.z;
					d2 = Math.cos(nodes[i].troty) * nodes[i].d;
					nodes[i].x = Math.cos(nodes[i].trotz) * d2 + nodes[i].parent.x;
					nodes[i].y = Math.sin(nodes[i].trotz) * d2 + nodes[i].parent.y;
				} 
				verts.push(nodes[i].x);
				verts.push(nodes[i].y);
				verts.push(nodes[i].z);
			}
			
			pers.fieldOfView = 100;
			pmtx.identity();
			pmtx.appendRotation(yr, Vector3D.Y_AXIS);
			pmtx.appendRotation(xr, Vector3D.X_AXIS);
			pmtx.appendTranslation(0, 0, pers.focalLength);
			pmtx.append(pers.toMatrix3D());
			bugfix(pmtx);
			Utils3D.projectVectors(pmtx, verts, pVerts, uvts);
			
			
			var fl:Number = pers.focalLength;
			var g:Graphics = brush.graphics;
			g.clear();
			g.lineStyle(7, 0x111111,0.2);
			for (i = 0; i < pVerts.length / 2; i ++) {
				if (nodes[i].parent) {
					g.moveTo(pVerts[i * 2] + cx, pVerts[i * 2 + 1] + cy);
					g.lineTo(pVerts[nodes[i].parent.index * 2] + cx, pVerts[nodes[i].parent.index * 2 + 1] + cy);
					
					for (j = 0; j < nodes[i].siblings.length; j ++) {
						g.moveTo(pVerts[i * 2] + cx, pVerts[i * 2 + 1] + cy);
						g.lineTo(pVerts[nodes[i].siblings[j].index * 2] + cx, pVerts[nodes[i].siblings[j].index * 2 + 1] + cy);
					}
					
				}
			}
			
			
			canvas.draw(brush, null, null, BlendMode.ADD);
			canvas.applyFilter(canvas,canvas.rect,new Point(0,0),new BlurFilter(2,2));
			canvas.applyFilter(canvas, canvas.rect, new Point(0,0),
			new ColorMatrixFilter([
								  0.9,0,0,0,
								  0,0.9,0,0,
								  0,0.1,0.9,0,
								  0,0,0,1,0]));
		}
		
		
		private function bugfix(matrix:Matrix3D):void {
			var m1:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 1, 0 ]));
			var m2:Matrix3D = new Matrix3D(Vector.<Number>([ 0, 0, 0, 0,  0, 0, 0, 0,  0, 0, 0, 1,  0, 0, 0, 0 ]));
			m1.append(m2);
			if (m1.rawData[15] == 20) {
				var rawData:Vector.<Number> = matrix.rawData;
				rawData[15] /= 20;
				matrix.rawData = rawData;
			}
		}
		
	}
}


class Node {
	public var x:Number = 0,y:Number = 0,z:Number = 0;
	public var index:uint = 0;
	public var rz:Number = 0,ry:Number = 0,d:Number = 0,r:Number = 0, vr:Number = 0;
	public var trotz:Number = 0,troty:Number = 0;
	public var parent:Node;
	public var siblings:Vector.<Node> = new Vector.<Node>;
}



