/**
 * Copyright Byung-il.Han ( http://wonderfl.net/user/Byung-il.Han )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eCM9
 */

// forked from Fred_Flanders's flash on 2010-12-6
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    [SWF(width="512",height="384",frameRate="20")]
    public class HellCam extends Sprite
    {
        protected var __camera:Camera;
        protected var __video:Video;
        
        protected var __width:int;
        protected var __height:int;
        protected var __quality:Number;
        protected var __fps:Number;
        
        protected var __prevbuffer:BitmapData;
        protected var __buffer:BitmapData;
        
        protected var __finalBitmapData:BitmapData;
        protected var __dispBitmapData:BitmapData;
        protected var __display:Bitmap;
        protected var __point:Point;
        protected var __rect:Rectangle;
        
        protected var __fadeCT:ColorTransform;
        protected var __offsetMatrix:Matrix;
        
        protected var __blur:BlurFilter;
        protected var __displacement:DisplacementMapFilter;
        
        protected var __dispSeed:Number=0;
        protected var tfWarning:TextField;
     
        protected var __paletteR:Array = [0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xffffff,0xfffff8,0xfffff1,0xffffea,0xffffe3,0xffffdd,0xffffd6,0xffffcf,0xffffc8,0xffffc1,0xffffbb,0xffffb4,0xffffad,0xffffa6,0xffff9f,0xffff99,0xfff892,0xfff28c,0xffeb85,0xffe57f,0xffdf79,0xffd872,0xffd26c,0xffcc66,0xffc55f,0xffbf59,0xffb852,0xffb24c,0xffac46,0xffa53f,0xff9f39,0xff9933,0xff922c,0xff8c26,0xff851f,0xff7f19,0xff7913,0xff720c,0xff6c06,0xff6600,0xf96300,0xf36100,0xed5e00,0xe75c00,0xe15a00,0xdc5700,0xd65500,0xd05300,0xca5000,0xc44e00,0xbe4c00,0xb94900,0xb34700,0xad4500,0xa74200,0xa14000,0x9b3e00,0x963b00,0x903900,0x8a3700,0x843400,0x7e3200,0x783000,0x732d00,0x6d2b00,0x672900,0x612600,0x5b2400,0x562200,0x552100,0x542100,0x532000,0x522000,0x512000,0x501f00,0x4f1f00,0x4e1f00,0x4d1e00,0x4c1e00,0x4b1d00,0x4a1d00,0x491d00,0x481c00,0x471c00,0x471c00,0x461b00,0x451b00,0x441a00,0x431a00,0x421a00,0x411900,0x401900,0x3f1900,0x3e1800,0x3d1800,0x3c1800,0x3b1700,0x3a1700,0x391600,0x391600,0x381600,0x371500,0x361500,0x351500,0x341400,0x331400,0x321300,0x311300,0x301300,0x2f1200,0x2e1200,0x2d1200,0x2c1100,0x2b1100,0x2b1100,0x2a1000,0x291000,0x280f00,0x270f00,0x260f00,0x250e00,0x240e00,0x230e00,0x220d00,0x210d00,0x200c00,0x1f0c00,0x1e0c00,0x1d0b00,0x1c0b00,0x1c0b00,0x1b0a00,0x1a0a00,0x190900,0x180900,0x170900,0x160800,0x150800,0x140800,0x130700,0x120700,0x110700,0x100600,0xf0600,0xe0500,0xe0500,0xd0500,0xc0400,0xb0400,0xa0400,0x90300,0x80300,0x70200,0x60200,0x50200,0x40100,0x30100,0x20100,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0];
        protected var __paletteG:Array = [];
        protected var __paletteB:Array = [];
         
        public function HellCam(){

            init();
        }
        protected function init():void{            
            __quality = 0.75;
            if(stage!=null)    {
                stage.align = StageAlign.TOP_LEFT;
                stage.scaleMode = StageScaleMode.NO_SCALE;
                __width = stage.stageWidth*__quality;
                __height = stage.stageHeight*__quality;
            }            
            else
            {
                __width = 512*__quality;
                __height =384*__quality;
                
            }
            __fps=30;
            __point=new Point();
            __fadeCT = new ColorTransform(1,1,1,0.92);
            __offsetMatrix=new Matrix();
            __blur=new BlurFilter(2,4,1);
            __dispSeed=0;
            for(var i:int=0;i<255;i++){
                __paletteG[i]=0;
                __paletteB[i]=0;
            }            
            
            initCamera();
            initVideo();
            initBitmaps();
            __displacement = new DisplacementMapFilter(__dispBitmapData,__point,BitmapDataChannel.RED,BitmapDataChannel.GREEN,5,10);
            start();
        }
        protected function initCamera():void
        {
            var arr:Array = Camera.names;
            arr.push("0");
            var len:int=arr.length;
            var ypos:int=0;
            var i:int;
            var _container:Sprite = new Sprite();
            for(i=0;i<len;i++){
                var tf:TextField = new TextField();
                tf.defaultTextFormat=new TextFormat("_sans",10,0,false,false,false,null,null,TextFormatAlign.CENTER);
                tf.text=arr[i];
                tf.border=true;
                tf.background=true;
                tf.y=ypos;
                tf.selectable=false;
                tf.height=tf.textHeight+5;
                tf.addEventListener(MouseEvent.CLICK,handleClickWebcam,false,0,true);
                _container.addChild(tf);
                ypos+=tf.height+5;
                if(__camera==null){
                    __camera=Camera.getCamera(arr[i]);
                }
                if(__camera==null){
                    __camera=Camera.getCamera(i.toString());
                }
            }
            
            if(__camera!=null){
                __camera.setMode(__width,__height,__fps);
                
            }
            else{
                tfWarning=new TextField();
                tfWarning.autoSize=TextFieldAutoSize.LEFT;
                tfWarning.defaultTextFormat=new TextFormat("_sans");
                tfWarning.text="Could not initialize webcam";
                tfWarning.background=true;
                tfWarning.backgroundColor=0xFFFF00;
                tfWarning.x=100;
                tfWarning.y=100;
                addChild(tfWarning);
                addChild(_container);
            }
        }
        protected function handleClickWebcam(evt:Event):void{
            var tf:TextField = evt.currentTarget as TextField;
            var id:String = tf.text;
            
            __camera = Camera.getCamera(id);
            tfWarning.visible=__camera==null;
            if(__camera!=null)
            {
                if(__video==null)
                {
                    __video=new Video(__width,__height);
                }
                __video.attachCamera(__camera);
            }
        }
        protected function initVideo():void{
            __video = new Video(__width,__height);
            if(__camera!=null){
                __video.attachCamera(__camera);
            }
        }
        protected function initBitmaps():void{
            __finalBitmapData = new BitmapData(__width,__height,false,0);
            __rect=__finalBitmapData.rect;
            __buffer = new BitmapData(__width,__height,true,0);
            __prevbuffer = new BitmapData(__width,__height,true,0);
            __dispBitmapData = new BitmapData(__width,__height,false,0);
            applyNoise();
            __display = new Bitmap(__finalBitmapData,"auto",true);
            __display.scaleX=1/__quality;
            __display.scaleY=1/__quality;
            addChildAt(__display,0);
        }
        protected function applyNoise():void{
            __dispBitmapData.perlinNoise(24,32,4,__dispSeed,true,true,7);
            __dispSeed+=1;
            if(__dispSeed>1000)    {
                __dispSeed %= 1000;
            }
        }
        protected function start():void{
            addEventListener(Event.ENTER_FRAME,handleEnterFrame,false,0,true);
        }
        protected function handleEnterFrame(evt:Event):void{
            render();
        }
        protected function render():void{
            __offsetMatrix.ty=-(Math.random()*2+4);
            __offsetMatrix.tx=Math.random()*2-1;
            
            __finalBitmapData.lock();
            __buffer.draw(__video);
            __buffer.draw(__prevbuffer,__offsetMatrix,__fadeCT);
            __buffer.applyFilter(__buffer,__rect,__point,__blur);
            applyNoise();
            __buffer.applyFilter(__buffer,__rect,__point,__displacement);
            __prevbuffer.copyPixels(__buffer,__rect,__point);
        
            
            __finalBitmapData.copyPixels(__buffer,__rect,__point);
            //__finalBitmapData.paletteMap(__buffer,__rect,__point,__paletteR,__paletteG,__paletteB);
            
            __finalBitmapData.unlock();    
        }
    }
}