/**
 * Copyright MR_WUT4 ( http://wonderfl.net/user/MR_WUT4 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eBrM
 */

package 
{
	/**
	 * @author David Ochmann
	 */

	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Camera;
	import flash.media.Video;
	import flash.utils.setTimeout;
	
	import flash.text.TextField;
	public class BrickWave extends Sprite 
	{		
		private const BRICK_COLOR1:uint = 0xFFFFFF;
		private const BRICK_COLOR2:uint = 0x333333;
		
		private const BORDER:uint = 2;
		
		private var BRICK_WIDTH:uint  = 10;
		private var BRICK_HEIGHT:uint = 10;
		private var BRICK_DEPTH:uint  =  1;

		private var mGridWidth:uint   = 40;
		private var mGridHeight:uint  = 40;

		private var mContainer:Sprite;
		private var mBrickContainer:Sprite;
		private var mGridList:Array;
		private var mListLength:uint;
		private var mBitmapData:BitmapData;
		private var mBitmap:Bitmap;
		private var mRectangle:Rectangle;
		private var mPoint:Point;
		private var mColorMatrixFilter:ColorMatrixFilter;
		private var mOffset:Array;
		private var mCamera:Camera;
		private var mVideo:Video;
		private var mFirstBrick:Brick;
		
		
		
		public function BrickWave()
		{
			setTimeout(initialize, 50);
		}
		
		
		
		private function initialize():void
		{
			initFPS();
			initVariables();
			initColorMatrixFilter();
			initContainer();
			initBrickContainer();
			initGrid();
			initBitmapData();
			initBitmap();
			initRectangle();
			initCamera();
			initVideo();
			initEnterFrame();
		}

		private function initFPS():void
		{

			
			
		}
		
		private function initVariables():void
		{
			mOffset = new Array();
			mOffset.push(new Point(0, 0), new Point(0, 0), new Point(0, 0));
			
			mGridList = new Array();
			
			mPoint = new Point(0, 0);
			
			mGridWidth  = Math.floor(stage.stageWidth / BRICK_WIDTH);
			mGridHeight = Math.floor(stage.stageHeight / BRICK_HEIGHT);
		}
	
		private function initColorMatrixFilter():void
		{
			var matrix:Array = new Array();
				
            matrix = matrix.concat([1, 0, 0, 0, 0]); // red
            matrix = matrix.concat([1, 0, 0, 0, 0]); // green
            matrix = matrix.concat([1, 0, 0, 0, 0]); // blue
            matrix = matrix.concat([0, 0, 0, 1, 0]); // alpha
			
			mColorMatrixFilter = new ColorMatrixFilter(matrix);
		}
		
		private function initContainer():void
		{
			mContainer = new Sprite();
			mContainer.filters = [mColorMatrixFilter];
			
			addChild(mContainer);
		}

		private function initBrickContainer():void
		{
			mBrickContainer = new Sprite();			
			mContainer.addChild(mBrickContainer);
		}

		private function initGrid():void
		{
			var brick:Brick;
			
			for(var i:int = mGridWidth - 1; i > -1; --i)
			{				
				for(var j:int = 0; j < mGridHeight; ++j)
				{
					brick = new Brick();
					
					brick.mWidth = BRICK_WIDTH;
					brick.mHeight = BRICK_HEIGHT;
					brick.mDepth = BRICK_DEPTH;
					brick.mColor1 = BRICK_COLOR1;
					brick.mColor2 = BRICK_COLOR2;
										
					brick.x = i * BRICK_WIDTH;
					brick.y = j * BRICK_HEIGHT;
										
					mGridList.push(brick);
					mBrickContainer.addChild(brick);					
				}
			}
			
			for(var k:int = mGridList.length - 1; k > -1; --k)
			{
				brick = Brick(mGridList[k]);
				brick.mNext = Brick(mGridList[k + 1]);
			}
			
			mFirstBrick = Brick(mGridList[0]);
			mListLength = mGridList.length;
		}

		private function initBitmapData():void
		{
			mBitmapData = new BitmapData(BRICK_WIDTH * mGridWidth, BRICK_HEIGHT * mGridHeight, false, 0xFFFFFFFF);
		}

		private function initBitmap():void
		{
			mBitmap = new Bitmap(mBitmapData, PixelSnapping.AUTO, false);
		}

		private function initRectangle():void
		{
			mRectangle = new Rectangle(0, 0, BRICK_WIDTH * mGridWidth, BRICK_HEIGHT * mGridHeight);
		}

		private function initCamera():void
		{
			mCamera = Camera.getCamera();
			mCamera.setMode(mGridWidth, mGridHeight, 24);
		}

		private function initVideo():void
		{
			mVideo = new Video(stage.stageWidth, stage.stageHeight);
			mVideo.attachCamera(mCamera);
		}

		private function initEnterFrame():void
		{
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}

		private function enterFrameHandler(e:Event):void
		{
			mBitmapData.draw(mVideo);
			
			var brick:Brick = mFirstBrick;
			var color:uint;
			var math:int;
			var depth:uint;
			var difference:int;
			
			while(brick)
			{
				color = mBitmapData.getPixel(brick.x, brick.y);
				math  = (color * .000002);				
				depth = (math) < 0 ? 0 : math;
				
				difference = brick.mDepth - depth;
				
				if(difference > BORDER || difference < -BORDER)
					brick.draw(depth, color);
				
				brick = brick.mNext;
			}
		}
	}
}

import flash.display.Shape;

final class Brick extends Shape
{
	public var mNext:Brick;
	public var mWidth:uint;
	public var mHeight:uint;
	public var mDepth:uint;
	public var mColor1:uint;
	public var mColor2:uint;
	public var mBorder:uint;

	
	public function Brick(){}


	public function draw(pDepth:uint = 5,
						 pColor:uint = 0xFFFFFF):void
	{		
		mDepth = pDepth;
	
		graphics.clear();
		graphics.beginFill(pColor);
		graphics.lineStyle(0, mBorder, 1, false);
		
		graphics.drawRect(pDepth, -pDepth, mWidth, mHeight);
		
		graphics.moveTo(pDepth		   , -pDepth		  	 );
		graphics.lineTo(pDepth		   , -pDepth + mHeight);
		graphics.lineTo(0			   , mHeight		  	 );
		graphics.lineTo(0			   , 0				 );
			
		graphics.endFill();
		graphics.beginFill(mColor2);
		
		graphics.moveTo(0			   , mHeight		  	 );
		graphics.lineTo(mWidth		   , mHeight		  	 );
		graphics.lineTo(mWidth + pDepth , -pDepth + mHeight);
		graphics.lineTo(pDepth		   , -pDepth + mHeight);
		graphics.lineTo(0			   , mHeight		 	 );
		
		graphics.endFill();
	}
}