/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eBes
 */

package
{
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import jp.progression.commands.Func;
	import jp.progression.commands.lists.SerialList;
	import jp.progression.commands.Wait;
	import com.bit101.components.PushButton;
 
	public class Main extends Sprite
	{	
		private var prev:Point = new Point();
		private var list:SerialList = new SerialList();
 
		public function Main()
		{	
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
 
			new PushButton(this, 182, 420, "replay", replay);
		}
 
		private function replay(event:MouseEvent):void
		{
			if (list.state == 2) return;
			graphics.clear();
			graphics.lineStyle(8.0, 0x0);
			list.execute();
		}
 
		private function onMouseDown(event:MouseEvent):void
		{	
			if (list.state == 2) return;
 
			prev.x = mouseX;
			prev.y = mouseY;
 
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
 
		private function onMouseMove(event:MouseEvent):void
		{
			graphics.lineStyle(8.0, 0x0);
			graphics.moveTo(prev.x, prev.y);
			graphics.lineTo(mouseX, mouseY);
 
			list.addCommand(new Func
			(
				function(startX:int, startY:int, endX:int, endY:int):void
				{
					graphics.moveTo(startX, startY);
					graphics.lineTo(endX, endY);
				}, [prev.x, prev.y, mouseX, mouseY]
			));
			list.addCommand(new Wait(0.01));
 
			prev.x = mouseX;
			prev.y = mouseY;
		}
 
		private function onMouseUp(event:MouseEvent):void
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
		}
	}
}
