/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eBCv
 */

package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.PushButton;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
	
        /**
        * 曲は夢幻のオルゴール工房さんにて配布されているmp3ファイルを使用しています
        * http://www.dream-orgel.net/diary.cgi?no=120&continue=on
        */
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=30)]
	public class LineReader extends Sprite
	{
		private var _field:Sprite = new Sprite();
		private var _paintField:Sprite = new Sprite();
		private var _uiField:Sprite = new Sprite();
		private var _stopUiField:Sprite = new Sprite();
		private var _startField:Sprite = new Sprite();
		
		//Clearエフェクト
		private var _clearEffBmp:Bitmap = new Bitmap();
		private var _clearBmd:BitmapData = new BitmapData(465,465,true,0);
		
		//座標リスト
		private var _pointListList:Array = new Array();
		private var _currentListIndex:int = 0;
		private var _actionFlg:Boolean = true;
		/**
		 * params
		 */
		private var _col:Number = 0xFFFFFF;
		/**
		 * Sound parts
		 */
		private var player:Object = new Object();
		private var loader:Loader = new Loader();
		private var bA:ByteArray;
		private var spectrum:Array;
		public static var lowVal:Number=0;
		public static var middleVal:Number=0;
		public static var highVal:Number = 0;
		private var sound:Sound;
		private var _ch:SoundChannel;
		
		/**
		 * UI
		 */
		private var _colSelector:ColorSelector;
		private var _colChooser:ColorChooser;
		
		/**
		 * RECORD
		 */ 
		private var _rec:DrawRecoder = new DrawRecoder();
		private var _player:DrawPlayer = new DrawPlayer();
		
		/**
		 * TIMER
		 */
		private var _startTime:int;
		
		public function LineReader()
		{
			init();
			setupDisplay();
		}
		
		public function init():void {
			DisplayShortcuts.init();
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			
			_field.graphics.clear();
			_field.graphics.beginFill(0xCCCCCC,0);
			_field.graphics.drawRect(0,0,465,465);
			_field.graphics.endFill();
			
			
			//UI Starting
			var _startButton:PushButton = new PushButton(_startField,20,20,"start", startHandler);
			//UI Playing
			//			var _actionBtn:PushButton = new PushButton(_uiField,20,20,"action",actionHandler);
			//			var _noActionBtn:PushButton = new PushButton(_uiField,20,45,"noAction",noActionHandler);
			var _clearBtn:PushButton = new PushButton(_uiField,20,20,"clear",clearHandler);
			var _plotBtn:PushButton = new PushButton(_uiField,20,45,"plot",plotHandler);
			var _stopBtn:PushButton = new PushButton(_uiField,20,120,"stop",stopHandler);
			//UI Stop
			var _playDataBtn:PushButton = new PushButton(_stopUiField,20,20,"play",playDataHandler);
			var _stopDrawBtn:PushButton = new PushButton(_stopUiField,20,45,"stop",stopDrawHandler);
			
			_colSelector = new ColorSelector();
			//			_colChooser = new ColorChooser(_uiField,20,145);
			
			//Effect Init
			_clearEffBmp.bitmapData = _clearBmd;
			_clearEffBmp.visible = false;
			_clearEffBmp.alpha = 0;
			//座標リスト
			var comListString:String = '[{"childlist":[{"time":2599,"x":136,"y":373},{"time":2722,"x":95,"y":356},{"time":2731,"x":94,"y":355},{"time":2741,"x":92,"y":352},{"time":2792,"x":87,"y":344},{"time":2800,"x":85,"y":341},{"time":2809,"x":85,"y":339},{"time":2819,"x":84,"y":338},{"time":2829,"x":84,"y":336},{"time":2840,"x":83,"y":334},{"time":2851,"x":83,"y":329},{"time":2863,"x":82,"y":327},{"time":2875,"x":82,"y":323},{"time":2889,"x":82,"y":320},{"time":2903,"x":82,"y":317},{"time":2918,"x":82,"y":316},{"time":2932,"x":82,"y":314},{"time":2947,"x":82,"y":313},{"time":2961,"x":83,"y":311},{"time":2977,"x":84,"y":308},{"time":2993,"x":86,"y":305},{"time":3009,"x":88,"y":301},{"time":3026,"x":90,"y":298},{"time":3042,"x":92,"y":295},{"time":3058,"x":94,"y":292},{"time":3074,"x":96,"y":291},{"time":3090,"x":96,"y":290},{"time":3109,"x":97,"y":289},{"time":3136,"x":101,"y":286},{"time":3163,"x":104,"y":283},{"time":3189,"x":108,"y":280},{"time":3216,"x":110,"y":279},{"time":3242,"x":112,"y":278},{"time":3268,"x":113,"y":277},{"time":3293,"x":116,"y":276},{"time":3316,"x":122,"y":274},{"time":3339,"x":126,"y":273},{"time":3361,"x":128,"y":273},{"time":3384,"x":129,"y":273},{"time":3406,"x":131,"y":273},{"time":3427,"x":134,"y":273},{"time":3447,"x":138,"y":273},{"time":3469,"x":142,"y":273},{"time":3490,"x":144,"y":274},{"time":3511,"x":146,"y":275},{"time":3530,"x":148,"y":277},{"time":3551,"x":153,"y":279},{"time":3570,"x":157,"y":283},{"time":3590,"x":160,"y":285},{"time":3610,"x":164,"y":288},{"time":3629,"x":166,"y":290},{"time":3650,"x":168,"y":292},{"time":3668,"x":172,"y":295},{"time":3687,"x":174,"y":298},{"time":3705,"x":177,"y":301},{"time":3725,"x":177,"y":302},{"time":3745,"x":178,"y":304},{"time":3766,"x":179,"y":306},{"time":3785,"x":180,"y":308},{"time":3805,"x":181,"y":310},{"time":3825,"x":181,"y":312},{"time":3845,"x":181,"y":313},{"time":3866,"x":181,"y":315},{"time":3887,"x":182,"y":317},{"time":3909,"x":182,"y":318},{"time":3929,"x":182,"y":320},{"time":3950,"x":182,"y":322},{"time":3971,"x":182,"y":324},{"time":3992,"x":182,"y":325},{"time":4013,"x":182,"y":327},{"time":4035,"x":181,"y":328},{"time":4055,"x":181,"y":329},{"time":4076,"x":181,"y":331},{"time":4097,"x":180,"y":334},{"time":4118,"x":179,"y":335},{"time":4139,"x":179,"y":336},{"time":4159,"x":178,"y":338},{"time":4179,"x":177,"y":340},{"time":4200,"x":174,"y":346},{"time":4220,"x":173,"y":348},{"time":4240,"x":172,"y":350},{"time":4260,"x":169,"y":354},{"time":4280,"x":168,"y":356},{"time":4301,"x":166,"y":358},{"time":4321,"x":163,"y":361},{"time":4341,"x":160,"y":363},{"time":4362,"x":155,"y":367},{"time":4383,"x":151,"y":370},{"time":4404,"x":145,"y":373},{"time":4425,"x":140,"y":375},{"time":4445,"x":138,"y":375},{"time":4466,"x":136,"y":375},{"time":4486,"x":135,"y":375},{"time":4506,"x":133,"y":375},{"time":4526,"x":131,"y":375},{"time":4547,"x":130,"y":375},{"time":4568,"x":129,"y":375},{"time":4589,"x":128,"y":374},{"time":4610,"x":126,"y":374},{"time":4630,"x":125,"y":374},{"time":4650,"x":123,"y":373},{"time":4670,"x":121,"y":372},{"time":4691,"x":120,"y":372},{"time":4711,"x":115,"y":370},{"time":4732,"x":114,"y":370},{"time":4753,"x":112,"y":370},{"time":4773,"x":111,"y":369},{"time":4794,"x":110,"y":369}],"id":0,"type":"draw","col":16777010,"time":2400,"fx":137,"fy":372},{"childlist":[{"time":5747,"x":321,"y":376},{"time":5831,"x":319,"y":376},{"time":5853,"x":313,"y":377},{"time":5873,"x":307,"y":377},{"time":5895,"x":305,"y":377},{"time":5919,"x":299,"y":377},{"time":5940,"x":295,"y":377},{"time":5961,"x":289,"y":377},{"time":5983,"x":285,"y":377},{"time":6004,"x":283,"y":376},{"time":6024,"x":281,"y":375},{"time":6044,"x":276,"y":373},{"time":6065,"x":275,"y":372},{"time":6085,"x":272,"y":370},{"time":6105,"x":270,"y":368},{"time":6126,"x":269,"y":367},{"time":6146,"x":266,"y":364},{"time":6167,"x":264,"y":361},{"time":6188,"x":263,"y":359},{"time":6208,"x":260,"y":354},{"time":6228,"x":257,"y":350},{"time":6252,"x":255,"y":346},{"time":6273,"x":253,"y":344},{"time":6294,"x":253,"y":343},{"time":6316,"x":252,"y":341},{"time":6337,"x":249,"y":336},{"time":6357,"x":247,"y":330},{"time":6378,"x":246,"y":324},{"time":6398,"x":246,"y":322},{"time":6418,"x":245,"y":319},{"time":6440,"x":244,"y":315},{"time":6461,"x":244,"y":313},{"time":6484,"x":244,"y":311},{"time":6504,"x":244,"y":308},{"time":6526,"x":244,"y":306},{"time":6547,"x":244,"y":305},{"time":6568,"x":245,"y":303},{"time":6588,"x":246,"y":300},{"time":6608,"x":248,"y":296},{"time":6629,"x":250,"y":293},{"time":6652,"x":251,"y":292},{"time":6672,"x":253,"y":288},{"time":6692,"x":256,"y":284},{"time":6713,"x":258,"y":282},{"time":6734,"x":261,"y":278},{"time":6756,"x":263,"y":276},{"time":6777,"x":265,"y":275},{"time":6797,"x":269,"y":270},{"time":6817,"x":272,"y":268},{"time":6837,"x":276,"y":266},{"time":6857,"x":280,"y":264},{"time":6877,"x":283,"y":262},{"time":6897,"x":286,"y":262},{"time":6918,"x":288,"y":261},{"time":6938,"x":290,"y":261},{"time":6960,"x":294,"y":261},{"time":6980,"x":300,"y":261},{"time":7006,"x":307,"y":262},{"time":7026,"x":314,"y":263},{"time":7046,"x":320,"y":264},{"time":7067,"x":323,"y":265},{"time":7089,"x":329,"y":267},{"time":7109,"x":334,"y":269},{"time":7129,"x":340,"y":272},{"time":7150,"x":344,"y":274},{"time":7170,"x":349,"y":278},{"time":7191,"x":354,"y":282},{"time":7211,"x":356,"y":284},{"time":7231,"x":360,"y":288},{"time":7252,"x":363,"y":293},{"time":7272,"x":365,"y":298},{"time":7292,"x":367,"y":302},{"time":7312,"x":368,"y":308},{"time":7333,"x":369,"y":316},{"time":7353,"x":369,"y":319},{"time":7375,"x":369,"y":321},{"time":7396,"x":369,"y":324},{"time":7419,"x":368,"y":326},{"time":7439,"x":367,"y":328},{"time":7460,"x":367,"y":330},{"time":7480,"x":365,"y":333},{"time":7501,"x":362,"y":338},{"time":7522,"x":360,"y":341},{"time":7542,"x":359,"y":342},{"time":7563,"x":358,"y":343},{"time":7584,"x":356,"y":345},{"time":7604,"x":353,"y":348},{"time":7626,"x":350,"y":351},{"time":7648,"x":349,"y":351},{"time":7669,"x":348,"y":352},{"time":7689,"x":348,"y":353},{"time":7709,"x":346,"y":355},{"time":7730,"x":344,"y":357},{"time":7750,"x":343,"y":359},{"time":7770,"x":342,"y":360},{"time":7791,"x":341,"y":360},{"time":7811,"x":340,"y":361},{"time":7831,"x":338,"y":363},{"time":7851,"x":337,"y":364},{"time":7871,"x":335,"y":365},{"time":7891,"x":331,"y":366},{"time":7911,"x":329,"y":368},{"time":7931,"x":324,"y":370},{"time":7952,"x":320,"y":372},{"time":7972,"x":315,"y":373},{"time":7993,"x":310,"y":374},{"time":8016,"x":306,"y":376},{"time":8036,"x":301,"y":377},{"time":8056,"x":299,"y":378},{"time":8077,"x":297,"y":378},{"time":8097,"x":295,"y":378},{"time":8118,"x":294,"y":378}],"id":0,"type":"draw","col":16777010,"time":5722,"fx":322,"fy":376},{"childlist":[{"time":8985,"x":135,"y":147},{"time":9005,"x":130,"y":150},{"time":9025,"x":123,"y":155},{"time":9045,"x":116,"y":161},{"time":9065,"x":100,"y":177},{"time":9085,"x":89,"y":188},{"time":9105,"x":81,"y":198},{"time":9125,"x":77,"y":203},{"time":9145,"x":75,"y":208},{"time":9165,"x":73,"y":211},{"time":9185,"x":73,"y":215},{"time":9205,"x":73,"y":217},{"time":9225,"x":73,"y":219},{"time":9245,"x":75,"y":224},{"time":9265,"x":77,"y":228},{"time":9286,"x":77,"y":229},{"time":9306,"x":78,"y":230},{"time":9326,"x":80,"y":231},{"time":9346,"x":82,"y":232},{"time":9367,"x":85,"y":235},{"time":9387,"x":88,"y":236},{"time":9407,"x":91,"y":237},{"time":9429,"x":96,"y":237},{"time":9453,"x":106,"y":237},{"time":9473,"x":112,"y":236},{"time":9494,"x":126,"y":233},{"time":9517,"x":134,"y":231},{"time":9537,"x":140,"y":230},{"time":9557,"x":142,"y":230},{"time":9577,"x":144,"y":230},{"time":9597,"x":145,"y":230},{"time":9617,"x":146,"y":230},{"time":9637,"x":148,"y":230},{"time":9657,"x":150,"y":230},{"time":9699,"x":151,"y":230},{"time":9721,"x":151,"y":229},{"time":9741,"x":152,"y":229},{"time":9762,"x":153,"y":228},{"time":9787,"x":155,"y":222},{"time":9807,"x":155,"y":218},{"time":9827,"x":155,"y":210},{"time":9850,"x":155,"y":202},{"time":9870,"x":153,"y":194},{"time":9890,"x":151,"y":190},{"time":9910,"x":149,"y":185},{"time":9931,"x":148,"y":179},{"time":9951,"x":147,"y":176},{"time":9971,"x":146,"y":171},{"time":9991,"x":146,"y":169},{"time":10034,"x":146,"y":168},{"time":10055,"x":146,"y":167},{"time":10076,"x":146,"y":166},{"time":10097,"x":146,"y":165},{"time":10120,"x":145,"y":163},{"time":10141,"x":145,"y":161},{"time":10161,"x":144,"y":160},{"time":10188,"x":143,"y":159},{"time":10208,"x":143,"y":158},{"time":10230,"x":141,"y":157},{"time":10252,"x":141,"y":156},{"time":10272,"x":141,"y":155},{"time":10310,"x":140,"y":154},{"time":10330,"x":140,"y":153},{"time":10354,"x":139,"y":152},{"time":10375,"x":137,"y":151},{"time":10396,"x":136,"y":150},{"time":10421,"x":134,"y":150},{"time":10442,"x":133,"y":149}],"id":0,"type":"draw","col":16777010,"time":8922,"fx":137,"fy":146},{"childlist":[{"time":11578,"x":189,"y":148},{"time":11597,"x":189,"y":153},{"time":11617,"x":189,"y":162},{"time":11637,"x":193,"y":183},{"time":11658,"x":194,"y":189},{"time":11678,"x":194,"y":195},{"time":11698,"x":195,"y":197},{"time":11719,"x":195,"y":198},{"time":11740,"x":195,"y":199},{"time":11761,"x":195,"y":201},{"time":11786,"x":195,"y":203},{"time":11806,"x":195,"y":204},{"time":11827,"x":195,"y":207},{"time":11847,"x":196,"y":209},{"time":11868,"x":196,"y":210},{"time":11888,"x":196,"y":211},{"time":11909,"x":197,"y":214},{"time":11929,"x":197,"y":216},{"time":11952,"x":197,"y":217},{"time":11972,"x":197,"y":219},{"time":11994,"x":198,"y":220},{"time":12018,"x":198,"y":221},{"time":12039,"x":199,"y":222},{"time":12060,"x":200,"y":222},{"time":12087,"x":202,"y":223},{"time":12107,"x":207,"y":224},{"time":12126,"x":213,"y":225},{"time":12146,"x":217,"y":225},{"time":12167,"x":224,"y":226},{"time":12189,"x":230,"y":227},{"time":12209,"x":235,"y":227},{"time":12230,"x":239,"y":227},{"time":12252,"x":245,"y":227},{"time":12271,"x":248,"y":227},{"time":12291,"x":250,"y":227},{"time":12311,"x":252,"y":227},{"time":12332,"x":256,"y":227},{"time":12353,"x":263,"y":227},{"time":12373,"x":267,"y":227},{"time":12393,"x":270,"y":227},{"time":12413,"x":273,"y":227},{"time":12439,"x":275,"y":226},{"time":12460,"x":276,"y":226},{"time":12480,"x":278,"y":226},{"time":12521,"x":279,"y":226},{"time":12541,"x":280,"y":226},{"time":12561,"x":281,"y":226},{"time":12607,"x":282,"y":226},{"time":12628,"x":283,"y":226},{"time":12655,"x":284,"y":226},{"time":12675,"x":285,"y":225},{"time":12717,"x":286,"y":225},{"time":12737,"x":287,"y":225},{"time":12758,"x":288,"y":225},{"time":12841,"x":289,"y":224},{"time":12861,"x":290,"y":224},{"time":12925,"x":291,"y":223},{"time":12945,"x":291,"y":222},{"time":12965,"x":291,"y":219},{"time":12987,"x":292,"y":214},{"time":13006,"x":293,"y":211},{"time":13025,"x":293,"y":209},{"time":13046,"x":293,"y":207},{"time":13067,"x":293,"y":205},{"time":13087,"x":293,"y":204},{"time":13107,"x":293,"y":203},{"time":13127,"x":292,"y":201},{"time":13147,"x":292,"y":200},{"time":13169,"x":291,"y":198},{"time":13189,"x":290,"y":196},{"time":13209,"x":289,"y":193},{"time":13229,"x":288,"y":192},{"time":13254,"x":287,"y":190},{"time":13294,"x":286,"y":188},{"time":13316,"x":284,"y":185},{"time":13337,"x":283,"y":183},{"time":13358,"x":282,"y":182},{"time":13378,"x":281,"y":181},{"time":13398,"x":281,"y":180},{"time":13418,"x":280,"y":179},{"time":13438,"x":276,"y":175},{"time":13459,"x":273,"y":172},{"time":13479,"x":270,"y":169},{"time":13501,"x":266,"y":165},{"time":13521,"x":265,"y":164},{"time":13541,"x":262,"y":162},{"time":13562,"x":259,"y":160},{"time":13588,"x":252,"y":156},{"time":13609,"x":248,"y":153},{"time":13629,"x":244,"y":151},{"time":13651,"x":241,"y":150},{"time":13671,"x":237,"y":149},{"time":13691,"x":234,"y":148},{"time":13711,"x":227,"y":147},{"time":13732,"x":221,"y":146},{"time":13752,"x":217,"y":146},{"time":13772,"x":210,"y":146},{"time":13792,"x":207,"y":146},{"time":13813,"x":205,"y":146},{"time":13834,"x":200,"y":147},{"time":13855,"x":198,"y":148},{"time":13875,"x":195,"y":148},{"time":13896,"x":194,"y":148},{"time":13920,"x":193,"y":148},{"time":13941,"x":192,"y":148},{"time":13984,"x":191,"y":148},{"time":14004,"x":190,"y":149},{"time":14025,"x":189,"y":149},{"time":14064,"x":189,"y":150}],"id":0,"type":"draw","col":16777010,"time":11488,"fx":189,"fy":145},{"childlist":[{"time":15245,"x":77,"y":329},{"time":15265,"x":76,"y":329},{"time":15285,"x":74,"y":329},{"time":15305,"x":72,"y":329},{"time":15326,"x":70,"y":329},{"time":15346,"x":68,"y":329},{"time":15367,"x":65,"y":329},{"time":15387,"x":64,"y":329},{"time":15428,"x":63,"y":329},{"time":15453,"x":62,"y":329},{"time":15473,"x":60,"y":329},{"time":15519,"x":59,"y":329},{"time":15539,"x":58,"y":329},{"time":15560,"x":56,"y":329},{"time":15580,"x":54,"y":329},{"time":15621,"x":53,"y":329},{"time":15641,"x":52,"y":329},{"time":15661,"x":51,"y":329},{"time":15684,"x":50,"y":329},{"time":15705,"x":49,"y":329},{"time":15725,"x":48,"y":329},{"time":15745,"x":47,"y":329},{"time":15765,"x":45,"y":328},{"time":15806,"x":44,"y":328},{"time":15826,"x":43,"y":328},{"time":15846,"x":39,"y":327},{"time":15867,"x":38,"y":327},{"time":15888,"x":36,"y":327},{"time":15929,"x":35,"y":327},{"time":15951,"x":33,"y":326},{"time":15971,"x":30,"y":326},{"time":15991,"x":29,"y":326},{"time":16053,"x":28,"y":325},{"time":16073,"x":26,"y":324},{"time":16093,"x":24,"y":323},{"time":16113,"x":23,"y":322},{"time":16134,"x":22,"y":320},{"time":16155,"x":20,"y":317},{"time":16175,"x":19,"y":314},{"time":16195,"x":18,"y":312},{"time":16220,"x":18,"y":310},{"time":16240,"x":18,"y":306},{"time":16261,"x":17,"y":301},{"time":16284,"x":17,"y":299},{"time":16305,"x":16,"y":296},{"time":16326,"x":16,"y":295},{"time":16346,"x":16,"y":293},{"time":16367,"x":16,"y":291},{"time":16387,"x":16,"y":290},{"time":16407,"x":16,"y":287},{"time":16427,"x":16,"y":283},{"time":16447,"x":16,"y":281},{"time":16468,"x":16,"y":275},{"time":16488,"x":16,"y":272},{"time":16508,"x":15,"y":269},{"time":16529,"x":15,"y":268},{"time":16555,"x":15,"y":265},{"time":16575,"x":15,"y":264},{"time":16595,"x":15,"y":263},{"time":16624,"x":15,"y":261},{"time":16643,"x":15,"y":260},{"time":16686,"x":15,"y":259},{"time":16724,"x":15,"y":258},{"time":16744,"x":16,"y":257},{"time":16763,"x":16,"y":256},{"time":16805,"x":17,"y":255},{"time":16846,"x":17,"y":254},{"time":16867,"x":18,"y":254},{"time":16887,"x":18,"y":252},{"time":16907,"x":19,"y":252},{"time":16928,"x":20,"y":250},{"time":16971,"x":20,"y":249},{"time":17010,"x":21,"y":249},{"time":17029,"x":22,"y":247},{"time":17053,"x":25,"y":244},{"time":17072,"x":25,"y":243},{"time":17091,"x":26,"y":242},{"time":17112,"x":26,"y":241},{"time":17134,"x":27,"y":240},{"time":17154,"x":28,"y":239},{"time":17174,"x":28,"y":238},{"time":17194,"x":28,"y":237},{"time":17220,"x":29,"y":235},{"time":17241,"x":29,"y":233},{"time":17261,"x":30,"y":230},{"time":17284,"x":30,"y":228},{"time":17304,"x":31,"y":221},{"time":17324,"x":31,"y":219},{"time":17344,"x":31,"y":217},{"time":17365,"x":32,"y":213},{"time":17385,"x":32,"y":209},{"time":17405,"x":32,"y":206},{"time":17425,"x":32,"y":205},{"time":17445,"x":32,"y":203},{"time":17465,"x":33,"y":201},{"time":17485,"x":33,"y":199},{"time":17505,"x":33,"y":197},{"time":17525,"x":33,"y":195},{"time":17545,"x":33,"y":194},{"time":17565,"x":33,"y":193},{"time":17587,"x":33,"y":191},{"time":17607,"x":33,"y":189},{"time":17628,"x":33,"y":188},{"time":17651,"x":33,"y":187},{"time":17671,"x":33,"y":185},{"time":17691,"x":34,"y":184},{"time":17711,"x":34,"y":183},{"time":17732,"x":34,"y":181},{"time":17754,"x":34,"y":179},{"time":17774,"x":35,"y":177},{"time":17795,"x":36,"y":175},{"time":17821,"x":37,"y":171},{"time":17841,"x":39,"y":167},{"time":17861,"x":40,"y":166},{"time":17888,"x":44,"y":160},{"time":17908,"x":47,"y":156},{"time":17929,"x":47,"y":155},{"time":17956,"x":49,"y":153},{"time":17975,"x":50,"y":152},{"time":17994,"x":54,"y":148},{"time":18018,"x":57,"y":146},{"time":18037,"x":58,"y":144},{"time":18057,"x":59,"y":144},{"time":18076,"x":61,"y":142},{"time":18095,"x":62,"y":141},{"time":18119,"x":65,"y":139},{"time":18138,"x":66,"y":138},{"time":18158,"x":67,"y":137},{"time":18177,"x":69,"y":136},{"time":18197,"x":73,"y":133},{"time":18222,"x":75,"y":131},{"time":18242,"x":76,"y":131},{"time":18262,"x":76,"y":130},{"time":18288,"x":79,"y":129},{"time":18307,"x":81,"y":127},{"time":18326,"x":83,"y":126},{"time":18346,"x":84,"y":125},{"time":18388,"x":86,"y":123},{"time":18408,"x":88,"y":122},{"time":18429,"x":89,"y":122},{"time":18454,"x":90,"y":121},{"time":18495,"x":91,"y":121},{"time":18519,"x":93,"y":120},{"time":18539,"x":95,"y":119},{"time":18560,"x":101,"y":116},{"time":18580,"x":106,"y":113},{"time":18602,"x":107,"y":113},{"time":18623,"x":108,"y":113},{"time":18665,"x":109,"y":112},{"time":18687,"x":113,"y":110},{"time":18707,"x":124,"y":105},{"time":18728,"x":127,"y":103},{"time":18751,"x":128,"y":103},{"time":18771,"x":129,"y":103},{"time":18792,"x":130,"y":102},{"time":18812,"x":131,"y":102},{"time":18833,"x":135,"y":100},{"time":18854,"x":140,"y":99},{"time":18874,"x":145,"y":97},{"time":18894,"x":147,"y":97},{"time":18959,"x":148,"y":97},{"time":18978,"x":150,"y":96},{"time":18997,"x":153,"y":95},{"time":19018,"x":160,"y":93},{"time":19038,"x":163,"y":91},{"time":19058,"x":164,"y":91},{"time":19100,"x":165,"y":91},{"time":19121,"x":168,"y":90},{"time":19141,"x":173,"y":89},{"time":19161,"x":174,"y":89},{"time":19185,"x":176,"y":89},{"time":19205,"x":177,"y":89},{"time":19225,"x":179,"y":89},{"time":19265,"x":180,"y":89},{"time":19287,"x":181,"y":89},{"time":19307,"x":182,"y":89},{"time":19327,"x":189,"y":90},{"time":19347,"x":194,"y":90},{"time":19368,"x":198,"y":91},{"time":19388,"x":199,"y":91},{"time":19408,"x":201,"y":91},{"time":19428,"x":204,"y":92},{"time":19451,"x":206,"y":92},{"time":19471,"x":211,"y":93},{"time":19491,"x":214,"y":94},{"time":19511,"x":215,"y":94},{"time":19532,"x":217,"y":94},{"time":19554,"x":219,"y":95},{"time":19574,"x":224,"y":96},{"time":19594,"x":229,"y":97},{"time":19620,"x":234,"y":98},{"time":19640,"x":240,"y":98},{"time":19660,"x":244,"y":99},{"time":19687,"x":248,"y":100},{"time":19706,"x":250,"y":100},{"time":19725,"x":252,"y":100},{"time":19745,"x":253,"y":101},{"time":19765,"x":254,"y":101},{"time":19785,"x":256,"y":102},{"time":19806,"x":260,"y":103},{"time":19826,"x":263,"y":104},{"time":19846,"x":267,"y":105},{"time":19868,"x":269,"y":106},{"time":19888,"x":271,"y":107},{"time":19908,"x":275,"y":109},{"time":19928,"x":279,"y":111},{"time":19956,"x":286,"y":114},{"time":19975,"x":288,"y":115},{"time":19994,"x":292,"y":118},{"time":20022,"x":297,"y":121},{"time":20041,"x":301,"y":123},{"time":20060,"x":304,"y":126},{"time":20079,"x":306,"y":128},{"time":20101,"x":308,"y":130},{"time":20121,"x":309,"y":131},{"time":20141,"x":312,"y":134},{"time":20213,"x":319,"y":142},{"time":20233,"x":321,"y":145},{"time":20254,"x":323,"y":147},{"time":20272,"x":325,"y":151},{"time":20290,"x":327,"y":153},{"time":20309,"x":330,"y":156},{"time":20328,"x":332,"y":158},{"time":20346,"x":333,"y":160},{"time":20368,"x":334,"y":162},{"time":20390,"x":335,"y":163},{"time":20408,"x":336,"y":164},{"time":20427,"x":336,"y":165},{"time":20446,"x":337,"y":166},{"time":20467,"x":338,"y":168},{"time":20487,"x":338,"y":169},{"time":20506,"x":339,"y":171},{"time":20526,"x":339,"y":172},{"time":20545,"x":340,"y":173},{"time":20565,"x":340,"y":174},{"time":20587,"x":341,"y":176},{"time":20606,"x":341,"y":178},{"time":20626,"x":342,"y":179},{"time":20645,"x":342,"y":180},{"time":20664,"x":343,"y":181},{"time":20690,"x":344,"y":182},{"time":20709,"x":344,"y":183},{"time":20728,"x":345,"y":184},{"time":20776,"x":346,"y":186},{"time":20796,"x":348,"y":189},{"time":20819,"x":349,"y":191},{"time":20840,"x":350,"y":192},{"time":20860,"x":351,"y":193},{"time":20880,"x":353,"y":194},{"time":20902,"x":354,"y":195},{"time":20923,"x":357,"y":197},{"time":20943,"x":359,"y":198},{"time":20963,"x":360,"y":199},{"time":20989,"x":362,"y":201},{"time":21009,"x":364,"y":201},{"time":21029,"x":365,"y":202},{"time":21057,"x":366,"y":203},{"time":21076,"x":367,"y":203},{"time":21095,"x":368,"y":204},{"time":21120,"x":369,"y":204},{"time":21139,"x":370,"y":205},{"time":21158,"x":371,"y":205},{"time":21177,"x":372,"y":206},{"time":21197,"x":373,"y":207},{"time":21223,"x":374,"y":207},{"time":21242,"x":375,"y":208},{"time":21261,"x":376,"y":208},{"time":21289,"x":377,"y":209},{"time":21309,"x":378,"y":209},{"time":21329,"x":379,"y":210},{"time":21357,"x":380,"y":211},{"time":21376,"x":381,"y":211},{"time":21423,"x":382,"y":212},{"time":21442,"x":383,"y":212},{"time":21461,"x":384,"y":213},{"time":21487,"x":385,"y":213},{"time":21506,"x":386,"y":214},{"time":21530,"x":387,"y":214},{"time":21556,"x":388,"y":215},{"time":21574,"x":390,"y":215},{"time":21592,"x":390,"y":216},{"time":21611,"x":391,"y":216},{"time":21630,"x":392,"y":217},{"time":21654,"x":393,"y":217},{"time":21674,"x":395,"y":218},{"time":21694,"x":396,"y":219},{"time":21713,"x":398,"y":220},{"time":21734,"x":399,"y":221},{"time":21755,"x":401,"y":223},{"time":21774,"x":402,"y":224},{"time":21793,"x":405,"y":226},{"time":21812,"x":406,"y":227},{"time":21832,"x":407,"y":228},{"time":21854,"x":409,"y":229},{"time":21875,"x":410,"y":230},{"time":21894,"x":411,"y":231},{"time":21918,"x":412,"y":232},{"time":21938,"x":413,"y":233},{"time":21979,"x":414,"y":234},{"time":22001,"x":414,"y":235},{"time":22022,"x":415,"y":235},{"time":22042,"x":416,"y":237},{"time":22062,"x":416,"y":238},{"time":22089,"x":417,"y":239},{"time":22109,"x":418,"y":240},{"time":22129,"x":419,"y":241},{"time":22157,"x":420,"y":243},{"time":22177,"x":420,"y":244},{"time":22197,"x":421,"y":245},{"time":22220,"x":422,"y":245},{"time":22241,"x":423,"y":247},{"time":22280,"x":424,"y":249},{"time":22302,"x":425,"y":249},{"time":22323,"x":425,"y":250},{"time":22343,"x":426,"y":253},{"time":22363,"x":426,"y":254},{"time":22389,"x":427,"y":256},{"time":22408,"x":427,"y":257},{"time":22428,"x":427,"y":259},{"time":22447,"x":428,"y":261},{"time":22469,"x":428,"y":263},{"time":22489,"x":428,"y":264},{"time":22509,"x":428,"y":266},{"time":22529,"x":428,"y":268},{"time":22557,"x":429,"y":271},{"time":22576,"x":429,"y":272},{"time":22595,"x":429,"y":273},{"time":22620,"x":429,"y":274},{"time":22639,"x":429,"y":276},{"time":22659,"x":429,"y":278},{"time":22679,"x":429,"y":279},{"time":22701,"x":429,"y":281},{"time":22723,"x":429,"y":282},{"time":22743,"x":429,"y":283},{"time":22763,"x":429,"y":285},{"time":22790,"x":429,"y":286},{"time":22810,"x":429,"y":287},{"time":22831,"x":429,"y":288},{"time":22856,"x":428,"y":290},{"time":22875,"x":428,"y":291},{"time":22895,"x":428,"y":292},{"time":22920,"x":428,"y":293},{"time":22939,"x":427,"y":298},{"time":22959,"x":426,"y":301},{"time":22978,"x":425,"y":302},{"time":22997,"x":425,"y":304},{"time":23023,"x":424,"y":306},{"time":23043,"x":423,"y":307},{"time":23062,"x":423,"y":308},{"time":23087,"x":421,"y":312},{"time":23107,"x":419,"y":314},{"time":23126,"x":418,"y":315},{"time":23169,"x":416,"y":316},{"time":23190,"x":413,"y":318},{"time":23211,"x":411,"y":319},{"time":23230,"x":409,"y":320},{"time":23256,"x":404,"y":321},{"time":23276,"x":399,"y":323},{"time":23295,"x":395,"y":324},{"time":23330,"x":386,"y":327},{"time":23357,"x":384,"y":328},{"time":23375,"x":383,"y":328},{"time":23393,"x":382,"y":328},{"time":23411,"x":381,"y":329},{"time":23431,"x":380,"y":329},{"time":23459,"x":379,"y":329},{"time":23541,"x":378,"y":329},{"time":23561,"x":377,"y":329},{"time":23579,"x":375,"y":329},{"time":23602,"x":374,"y":329},{"time":23622,"x":373,"y":329},{"time":23641,"x":372,"y":329},{"time":23702,"x":370,"y":329},{"time":23722,"x":369,"y":329},{"time":23742,"x":362,"y":330},{"time":23761,"x":348,"y":332}],"id":0,"type":"draw","col":16777010,"time":15141,"fx":79,"fy":329},{"childlist":[{"time":24590,"x":236,"y":326},{"time":24610,"x":234,"y":326},{"time":24629,"x":231,"y":326},{"time":24655,"x":229,"y":326},{"time":24674,"x":228,"y":326},{"time":24693,"x":227,"y":327},{"time":24713,"x":225,"y":327},{"time":24733,"x":223,"y":327},{"time":24755,"x":221,"y":328},{"time":24775,"x":219,"y":329},{"time":24794,"x":216,"y":329},{"time":24813,"x":215,"y":330},{"time":24833,"x":213,"y":330},{"time":24853,"x":212,"y":330},{"time":24872,"x":210,"y":330},{"time":24892,"x":209,"y":330},{"time":24912,"x":207,"y":330},{"time":24932,"x":205,"y":330},{"time":24955,"x":202,"y":330},{"time":24975,"x":200,"y":330},{"time":24996,"x":197,"y":330},{"time":25018,"x":195,"y":330},{"time":25037,"x":193,"y":330},{"time":25058,"x":191,"y":330},{"time":25077,"x":190,"y":330},{"time":25096,"x":188,"y":330},{"time":25142,"x":187,"y":330},{"time":25209,"x":186,"y":330},{"time":25230,"x":185,"y":330},{"time":25257,"x":184,"y":330}],"id":0,"type":"draw","col":16777010,"time":24462,"fx":238,"fy":325},{"childlist":[{"time":27689,"x":424,"y":262},{"time":27709,"x":423,"y":262},{"time":27729,"x":422,"y":262},{"time":27757,"x":421,"y":263},{"time":27776,"x":418,"y":263},{"time":27796,"x":416,"y":264},{"time":27823,"x":413,"y":265},{"time":27842,"x":412,"y":265},{"time":27862,"x":410,"y":266},{"time":27887,"x":409,"y":266},{"time":27906,"x":407,"y":266},{"time":27925,"x":404,"y":266},{"time":27946,"x":401,"y":266},{"time":27968,"x":397,"y":266},{"time":27988,"x":394,"y":266},{"time":28007,"x":393,"y":266},{"time":28072,"x":389,"y":265},{"time":28090,"x":388,"y":265},{"time":28108,"x":387,"y":264},{"time":28125,"x":386,"y":264},{"time":28144,"x":385,"y":263},{"time":28162,"x":384,"y":263},{"time":28187,"x":383,"y":263},{"time":28205,"x":382,"y":263},{"time":28223,"x":381,"y":263},{"time":28242,"x":380,"y":263},{"time":28286,"x":379,"y":264},{"time":28306,"x":378,"y":265},{"time":28325,"x":378,"y":266},{"time":28345,"x":378,"y":267},{"time":28364,"x":378,"y":268},{"time":28389,"x":378,"y":270},{"time":28408,"x":378,"y":271},{"time":28428,"x":378,"y":275},{"time":28447,"x":378,"y":276},{"time":28469,"x":378,"y":277},{"time":28492,"x":378,"y":278},{"time":28511,"x":378,"y":279},{"time":28530,"x":379,"y":280},{"time":28557,"x":379,"y":281},{"time":28596,"x":379,"y":283},{"time":28623,"x":379,"y":284},{"time":28644,"x":379,"y":286},{"time":28665,"x":380,"y":287},{"time":28691,"x":380,"y":289},{"time":28730,"x":381,"y":290},{"time":28760,"x":381,"y":291},{"time":28800,"x":382,"y":292},{"time":28840,"x":384,"y":293},{"time":28860,"x":385,"y":293},{"time":28880,"x":389,"y":294},{"time":28902,"x":391,"y":295},{"time":28921,"x":393,"y":295},{"time":28941,"x":394,"y":295},{"time":28960,"x":395,"y":295},{"time":28979,"x":396,"y":295},{"time":29001,"x":398,"y":296},{"time":29021,"x":399,"y":296},{"time":29041,"x":401,"y":296},{"time":29061,"x":402,"y":296},{"time":29080,"x":403,"y":296},{"time":29102,"x":405,"y":296},{"time":29125,"x":406,"y":296},{"time":29146,"x":407,"y":296},{"time":29169,"x":408,"y":296},{"time":29190,"x":409,"y":296},{"time":29231,"x":410,"y":296},{"time":29255,"x":411,"y":296},{"time":29275,"x":412,"y":296},{"time":29321,"x":413,"y":296},{"time":29341,"x":414,"y":296},{"time":29361,"x":415,"y":296},{"time":29387,"x":416,"y":296},{"time":29408,"x":417,"y":296},{"time":29454,"x":418,"y":296},{"time":29474,"x":419,"y":296},{"time":29518,"x":420,"y":296},{"time":29537,"x":421,"y":296},{"time":29558,"x":422,"y":295},{"time":29578,"x":423,"y":295},{"time":29618,"x":424,"y":295},{"time":29637,"x":425,"y":295},{"time":29659,"x":427,"y":294},{"time":29678,"x":428,"y":294},{"time":29697,"x":430,"y":294},{"time":29724,"x":431,"y":294},{"time":29809,"x":431,"y":293},{"time":29831,"x":431,"y":291}],"id":0,"type":"draw","col":16777010,"time":27582,"fx":425,"fy":262},{"childlist":[{"time":30362,"x":393,"y":269},{"time":30392,"x":394,"y":277},{"time":30411,"x":394,"y":283},{"time":30430,"x":395,"y":288},{"time":30457,"x":395,"y":291},{"time":30477,"x":395,"y":293},{"time":30496,"x":395,"y":294},{"time":30523,"x":395,"y":295}],"id":0,"type":"draw","col":16777010,"time":30290,"fx":393,"fy":268},{"childlist":[{"time":31155,"x":406,"y":276},{"time":31175,"x":406,"y":281},{"time":31196,"x":407,"y":289},{"time":31218,"x":407,"y":294},{"time":31239,"x":407,"y":296},{"time":31261,"x":407,"y":297},{"time":31389,"x":407,"y":295}],"id":0,"type":"draw","col":16777010,"time":31026,"fx":406,"fy":271},{"childlist":[{"time":31855,"x":417,"y":270},{"time":31875,"x":417,"y":272},{"time":31895,"x":418,"y":278},{"time":31918,"x":419,"y":286},{"time":31939,"x":420,"y":292},{"time":31958,"x":420,"y":294},{"time":31979,"x":420,"y":295},{"time":32002,"x":420,"y":296}],"id":0,"type":"draw","col":16777010,"time":31757,"fx":416,"fy":269},{"childlist":[{"time":33098,"x":19,"y":277},{"time":33123,"x":21,"y":277},{"time":33143,"x":27,"y":277},{"time":33162,"x":30,"y":277},{"time":33190,"x":34,"y":277},{"time":33210,"x":36,"y":276},{"time":33229,"x":37,"y":276},{"time":33257,"x":38,"y":276},{"time":33277,"x":40,"y":276},{"time":33296,"x":41,"y":275},{"time":33323,"x":43,"y":275},{"time":33388,"x":44,"y":275},{"time":33407,"x":46,"y":276},{"time":33427,"x":49,"y":278},{"time":33446,"x":49,"y":279},{"time":33469,"x":50,"y":280},{"time":33488,"x":50,"y":281},{"time":33508,"x":51,"y":283},{"time":33528,"x":51,"y":284},{"time":33558,"x":51,"y":286},{"time":33577,"x":51,"y":287},{"time":33597,"x":52,"y":288},{"time":33629,"x":52,"y":289},{"time":33647,"x":52,"y":290},{"time":33688,"x":52,"y":291},{"time":33708,"x":52,"y":292},{"time":33760,"x":52,"y":293},{"time":33779,"x":52,"y":294},{"time":33801,"x":53,"y":295},{"time":33823,"x":53,"y":296},{"time":33844,"x":53,"y":297},{"time":33863,"x":53,"y":298},{"time":33909,"x":53,"y":299},{"time":33957,"x":53,"y":300},{"time":33978,"x":53,"y":301},{"time":34041,"x":53,"y":302},{"time":34139,"x":52,"y":303},{"time":34159,"x":52,"y":304},{"time":34179,"x":52,"y":305},{"time":34222,"x":51,"y":305},{"time":34262,"x":50,"y":306},{"time":34288,"x":49,"y":306},{"time":34308,"x":48,"y":307},{"time":34330,"x":47,"y":307},{"time":34355,"x":46,"y":308},{"time":34375,"x":45,"y":308},{"time":34395,"x":44,"y":308},{"time":34474,"x":42,"y":308},{"time":34494,"x":41,"y":308},{"time":34532,"x":40,"y":308},{"time":34554,"x":38,"y":309},{"time":34573,"x":37,"y":309},{"time":34593,"x":36,"y":310},{"time":34613,"x":35,"y":310},{"time":34635,"x":34,"y":310},{"time":34655,"x":33,"y":310},{"time":34694,"x":31,"y":310},{"time":34737,"x":30,"y":310},{"time":34757,"x":29,"y":310},{"time":34777,"x":28,"y":310},{"time":34820,"x":27,"y":310},{"time":34860,"x":26,"y":310},{"time":34880,"x":25,"y":310},{"time":34901,"x":24,"y":310},{"time":34940,"x":23,"y":310},{"time":34979,"x":22,"y":310},{"time":35021,"x":21,"y":310},{"time":35086,"x":21,"y":308}],"id":0,"type":"draw","col":16777010,"time":33024,"fx":18,"fy":277},{"childlist":[{"time":35676,"x":27,"y":277},{"time":35739,"x":27,"y":278},{"time":35760,"x":28,"y":283},{"time":35788,"x":30,"y":292},{"time":35809,"x":30,"y":296},{"time":35830,"x":31,"y":300},{"time":35854,"x":32,"y":302},{"time":35874,"x":32,"y":303},{"time":35894,"x":32,"y":304},{"time":35927,"x":33,"y":306},{"time":35968,"x":34,"y":307},{"time":36047,"x":34,"y":308},{"time":36068,"x":34,"y":309}],"id":0,"type":"draw","col":16777010,"time":35661,"fx":28,"fy":277},{"childlist":[{"time":36804,"x":39,"y":283},{"time":36824,"x":39,"y":285},{"time":36844,"x":40,"y":289},{"time":36864,"x":40,"y":292},{"time":36892,"x":41,"y":295},{"time":36912,"x":41,"y":297},{"time":36933,"x":41,"y":298},{"time":36975,"x":41,"y":299},{"time":36995,"x":41,"y":300},{"time":37021,"x":42,"y":301},{"time":37041,"x":42,"y":302},{"time":37080,"x":42,"y":303},{"time":37121,"x":42,"y":304},{"time":37192,"x":42,"y":305},{"time":37258,"x":42,"y":306}],"id":0,"type":"draw","col":16777010,"time":36669,"fx":39,"fy":280}]';

			var comList:Array = JSON.decode(comListString);
			
			_player.setCommandList(comList);
			musicStart();
			_ch.stop();
		}
		
		private function musicStart():void {
			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars.mp3"), new SoundLoaderContext(10000, true));
//			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars_long.mp3"), new SoundLoaderContext(10000, true));
			_ch = sound.play();
			bA = new ByteArray();
			//			stage.quality = StageQuality.LOW;
			stage.fullScreenSourceRect=new Rectangle(0,0,465,465); 
			addEventListener(Event.ENTER_FRAME, updateSpectrum);
			
			//timer start
			_startTime = getTimer();
			
			/**
			 * action setup
			 */
			_field.addEventListener(MouseEvent.MOUSE_DOWN, _fieldDownHandler);
			_field.addEventListener(MouseEvent.MOUSE_UP, _fieldUpHandler);
			_field.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			
			//Play Draw
			_player.addEventListener(DrawPlayer.DO_ROOT, _rootEventHandler);
			_player.addEventListener(DrawPlayer.DO_NODE, _nodeEventHandler);
			_player.addEventListener(DrawPlayer.DO_CLEAR, _clearEventHandler);
		}
		
		public function setupDisplay():void {
			addChild(_paintField);
			addChild(_field);
			addChild(_clearEffBmp);
			addChild(_uiField);
			addChild(_stopUiField);
			addChild(_startField);
			_uiField.addChild(_colSelector);
			_colSelector.x = 20;
			_colSelector.y = 85;
			_stopUiField.visible = true;
			_uiField.visible = false;
			_startField.visible = false;
		}
		/**
		 * mouse Action
		 */
		private function _fieldDownHandler(event:MouseEvent):void {
			addRoot();
			_col = _colSelector.currentColor;
			_field.addEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
			var currentTime:int = getTimer() - _startTime;
			var id:int=0;
			_rec.startLineRec(id,mouseX,mouseY,_colSelector.currentColor,currentTime);
		}
		private function _fieldUpHandler(event:MouseEvent):void {
			//今書いたものにベクトル情報追加
			_field.removeEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
		}
		private function _fieldMoveHandler(event:MouseEvent):void {
			addNode(_field.mouseX, _field.mouseY);
			//rec
			var currentTime:int = getTimer() - _startTime;
			_rec.addPoint(_field.mouseX, _field.mouseY, currentTime);
		}
		/**
		 * play Action
		 */
		private function _rootEventHandler(event:Event):void {
			addRoot();
			_col = _player.cur_Col;
		}
		private function _nodeEventHandler(event:Event):void {
			addNode(_player.cur_x, _player.cur_y);	
		}
		private function _clearEventHandler(event:Event):void {
			clear();
		}
		/**
		 * node Action
		 */
		private function addRoot():void {
			trace("adRoot");
			_currentListIndex = _pointListList.length;
			_pointListList.push(new Array());
		}
		private function addNode(px:Number, py:Number):void {
			trace("addNode");
			var _list:Array = _pointListList[_currentListIndex];
			_list.push(new LinePoint(px, py));
			var i:int = _list.length-1;
			_list[i].color = _col;
			if(_list[i-1]) {
				var _pt:LinePoint = _list[i];
				var _dx:Number = _list[i].x - _list[i-1].x;
				var _dy:Number = _list[i].y - _list[i-1].y;
				var _distance:Number = Math.sqrt(_dx*_dx+_dy*_dy);
				_pt.vx = _list[i].x - _list[i-1].x;
				_pt.vy = _list[i].y - _list[i-1].y;
				//				_pt.vx = _dx/_distance;
				//				_pt.vy = _dy/_distance;
				_pt.genRotation();
			}
		}
		private function _enterFrameHandler(event:Event):void {
			var i:int;
			var len:int = _pointListList.length;
			_paintField.graphics.clear();
			_paintField.graphics.lineStyle(1,0xFFFFFF);
			var _list:Array;
			var j:int;
			var _listlen:int;
			var nx:Number;
			var ny:Number;
			var dist:Number;
			if(_actionFlg) {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.lineStyle(1,_list[0].color);
						_paintField.graphics.moveTo(_list[0].x, _list[0].y);
						//スペクトラムずらす
						for(j=_listlen-1;j>0;j--) {
							_list[j].spectrum = _list[j-1].spectrum;
						}
						_list[0].spectrum = spectrum[10];
						for(j=0;j<_listlen;j++) {
							//							_paintField.graphics.moveTo(_list[j].x, _list[j].y);
							if(_list[j].r){
								nx = -(_list[j].vy);
								ny = _list[j].vx;
								dist = Math.sqrt(nx*nx+ny*ny);
								//							    _list[j].spectrum = spectrum[j];//スペクトラム直でまっぴんぐ
								_paintField.graphics.lineTo(_list[j].x+nx*_list[j].spectrum*7, _list[j].y+ny*_list[j].spectrum*7);
								//							    _paintField.graphics.lineTo(_list[j].x+_list[j].spectrum*2*nx/dist, _list[j].y+40*_list[j].spectrum*2*ny/dist);
							}
						}
					}
				}
			} else {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.moveTo(_list[0].x, _list[0].y); 
						for(j=0;j<_listlen;j++) {
							_paintField.graphics.lineTo(_list[j].x, _list[j].y);
						}
					}
				}
			}
		}
		
		private function updateSpectrum(e:Event):void {
			SoundMixer.computeSpectrum(bA,false,0);
			spectrum = [];
			var i:int;
			for(i=0; i<256; i++){
				spectrum[i] = bA.readFloat();
			}
			for(i=256; i<512; i++){
				spectrum[i] = bA.readFloat();
			}
			bA.position=0;
			lowVal = spectrum[0];
			middleVal = spectrum[1];
			highVal = spectrum[2];
		} 
		
		/**
		 * ui Action
		 */
		private function startHandler(event:MouseEvent):void {
			_startField.visible = false;
			_uiField.visible = true;
			musicStart();
		}
		private function actionHandler(event:MouseEvent):void {
			_actionFlg = true;
		}
		private function noActionHandler(event:MouseEvent):void {
			_actionFlg = false;
		}
		private function clearHandler(event:MouseEvent):void {
			_rec.addClear(getTimer()-_startTime)
			clear();
		}
		private function plotHandler(event:MouseEvent):void {
			_rec.outPut();
		}
		private function stopHandler(event:MouseEvent):void {
			_ch.stop();
			clear();
			_player.setCommandList(_rec.commandList);
			Tweener.addTween(_uiField, {_autoAlpha:0, time:0.5, transition:Equations.easeOutQuint});
			Tweener.addTween(_stopUiField, {_autoAlpha:1, time:0.5, transition:Equations.easeOutQuint});
		}
		private function playDataHandler(event:MouseEvent):void {
			_ch = sound.play(0);
			_player.playStart();
		}
		private function stopDrawHandler(event:MouseEvent):void {
			clear();
			_currentListIndex = 0;
			_ch.stop();
			_player.playStop();
		}
		public var clearCnt:Number = 0;
		private function clear():void {
			_clearBmd.fillRect(new Rectangle(0,0,465,465),0);
			_clearBmd.draw(_paintField);
			_clearEffBmp.visible = true;
			_clearEffBmp.alpha = 1;
			_clearEffBmp.scaleX = _clearEffBmp.scaleY = 1;
			Tweener.addTween(_clearEffBmp, {/*scaleX:2, scaleY:2, */_autoAlpha:0, time:1, transition:Equations.easeOutQuint});
			clearComp();
			//			var i:int;
			//			var len:int = _pointListList.length;
			//			var _list:Array;
			//			var _listlen:int;
			//			var j:int;
			//			var nx:int, ny:int;
			//			for(i=0; i<len; i++) {
			//				_list = _pointListList[i];
			//				_listlen = _list.length;
			//				for(j=0;j<_listlen;j++) {
			//					_list[j].endAction();
			//				}
			//			}
			//			Tweener.addTween(this, {clearCnt:10, time:0.8, transition:Equations.easeOutQuint, onComplete:clearComp});
		}
		private function clearComp():void {
			var i:int;
			var len:int = _pointListList.length;
			var _list:Array;
			var _listlen:int;
			var j:int;
			var nx:int, ny:int;
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_listlen = _list.length;
				for(j=0;j<_listlen;j++) {
					_list[j] = null;
				}
			}
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_list.length = 0;
				_list = null;
			}
			_pointListList.length = 0;
			_pointListList = new Array();
		}
	}
}
import caurina.transitions.Equations;
import caurina.transitions.Tweener;

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.external.ExternalInterface;
import flash.geom.Point;
import flash.utils.Timer;
import flash.utils.getTimer;

import org.osmf.events.TimeEvent;



class LinePoint extends Point {
	public var vx:Number, vy:Number, r:Number;
	public var spectrum:Number = 0;
	public var color:Number;
	public function LinePoint(x:Number=0, y:Number=0) {
		super(x,y);
	}
	public function genRotation():void {
		r = Math.atan2(vy, vx);
	}
	public function endAction():void {
		var _targetSp:Number = spectrum * 20;
		Tweener.addTween(this, {spectrum:_targetSp, time:0.5, transition:Equations.easeOutQuint});
	}
}

class ColorSelector extends Sprite {
	public var colorList:Array = new Array();
	public var currentColor:Number = 0xFFFF32;
	private var _colTotal:int = 5;
	private var _selectedColor:Sprite = new Sprite();
	
	public function ColorSelector() {
		init();
		setupDisplay();
	}
	public function init():void {
		var i:int;
		for(i=0; i<_colTotal; i++) {
			var block:Sprite = new Sprite();
			//			block.name = String(0xFF0000*Math.random());
			block.addEventListener(MouseEvent.CLICK, selectedHandler);
			colorList.push(block);
		}
		colorList[0].name = String(0xFFFF32);
		colorList[1].name = String(0xFFFF99);
		        colorList[2].name = String(0xFFFFCD);
		        colorList[3].name = String(0xFFCC32);
		        colorList[4].name = String(0xFFCC00);
		for(i=0; i<_colTotal; i++) {
			colorList[i].graphics.clear();
			colorList[i].graphics.beginFill(Number(colorList[i].name));
			colorList[i].graphics.drawRect(0,0,10,10);
			colorList[i].graphics.endFill();
		}
		
		currentColor = Number(colorList[0].name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
		
	}
	public function setupDisplay():void {
		addChild(_selectedColor);
		for(var i:int=0; i<_colTotal; i++) {
			addChild(colorList[i]);
			colorList[i].x = i*(colorList[i].width+1);
			colorList[i].y = 20;
		}
	}
	private function selectedHandler(event:MouseEvent):void {
		_selectedColor.graphics.clear();
		currentColor = Number(event.target.name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
	}
}

class DrawPlayer extends Sprite {
	
	public static const DO_ROOT:String = "DoRoot";
	public static const DO_NODE:String = "DoNode";
	public static const DO_CLEAR:String = "DoClear";
	private var _commandList:Array;
	private var _timer:Timer = new Timer(1);
	private var _rootIndex:int = 0;
	private var _nodeIndex:int = 0;
	private var _counter:int = 0;
	private var _watchTarget:int = 0; //0:親, 1:子
	
	//現在の命令
	public var cur_Command:int = 0; //0:親, 1:子
	public var cur_Col:Number;
	public var cur_x:Number;
	public var cur_y:Number;
	
	//timer
	private var _startTime:Number;
	
	public function DrawPlayer() {
		super();
	}
	
	public function setCommandList(list:Array):void {
		_commandList = list;
	}
	
	public function playStart():void {
		_counter = 0;
		_rootIndex = 0;
		_nodeIndex = 0;
		_watchTarget = 0;
		_startTime = getTimer();
		addEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	public function playStop():void {
		removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	
	private function _commandCheckHandler(event:Event):void {
		_counter = getTimer()-_startTime;
		//まだ終わってなかったら終わる
		if(_rootIndex == _commandList.length) {
			if(hasEventListener(Event.ENTER_FRAME))removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
			return;
		}
		if(_watchTarget==0) {
			if(_commandList[_rootIndex].time<=_counter) {
				switch(_commandList[_rootIndex].type) {
					case "clear":
						_watchTarget = 0;
						dispatchEvent(new Event(DO_CLEAR));
						_rootIndex++;
						break;
					case "draw":
						cur_Col = _commandList[_rootIndex].col;
						cur_x = _commandList[_rootIndex].fx;
						cur_y = _commandList[_rootIndex].fy;
						dispatchEvent(new Event(DO_ROOT));
						_watchTarget = 1;
						break;
				}
			}
		} else {
			var obj:Object = _commandList[_rootIndex][_nodeIndex];
			//マウス動かなかった時は親にそのまま向ける
			if(!_commandList[_rootIndex].childlist[_nodeIndex]){
				_rootIndex++;
				_nodeIndex=0;
				_watchTarget=0;
				return;
			}
			if(_commandList[_rootIndex].childlist[_nodeIndex].time<=_counter) {
				cur_x = _commandList[_rootIndex].childlist[_nodeIndex].x;
				cur_y = _commandList[_rootIndex].childlist[_nodeIndex].y;
				dispatchEvent(new Event(DO_NODE));
				_nodeIndex++;
				//最後尾到達で親監視に切り替え
				if(_nodeIndex==_commandList[_rootIndex].length-1) {
					//親も最後尾なら終了
					if(_rootIndex==_commandList.length-1) {
						_timer.removeEventListener(TimerEvent.TIMER, _commandCheckHandler);
						_timer.stop();
						return;
					} else {
						_watchTarget = 0;
						_rootIndex++;
					}
				}
			}
			
		}
	}
	
	private function _commandCheck():void{
		
	}
	
}

class DrawRecoder extends Sprite {
	private var _commandList:Array = new Array();
	public function get commandList():Array {
		return _commandList;
	}
	public function DrawRecoder() {
		
	}
	
	public function startLineRec(_id:int,_mx:Number,_my:Number,_col:Number, _time:Number):void {
		_commandList.push({type:"draw", id:_id,fx:_mx, fy:_my, col:_col, time:_time, childlist:new Array()});
	}
	public function addPoint(_mx:Number, _my:Number, _time:Number):void {
		var _currentList:Array = _commandList[_commandList.length-1].childlist;
		_currentList.push({x:_mx, y:_my, time:_time});
	}
	public function addClear(_time:Number):void {
		_commandList.push({type:"clear", time:_time});
	}
	public function endLineRec():void {
		
	}
	
	public function outPut():void {
		var i:int;
		var j:int;
	}
}