/**
 * Copyright Dorara ( http://wonderfl.net/user/Dorara )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e9Xo
 */

// 三つ葉のクローバー
//   葉っぱを作りたかったので作った．
//   幸せになりたああああああああああああああああい
//     (myLineクラスで曲線を作成)
//     (LeafクラスはmyLineを組み合わせて葉っぱを作成)
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;

    [SWF(width="465", height="465",backgroundColor=0x00000000,frameRate=60)]
    public class happa extends Sprite
    {
        public var sp:Sprite;
        public var ml:Leaf, ml1:Leaf, ml2:Leaf;
        public var eda:myLine;
        public var etime:int = 170; //葉っぱの長さ
        
        public function happa()
        {
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.stage.align = StageAlign.TOP_LEFT;
            
            sp = new Sprite();
            this.addChild(sp);
            sp.filters = [new GlowFilter(0x00ff00, 1, 16, 16, 3, 2), new BlurFilter(1, 1, 1)];
            
            //葉っぱの大きさを毎回変える
            etime = 80 + 90 * Math.random();
            
            //葉っぱ3枚
            ml = new Leaf();
            ml.vx = 1;
            ml.vy = 1;
            ml.etime = etime;
            ml.init();
            
            ml1 = new Leaf();
            ml1.vx = -1;
            ml1.vy = -1;
            ml1.etime = etime;
            ml1.init();
            
            ml2 = new Leaf();
            ml2.vx = 1;
            ml2.vy = -1;
            ml2.etime = etime;
            ml2.init();

            //枝
            eda = new myLine();
            eda.px = 233.0;
            eda.py = 233.0;
            eda.vx = -1;
            eda.vy = 1;
            eda.etime = 80;
            eda.thick = 4;
            eda.init();
                        
            this.addEventListener(Event.ENTER_FRAME, onEnterframe);
        }
        public function onEnterframe(e:Event):void
        {
            var i:int;
            if(!eda.isEnd){
                sp.graphics.lineStyle(eda.thick, 0x00cc00, 1.0);
                sp.graphics.moveTo(eda.nx, eda.ny);
                sp.graphics.lineTo(eda.mx, eda.my);        
                eda.timeNext();
            }
            
            if(!ml.isEnd){
                //主軸の描画
                sp.graphics.lineStyle(ml.mainB.thick, 0x00cc00, 1.0);
                sp.graphics.moveTo(ml.mainB.nx, ml.mainB.ny);
                sp.graphics.lineTo(ml.mainB.mx, ml.mainB.my);
            
                //枝の描画
                for(i = 0; i<ml.array.length; i++)
                {
                    sp.graphics.lineStyle(ml.array[i].thick, 0x00cc00, 1.0);
                    sp.graphics.moveTo(ml.array[i].nx, ml.array[i].ny);
                    sp.graphics.lineTo(ml.array[i].mx, ml.array[i].my);
                }
            
                ml.timeNext();
            }
            
            if(!ml1.isEnd){
                //主軸の描画
                sp.graphics.lineStyle(ml1.mainB.thick, 0x00cc00, 1.0);
                sp.graphics.moveTo(ml1.mainB.nx, ml1.mainB.ny);
                sp.graphics.lineTo(ml1.mainB.mx, ml1.mainB.my);
            
                //枝の描画
                for(i = 0; i<ml1.array.length; i++)
                {
                    sp.graphics.lineStyle(ml1.array[i].thick, 0x00cc00, 1.0);
                    sp.graphics.moveTo(ml1.array[i].nx, ml1.array[i].ny);
                    sp.graphics.lineTo(ml1.array[i].mx, ml1.array[i].my);
                }
            
                ml1.timeNext();
            }
            if(!ml2.isEnd){
                //主軸の描画
                sp.graphics.lineStyle(ml2.mainB.thick, 0x00cc00, 1.0);
                sp.graphics.moveTo(ml2.mainB.nx, ml2.mainB.ny);
                sp.graphics.lineTo(ml2.mainB.mx, ml2.mainB.my);
            
                //枝の描画
                for(i = 0; i<ml2.array.length; i++)
                {
                    sp.graphics.lineStyle(ml2.array[i].thick, 0x00cc00, 1.0);
                    sp.graphics.moveTo(ml2.array[i].nx, ml2.array[i].ny);
                    sp.graphics.lineTo(ml2.array[i].mx, ml2.array[i].my);
                }
            
                ml2.timeNext();
            }
        }
    }
}

//葉っぱクラス
class Leaf{
    public var array:Array; //主軸からの枝
    public var px:Number, py:Number, vx:Number, vy:Number;
    public var mainB:myLine; //葉っぱの主軸
    public var tBrunch:int; //枝を何stepごとに生やすか
    public var time:int; //現在時刻
    public var isEnd:Boolean; //終了しているかどうか
    public var eth:Number = 1.30; //どの程度枝を傾けて生やすか(radian)
    public var etime:int = 100; //葉っぱの長さを調整
    
    public function Leaf()
    {
        mainB = new myLine();
        px = 233.0;
        py = 233.0;
        vx = 1.0;// + 2*Math.random();
        vy = 1.0;// + 2*Math.random();
        tBrunch = 6;
        array = new Array();
    }
    public function init():void
    {
        mainB.px = px;
        mainB.py = py;
        mainB.vx = vx;
        mainB.vy = vy;
        mainB.etime = etime;
        time = 0;
        isEnd = false;
        mainB.init();
    }
    public function timeNext():void
    {
        isEnd = true;
        if(!mainB.isEnd){
            mainB.timeNext();
            isEnd = false;
        }
        
        for(var i:int = 0; i<array.length; i++)
        {
            if(!array[i].isEnd){
                array[i].timeNext(); //すべての枝の更新
                isEnd = false;
            }
        }
        
        if(time%tBrunch == 0 && !mainB.isEnd){//新しい枝を増やす
            var ln:Number = Math.sqrt(mainB.wx*mainB.wx+mainB.wy*mainB.wy), ang:Number = Math.atan2(mainB.wy, mainB.wx);
            var tmp1:myLine = new myLine();
            tmp1.px = mainB.nx;
            tmp1.py = mainB.ny;
            tmp1.vx = ln * Math.cos(ang + eth);
            tmp1.vy = ln * Math.sin(ang + eth);
            //tmp1.etime = mainB.etime - mainB.time;
            tmp1.etime = (int)(35 * Math.sin(mainB.time * Math.PI / mainB.etime)); //右側
            trace(tmp1.etime);
            tmp1.init();
            array.push(tmp1);
            
            
            var tmp2:myLine = new myLine();
            tmp2.px = mainB.nx;
            tmp2.py = mainB.ny;
            tmp2.vx = ln * Math.cos(ang - eth);
            tmp2.vy = ln * Math.sin(ang - eth);
            //tmp2.etime = mainB.etime - mainB.time;
            tmp2.etime = (int)(35 * Math.sin(mainB.time * Math.PI / mainB.etime)); //左側
            tmp2.eth = -tmp2.eth;
            tmp2.init();
            array.push(tmp2);
            
            isEnd = false;
        }
        time++;
    }
}

//曲線描写クラス
//   毎時刻(nx,ny)から(mx,my)へ線をひく
class myLine{
    // 初期値として変更すべき変数は
    //   px,py,vx,vy,etime,thick,eth
    public var px:Number, py:Number, vx:Number, vy:Number; //軸のスタート位置と方向ベクトル
    public var nx:Number, ny:Number, mx:Number, my:Number; //現在時刻での線
    public var wx:Number, wy:Number; //現在時刻での方向ベクトル
    public var time:int, etime:int; //現在時間と終了時間
    public var thick:Number; //線の太さ
    public var eth:Number; //ちょっと傾けるための角度誤差
    public var isEnd:Boolean; //終わっているかどうか

    public function myLine(){
        px = 100.0;
        py = 100.0;
        vx = 1.0;
        vy = -1.0;
        etime = 100;
        thick = 2.0;
        eth = 0.005;
    }
    public function init():void
    {
        nx = px;
        ny = py;
        mx = px + vx;
        my = py + vy;
        wx = vx;
        wy = vy;
        time = 1;
        isEnd = false;
    }
    //時刻の更新
    public function timeNext():void
    {
        if(time < etime){
            nx = mx;
            ny = my;
            var ln:Number = Math.sqrt(wx*wx+wy*wy), ang:Number = Math.atan2(wy, wx);
            wx = ln * Math.cos(ang+eth);
            wy = ln * Math.sin(ang+eth);
            mx = nx + wx;
            my = ny + wy;
            //if(thick>0.2) thick -= 0.05;
            //else thick = 0.0;
            time++;
        }else{
            isEnd = true;
        }
    }
}