/**
 * Copyright George.Profenza ( http://wonderfl.net/user/George.Profenza )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e9LI
 */

package {
    import flash.net.FileReference;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.utils.ByteArray;
    import org.papervision3d.core.io.exporters.ExportCollada;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.PaperPlane;
    import org.papervision3d.objects.special.UCS;

    public class PV3DExportTest extends BasicView {
        private var mesh:DisplayObject3D;
        public function PV3DExportTest()  {
            super(640,480,false,false,"Debug");
            scene.addChild(new UCS(1000));
            var light:PointLight3D = scene.addChild(new PointLight3D()) as PointLight3D; light.x = light.y = light.z = 100;
            mesh = scene.addChild(new PaperPlane(new FlatShadeMaterial(light,0xFFFF00,0xFF6600),3));mesh.rotationY = 160;mesh.rotationX = 30;
            startRendering();
            stage.doubleClickEnabled = true;
            stage.addEventListener(MouseEvent.DOUBLE_CLICK,save);
        }
        private function save(event:MouseEvent):void{
            var data:ByteArray = new ByteArray();
            data.writeUTFBytes(ExportCollada.export(mesh));
            new FileReference().save(data,'mesh.dae');
        }
    }
}