/**
 * Copyright greentec ( http://wonderfl.net/user/greentec )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e9JN
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import com.bit101.components.CheckBox;
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;

    public class FlashTest extends Sprite {
        
        public var energy:BitmapData;
        
        public var _width:int = 265;
        public var _height:int = 265;
        
        public var fireArray:Vector.<Vector.<int>> = new Vector.<Vector.<int>>(_width);
        public var fireArrayCopy:Vector.<Vector.<int>> = new Vector.<Vector.<int>>(_width);

        public var fuel:int = 10;
        public var cooling:int = 1;
        
        public var startArray:Vector.<int> = new Vector.<int>(_width);
        public var isRandom:Boolean = true;

        public function FlashTest() {
            // write as3 code here..
            addChild(new Bitmap(new BitmapData(465, 465, false, 0x0)));
            
            energy = new BitmapData(_width, _height, false, 0x0);
            var bit:Bitmap = new Bitmap(energy);
            bit.x = 100;
            bit.y = 100;
            addChild(bit);
            
            
            //initialize fire array
            var i:int;
            var j:int;
            
            for (i = 0; i < _width; i += 1)
            {
                fireArray[i] = new Vector.<int>(height);
                fireArrayCopy[i] = new Vector.<int>(height);
                
                for (j = 0; j < _height; j += 1)
                {
                    fireArray[i][j] = 0;
                    fireArrayCopy[i][j] = 0;
                }
            }
            
            for (i = 0; i < _width; i += 1)
            {
                startArray[i] = Math.random() * 255;
            }
            
            var fuelSlider:HSlider = new HSlider(this, 100, 380, function(e:Event):void {
                fuel = e.target.value;
            });
            fuelSlider.maximum = 255;
            fuelSlider.minimum = 0;
            fuelSlider.width = 265;
            fuelSlider.height *= 1.5;
            fuelSlider.value = fuel;
            
            var label:Label;
            label = new Label(this, 65, 375, "fuel");
            
            var coolingSlider:HSlider = new HSlider(this, 100, 400, function(e:Event):void {
                cooling = e.target.value;
            });
            coolingSlider.maximum = 10;
            coolingSlider.minimum = 1;
            coolingSlider.width = 265;
            coolingSlider.height *= 1.5;
            coolingSlider.value = cooling;
            
            label = new Label(this, 65, 395, "cooling");
            

            var checkBox:CheckBox = new CheckBox(this, 100, 420, "Random", function(e:Event):void {
                isRandom = e.target.selected;
            });
            checkBox.selected = true;
            
            addEventListener(Event.ENTER_FRAME, onLoop);
        }
        
        private function onLoop(e:Event):void
        {
            var i:int;
            var j:int;
            var sum:int;
            var val:int;
            
            
            for (i = 0; i < _width; i += 1)
            {
                if (isRandom == true)
                {
                    val = Math.random() * (255 - fuel) + fuel;
                }
                else
                {
                    val = startArray[i];
                }                
                fireArray[i][_height - 1] = val;
                fireArrayCopy[i][_height - 1] = val;
            }
            
            for (i = 0; i < _width; i += 1)
            {
                for (j = 1; j < _height; j += 1)
                {
                    sum = fireArray[i][j];
                    
                    if (i > 0)
                    {
                        sum += fireArray[i - 1][j];
                    }
                    if (i < _width - 1)
                    {
                        sum += fireArray[i + 1][j];
                    }
                    //if (j > 0)
                    //{
                        //sum += fireArray[i][j - 1];
                    //}
                    if (j < _height - 1)
                    {
                        sum += fireArray[i][j + 1];
                    }
                    
                    sum /= 4;
                    sum -= cooling;
                    sum = Math.min(255, sum);
                    sum = Math.max(0, sum);
                    
                    
                    fireArrayCopy[i][j - 1] = sum;
                }
            }
            
            for (i = 0; i < _width; i += 1)
            {
                for (j = 0; j < _height - 1; j += 1)
                {
                    fireArray[i][j] = fireArrayCopy[i][j];
                }
            }
            
            energy.lock();
            
            var valfloat:Number;
            
            for (i = 0; i < _width; i += 1)
            {
                for (j = 0; j < _height; j += 1)
                {
                    valfloat = fireArray[i][j] / 255.0;
                    energy.setPixel(i, j, getRGB(valfloat / 3, 1, valfloat > 0.5 ? 1 : valfloat * 2));
                }
            }
            energy.unlock();
            
            
        }
        
        /*
         * from http://snipplr.com/view/34817/as3--hsl-to-rgb-class/
         * */
        public static function getRGB(h:Number, s:Number, l:Number):uint
        {
            var r:Number;
            var g:Number;
            var b:Number;
            
            if(l==0)
            {
                r=g=b=0;
            }
            else
            {
                if(s == 0)
                {
                    r=g=b=l;
                }
                else
                {
                    var t2:Number = (l<=0.5)? l*(1+s):l+s-(l*s);
                    var t1:Number = 2*l-t2;
                    var t3:Vector.<Number> = new Vector.<Number>();
                    t3.push(h+1/3);
                    t3.push(h);
                    t3.push(h-1/3);
                    var clr:Vector.<Number> = new Vector.<Number>();
                    clr.push(0);
                    clr.push(0);
                    clr.push(0);
                    for(var i:int=0;i<3;i++)
                    {
                        if(t3[i]<0)
                            t3[i]+=1;
                        if(t3[i]>1)
                            t3[i]-=1;
                        
                        if(6*t3[i] < 1)
                            clr[i]=t1+(t2-t1)*t3[i]*6;
                        else if(2*t3[i]<1)
                            clr[i]=t2;
                        else if(3*t3[i]<2)
                            clr[i]=(t1+(t2-t1)*((2/3)-t3[i])*6);
                        else
                            clr[i]=t1;
                    }
                    r=clr[0];
                    g=clr[1];
                    b=clr[2];
                }
            }
            return (int(r*255) << 16 | int(g*255) << 8 | int(b*255));
        }
    }
}