/**
 * Copyright fancyblock ( http://wonderfl.net/user/fancyblock )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e8jK
 */

package {
    import flash.automation.AutomationAction;
    import flash.geom.Rectangle;
    import flash.utils.Timer;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite {        

        public var CELL_SIZE:int = 3;
        public var SPACE_WID:int = 130;
        public var SPACE_HEI:int = 130;
        public var UPDATE_TIME:Number = 600;
        public var BLANK_COLOR:uint = 0xffffff;
        public var ALIVE_COLOR:uint = 0x000000;
        
        protected var m_cells:Array = null;
        protected var m_bmpData:BitmapData = null;
        protected var m_timer:Timer = null;        

        public function FlashTest() {
            // create cell set
            m_cells = new Array();
            for( var i:int = 0; i < SPACE_WID; i++ ){
                m_cells[i] = new Array();                
                for( var j:int = 0; j < SPACE_HEI; j++ ){
                    m_cells[i][j] = false;
                    
                    if( Math.random() < 0.09 ){
                        m_cells[i][j] = true;
                    }

                }
            }
            
            // create the bitmap 
            m_bmpData = new BitmapData( CELL_SIZE * SPACE_WID, CELL_SIZE * SPACE_HEI, false, BLANK_COLOR );
            var bmp:Bitmap = new Bitmap( m_bmpData );
            this.addChild( bmp );
            bmp.x = ( 465 - CELL_SIZE * SPACE_WID ) / 2;
            bmp.y = ( 465 - CELL_SIZE * SPACE_HEI ) / 2;

            // add timer
            m_timer = new Timer( UPDATE_TIME );
            m_timer.addEventListener(TimerEvent.TIMER, onUpdate );
            m_timer.start();
            
            // add mouse event
            bmp.addEventListener( MouseEvent.CLICK, onClk );
            
        }
        
        protected function drawCells():void {            
            var color:uint = 0x000000;
            var rect:Rectangle = new Rectangle();
            rect.width = CELL_SIZE;
            rect.height = CELL_SIZE;            

            for ( var i:int = 0; i < SPACE_WID; i++ ) {
                for ( var j:int = 0; j < SPACE_HEI; j++ ) {
                    if ( m_cells[i][j] ) {
                        color = ALIVE_COLOR;
                    }else {
                        color = BLANK_COLOR;
                    }
                    rect.x = i * CELL_SIZE;
                    rect.y = j * CELL_SIZE;
                    m_bmpData.fillRect( rect, color );
                }
            }
        }        

        protected function step():void{
            var newCells:Array = new Array();
            for ( var i:int = 0; i < SPACE_WID; i++ ) {
                newCells[i] = new Array();
                for ( var j:int = 0; j < SPACE_HEI; j++ ) {
                    var neighborCnt:int = neighborCount( m_cells, i, j );
                    
                    if ( neighborCnt == 3 ) {
                        newCells[i][j] = true;
                    }else if ( neighborCnt == 2 ) {
                        newCells[i][j] = m_cells[i][j];
                    }else {
                        newCells[i][j] = false;
                    }
                }
            }            
            m_cells = newCells;
        }
        
        protected function neighborCount( cellSet:Array, xpos:int, ypos:int ):int {
            var count:int = 0;
            
            for ( var i:int = -1; i <= 1; i++ ) {
                for ( var j:int = -1; j <= 1; j++ ) {
                    
                    if ( i == 0 && j == 0 ) {
                        continue;
                    }                    
                    var x:int = xpos + i;
                    var y:int = ypos + j;
                   
                    if ( x >= 0 && x < SPACE_WID && y >= 0 && y < SPACE_HEI  ) {
                        if ( cellSet[x][y] ) {
                            count++;
                        }
                    }
                }
            }            
            return count;
        }        

        protected function onUpdate( evt:TimerEvent ):void {
            step();
            drawCells();
        }        

        protected function onClk( evt:MouseEvent ):void {
            var posx:int = 1;
            var posy:int = 1;
            
            if( posx >= 0 && posy >= 0 && posx < SPACE_WID && posy < SPACE_HEI ){
                m_cells[posx][posy] = true;
            }
            drawCells();
        }
    }

}

