/**
 * Copyright hacker_a790y63i ( http://wonderfl.net/user/hacker_a790y63i )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e8BA
 */

// forked from costa's forked from: LineMix Wash
// forked from costa's LineMix Wash
package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.ProgressEvent;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.text.TextField;
	import flash.utils.ByteArray;
	[SWF(width='500',height='500',backgroundColor='0xffffff',frameRate='40')]
	public class LineMix extends Sprite
	{			
		
		public static const PROXY:String = "http://www.facecartoon.cn/upload/music/";
		public static const CROSSDOMAIN:String = "http://www.facecartoon.cn/upload/music/crossdomain.xml";
		
		private var linesHolder:Sprite;
		private var brushNums:uint = 3;
		private var brushArray:Array = [];
		
		private var bgm:Sound;
        private var bgmChannel:SoundChannel;
        private var ba:ByteArray;
        
       	private var loadTxt:TextField;
		public function LineMix() 
		{
			Security.loadPolicyFile(CROSSDOMAIN);
			loadTxt=new TextField();
			loadTxt.x=250;
			loadTxt.y=200;
			addChild(loadTxt);
			initSound();				
		}
		private function onEnterFrameHandler(e:Event):void
		{
			onBrushTimerHandler()
		}
		private function onBrushTimerHandler():void
		{
			//soundBo
			SoundMixer.computeSpectrum(ba, false, 0);
			refushBrush(ba.readFloat());
		}
		private function initSound():void
		{
			//bgm = new Bgm();
			ba = new ByteArray();
			bgm = new Sound();
		    var sContext:SoundLoaderContext=new SoundLoaderContext(1000,true);
			bgm.load(new URLRequest(PROXY+'mixWeb.mp3'),sContext);
			bgm.addEventListener(ProgressEvent.PROGRESS,onSoundLoadProgressHandler);
			bgm.addEventListener(Event.COMPLETE, onSoundLoadCompleteHandler);
				
			//onSoundLoadCompleteHandler(null);
		}
		private function onSoundLoadProgressHandler(e:ProgressEvent):void
		{			
			loadTxt.text=Math.floor(e.bytesLoaded/e.bytesTotal*100)+'%';
		}
		private function onSoundLoadCompleteHandler(e:Event=null):void
		{
			removeChild(loadTxt);
			bgmChannel = bgm.play();
			linesHolder = new Sprite();
			addChild(linesHolder);
			//bgMc.mask = linesHolder;
			for (var i:uint = 0; i < brushNums; i++)
			{
				if (i == 0)
				{
					var brush:Brush = new Brush(40, 0);
				}else
				{
					brush = new Brush(Math.random()*3,Math.random()*100-50);
				}
				linesHolder.addChild(brush);
				brushArray.push(brush);
			}
			
			addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
		}
		private function refushBrush($scale:Number):void
		{
			trace('scale=====,',$scale);
			for (var i:uint = 0; i < brushNums; i++)
			{
				var brush:Brush = brushArray[i] as Brush;
				brush.moveForward(20);
				if (i>0)
				{
					brush.moveBalls($scale);					
				}
				else
				{
					brush.scaleBrush($scale);
				}
				brush.rotateHead(brush.mouseX, brush.mouseY);
			}
		}
	}
	
}


import caurina.transitions.Tweener;
import flash.display.Sprite;
import flash.geom.Point;

class Brush extends Sprite
{
	private var _thickness:Number;
	
	private var _lineHead:Sprite;
	
	private var pointsObj:Object;
	static public var MAX_LINES:uint = 100;
	private var ball_1:Sprite;
	private var ball_2:Sprite;
	private var linesNum:uint;
	private var lineBox:Sprite;
	private var _stepX:Number ;
	
	private var theta1:Number = 0;
	private var theta2:Number = 10;
	private var _positionY:Number;
	public function Brush($thickness:Number,$positionY:Number) 
	{
		_positionY = $positionY;
		_thickness = $thickness;

		
		_lineHead = new Sprite();
		addChild(_lineHead);
		_lineHead.alpha = 0;
		_lineHead.graphics.lineStyle(1, 0x0000ff);
		_lineHead.graphics.moveTo( 0, 20);			
		_lineHead.graphics.lineTo(15, 0);
		_lineHead.graphics.lineTo(0, -20);
		_lineHead.graphics.lineTo(0, 20);
		
		ball_1 = drawBall(0xff0000);
		ball_2 = drawBall(0x00ff00);
		_lineHead.addChild(ball_1);
		_lineHead.addChild(ball_2);
		ball_1.x = 0;
		ball_1.y =0;
		ball_2.x = 0;
		ball_2.y =0;
		
		pointsObj = new Object();
		pointsObj.prevPoints = [];
		pointsObj.nextPoints = [];
		
		lineBox = new Sprite();
		addChild(lineBox);
		
		
	}
	public function rotateHead($targetX:Number,$targetY:Number):void
	{
		var dx:Number = $targetX - _lineHead.x;			
		var dy:Number = $targetY - _lineHead.y;

		var rotationAngel:Number = Math.atan2(dy, dx) * 180 / Math.PI;
		Tweener.addTween(_lineHead, { rotation :rotationAngel, time:2 } );
		
		_lineHead.rotation = rotationAngel;
		//trace(rotationAngel)
		Tweener.addTween(_lineHead, { x: $targetX, y:$targetY, time:.5, onUpdate:updateLine } );
	}
	private function updateLine():void
	{
		if (pointsObj.prevPoints.length == 0)
		{
			var point1:Point = new Point(ball_1.x, ball_1.y);
			point1 = ball_1.localToGlobal(point1);
			
			var point2:Point = new Point(ball_2.x, ball_2.y);
			point2 = ball_2.localToGlobal(point2);				
			
			pointsObj.prevPoints[0] = point1;
			pointsObj.prevPoints[1] = point2;
			
		}else
		{
			point1 = new Point(ball_1.x, ball_1.y);
			point1 = ball_1.localToGlobal(point1);
			
			point2 = new Point(ball_2.x, ball_2.y);
			point2 = ball_2.localToGlobal(point2);
			
			pointsObj.nextPoints[0] = point1;
			pointsObj.nextPoints[1] = point2;

			//drawLineClip
			var lineClip:Sprite = new Sprite;
			lineBox.addChild(lineClip);
			
			//lineClip.graphics.lineStyle(1, 0xff0000, 1);
			lineClip.graphics.beginFill(0x000000, .5);
			
			lineClip.graphics.moveTo(pointsObj.prevPoints[0].x-x, pointsObj.prevPoints[0].y-y);
			lineClip.graphics.lineTo(pointsObj.nextPoints[0].x-x+_stepX, pointsObj.nextPoints[0].y-y);
			lineClip.graphics.lineTo(pointsObj.nextPoints[1].x-x+_stepX, pointsObj.nextPoints[1].y-y);
			lineClip.graphics.lineTo(pointsObj.prevPoints[1].x-x, pointsObj.prevPoints[1].y-y);
			lineClip.graphics.endFill();
			pointsObj.prevPoints[0] = pointsObj.nextPoints[0];
			pointsObj.prevPoints[1] = pointsObj.nextPoints[1];
			
			linesNum++;
			if (linesNum > MAX_LINES)
			{
				lineBox.removeChildAt(0);
			}
		}
	}
	private function drawBall($color:uint):Sprite
	{
		var ball:Sprite = new Sprite;
		ball.graphics.lineStyle(1,0xff0000,1)
		//ball.graphics.beginFill($color, .5);
		ball.graphics.drawCircle(0, 0, 5);	
		return ball;
	}
	public function moveForward($step:uint):void
	{
		_stepX = $step;
		x -= $step;
	}
	public function moveBalls($theataClip:Number):void
	{
		theta1 +=$theataClip*10;
		theta2 += $theataClip*10;
		//ball_1.y =Math.sin(theta1) * _thickness*2  +_positionY*$theataClip*3;			
		//ball_2.y = Math.sin(theta2) * _thickness*2 +_positionY*$theataClip*3;
		Tweener.addTween(ball_1,{y:Math.sin(theta1) * _thickness*2  +_positionY*$theataClip,time:1});
		Tweener.addTween(ball_2,{y:Math.sin(theta2) * _thickness*2 +_positionY*$theataClip,time:1});
		
	}
	public function scaleBrush($theataClip:Number):void
	{
		if(_thickness * $theataClip/2>0)
		{
			Tweener.addTween(ball_1, { y:_thickness * $theataClip/2+1, time:.5} );			
			Tweener.addTween(ball_2, { y: -_thickness  * $theataClip/2-1, time:.5 } );	
		}	
	}
}	