/**
 * Copyright dhoopingarner ( http://wonderfl.net/user/dhoopingarner )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e7yJ
 */

package {
	
	import flash.display.*;
	import flash.events.*;
	import flash.media.*;
	import flash.utils.Timer;
	
	public class Mic extends Sprite {
		
		private var mic:Microphone;
		private var g:Graphics;
		private var myTimer:Timer;
		private var xInc:int = 0;
		
		public function Mic() {
			mic = Microphone.getMicrophone();
			mic.setLoopBack(true);
			mic.setUseEchoSuppression(true);
			mic.gain = 80;
			mic.rate = 11;
			mic.setSilenceLevel(5, 1000);

			var trans:SoundTransform = mic.soundTransform;
			trans.volume = 0;
			mic.soundTransform = trans;
			
			mic.addEventListener(StatusEvent.STATUS, onMicStatus);
			
			var canvas:Sprite = new Sprite();
			addChild(canvas);
			g = canvas.graphics;
			initCanvas();
			
			myTimer = new Timer(50);
			myTimer.addEventListener("timer", timerHandler);
			myTimer.start();
		}
		
		private function onMicStatus(evt:StatusEvent):void {
			if (evt.code == "Microphone.Unmuted") {
				showMicInfo();
			} else if (evt.code == "Microphone.Muted") {
				trace("Microphone access was denied.");
			}
		}
		
		private function showMicInfo():void {
			var sndInputs:Array = Microphone.names;
			trace("Available sound input devices:");
			for (var i:int = 0; i < sndInputs.length; i++) {
				trace("--", sndInputs[i]);
			}
			trace("Sound input device name:", mic.name);
			
			trace("Muted:", mic.muted);
			trace("Echo suppression:", mic.useEchoSuppression);
			trace("Gain:", mic.gain);
			trace("Rate:", mic.rate, "kHz");
			trace("Silence level:", mic.silenceLevel);
			trace("Silence timeout:", mic.silenceTimeout);
		}
		
		private function initCanvas():void {
			g.clear();
			g.lineStyle(0, 0x6600CC);
			g.moveTo(0, 300);
		}
		
		private function timerHandler(evt:TimerEvent):void {
			g.lineTo(xInc, 300 - mic.activityLevel);
			if (xInc > 550) {
				xInc = 0;
				initCanvas();
			} else {
				xInc+=2;
			}
		}
	}
}