/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e7KM
 */

package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.geom.Vector3D;
	/**
	 * ...
	 * @author lizhi
	 */
	public class Test extends Sprite{
		public function Test() 
		{
			var bmd:BitmapData = new BitmapData(512, 512,false);
			createXorMap(bmd);
			var bmd2:BitmapData = bmd.clone();
			
			for (var x:int = 0; x < bmd.width;x++ ) {
				for (var y:int = 0; y < bmd.height; y++ ) {
					var iUV0:Vector3D = new Vector3D(x / bmd.width, y / bmd.height);
					var theta:Vector3D = new Vector3D(iUV0.x - .5, iUV0.y - .5, iUV0.x - .5, iUV0.y - .5);
					var rSq:Number = theta.dotProduct(theta )+theta.w*theta.w;
					
					var warp:Vector3D = new Vector3D( -0.025,-0.025,-0.05 -0.05 );
					warp.scaleBy(rSq);
					warp.w *= rSq;
					warp = new Vector3D(warp.x + 1, warp.y + 1, warp.z + 1, warp.w + 1);
					var w:Vector3D = new Vector3D(warp.x*theta.x,warp.y*theta.y,warp.z*theta.z,warp.w*theta.w);
					
					var color:uint = 
					((sampler2D(bmd, iUV0) >> 16 & 0xff) << 16)
					|((sampler2D(bmd, new Vector3D(w.x+.5,w.y+.5)) >> 8 & 0xff) << 8)
					|((sampler2D(bmd, new Vector3D(w.z+.5,w.w+.5)) >> 0 & 0xff) << 0)
					
					bmd2.setPixel(x, y, color);
				}
			}
			
			addChild(new Bitmap(bmd2));
		}
		
		private function sampler2D(bmd:BitmapData, uv:Vector3D):uint {
			return bmd.getPixel(Math.round(uv.x*bmd.width),Math.round(uv.y*bmd.height));
		}
		
		public static function createXorMap(b:BitmapData):void {
			for (var i:int = 0; i < b.height; i++){
				for (var k:int = 0; k < b.width; k++){
					b.setPixel(k,i, (i^k)<<16 | (i ^ k) << 8 | (i^k));
				}
			}
		}
		
	}

}
//https://dl.dropboxusercontent.com/u/12986030/flare3d/Custom%20Rendring%20Pipelines.zip
/*technique chromaticAberration
{
	param float2 warp = float2( -0.025, -0.05 );
	
	float4 theta = iUV0.xyxy - 0.5;
	
	float rSq = dot( theta, theta );
	
	float4 w = theta * (1 + warp.xxyy * rSq);
	
	float4 color;
	color.r = sampler2D( texture, iUV0 ).r
	color.g = sampler2D( texture, w.xy + 0.5 ).g;
	color.b = sampler2D( texture, w.zw + 0.5 ).b;
	color.a = 1;
	output fragment = color;
}*/