/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e6v5
 */

package {
	import frocessing.display.F5MovieClip2DBmp;
	import frocessing.geom.FMatrix2D;

	[SWF(backgroundColor=0x444444, width=465, height=465)]
	public class frocessingmtx extends F5MovieClip2DBmp
	{
		private var px:Number, py:Number, nx:Number, ny:Number;
		private var vx:Number, vy:Number;
		private var r:Number;
		
		private var mtx:FMatrix2D = new FMatrix2D();
		private var tmt:FMatrix2D = new FMatrix2D();
		
		public function frocessingmtx()
		{
			super( false, 0x00000000 );
            stage.frameRate = 60;
		}
		
		public function setup():void
        {
            size( 465, 465 );
            background(0);
            noStroke();
            
            px = 100; py = 100;
            nx = 200; ny = 100;
            
            firstDraw();
            moveToPoint();
        }
        
        private function moveToPoint():void {
        	vx = nx - px;
        	vy = ny - py;
        	
        	mtx.rotate( atan2( vy, vx ) );
            mtx.translate( nx, ny );
            create();
            for(var i:int=0; i<200; i++) {
            	myloop();
            }
        }
        
        
        public function firstDraw():void {
        	stroke(0xFFFFFF);
        	moveTo(nx,ny);
        }
        
        private function create():void {
        	var angle:Number = random(PI/15,PI/6);
        	r = angle;
        	tmt.scale( 0.95, 0.95 );
            tmt.rotate( angle );
            tmt.translate( 20, 20 );
        }
        
        private function myloop():void {
        	if( Math.random()>0.9 ){
                tmt.rotate( -r*2 );
                r *= -1;
            }
        	mtx.prepend(tmt);
        	nx = mtx.tx;
            ny = mtx.ty;
            stroke(0xFFFFFF);
            lineTo(nx,ny);
        }
        
        public function draw():void {}
        
	}
}
