/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e6tB
 */

// forked from _wonder's Bitmap：Matrixを追加
// forked from _wonder's forked from: Bitmap基本
// forked from _wonder's Bitmap基本
package {
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    
    [SWF(width=465, height=465, backgroundColor=0)]
    import flash.events.MouseEvent;
    public class myBitmap extends Sprite {
        
        private var fig:Sprite;
        private var bitmapdata:BitmapData;
        private var matrix:Matrix;
        private var colortrans:ColorTransform;
        
        public function myBitmap() {
            fig = createCircle( 0, 0, 50, 0Xffffff );
            bitmapdata = new BitmapData( 465, 465, false, 0 );
            addChild( new Bitmap( bitmapdata ) );
            
            matrix = new Matrix();
            colortrans = new ColorTransform();
            
            addEventListener( Event.ENTER_FRAME, enterframe );
            stage.addEventListener( MouseEvent.CLICK, reset);
        }
        
        private function createCircle(cx:Number, cy:Number, size:Number, col:uint):Sprite {
            var sprite:Sprite = new Sprite();
            sprite.graphics.lineStyle( 0, 0X000000, 0.3 );
            sprite.graphics.beginFill( col );
            sprite.graphics.drawCircle( cx, cy, size*0.5 );
            sprite.graphics.drawCircle( cx, cy, size*0.4 );
            var w:Number = size * 0.6;
            var h:Number = size * 0.15;
            sprite.graphics.drawRect( cx - w/2, cy - h/2, w, h);
            sprite.graphics.endFill();
            return sprite;
        }
        
        private function enterframe(e:Event):void {
            matrix.identity();
            var s:Number = Math.random()*2;
            matrix.scale( s,s );
            matrix.rotate( Math.PI * Math.random() );
            matrix.translate( mouseX, mouseY );
            
            colortrans.greenMultiplier = mouseX / 465;
            colortrans.blueMultiplier = mouseY / 465;
            colortrans.alphaMultiplier = Math.random();
            bitmapdata.draw( fig, matrix, colortrans );
        }
        
        private function reset(e:MouseEvent):void {
            bitmapdata.fillRect( bitmapdata.rect, 0X000000);
        }
    }
}