/**
 * Copyright Zebestov ( http://wonderfl.net/user/Zebestov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e62C
 */

package {
    import flash.system.LoaderContext;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.display.LoaderInfo;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.display.Sprite;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.display.Shape;

    public class Main extends Sprite {

        private var image:BitmapData;
        private var lightmap:BitmapData;
        private var backScreen:Shape;
        private var frontScreen:BitmapData;

        public function Main() {
            loadImage();
        }

        private function start():void {
            var sw:int = stage.stageWidth;
            var sh:int = stage.stageHeight;

            backScreen = new Shape();
            frontScreen = new BitmapData(sw, sh, false, 0xffffff);
            addChild(new Bitmap(frontScreen));

            var scale:Number = Math.max(sw / image.width, sh / image.height);
            image.applyFilter(image, image.rect, new Point(), new BlurFilter(5, 5, 5));
            var mtx:Matrix = new Matrix(scale, 0, 0, scale, (sw - image.width * scale) / 2, (sh - image.height * scale) / 2);
            lightmap = new BitmapData(sw, sh, false, 0xffffff);
            lightmap.draw(image, mtx, null, null, null, true);

            var maxPointDiameter:int = 5;
            var maxRadius:int = Math.ceil(Math.sqrt(sw*sw + sh*sh) / 2);
            var p:Point = new Point();
            var c:uint, cR:uint, cG:uint, cB:uint, cA:uint;
            for (var r:int = maxPointDiameter / 2; r < maxRadius; r += maxPointDiameter) {
                var circleLength:Number = 2 * Math.PI * r;
                var da:Number = Math.PI * 2 / Math.floor(circleLength / maxPointDiameter);
                for (var a:Number = 0; a < Math.PI * 2; a += da) {
                    p.x = sw / 2 + r * Math.cos(a);
                    p.y = sh / 2 + r * Math.sin(a);
                    if (p.x > 0 && p.x < sw && p.y > 0 && p.y < sh) {
                        c = lightmap.getPixel(p.x, p.y);
                        cB = c & 0xff;
                        cG = c >> 8 & 0xff;
                        cR = c >> 16 & 0xff;
                        cA = cR * 0.3 + cG * 0.59 + cB * 0.11;
                        backScreen.graphics.beginFill(0);
                        backScreen.graphics.drawCircle(p.x, p.y, (255 - cA) / 255 * maxPointDiameter * 0.75);
                        backScreen.graphics.endFill();
                    }
                }
                frontScreen.draw(backScreen, null, null, null, null, true);
                backScreen.graphics.clear();
            }
        }

        private function loadImage():void {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadComplete);
            loader.load(new URLRequest('http://assets.wonderfl.net/images/related_images/4/47/4786/478610286ba93f45518f4f2e9d0bf0326035cc1b'), new LoaderContext(true));
        }

        private function onLoadComplete(event:Event):void {
            (event.target as LoaderInfo).removeEventListener(Event.COMPLETE, onLoadComplete);
            image = ((event.target as LoaderInfo).content as Bitmap).bitmapData;
            start();
        }
    }
}
