/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e5n7
 */

package {
    import flash.display.*;
    import flash.text.*;
    
    public class NamespaceTest extends Sprite{
        public function NamespaceTest (){
            setup();
            
            APIServer.setWWW();
            report( "#for Publish", APIServer.getDomain() + API.USER_INFO );
            
            APIServer.setSTG();
            report( "#for Staging", APIServer.getDomain() + API.USER_INFO );
            
            APIServer.setDEV();
            report( "#for Dev", APIServer.getDomain() + API.USER_INFO );
            
            APIServer.setLOCAL();
            report( "#for Local", APIServer.getDomain() + API.USER_INFO );
            
        }
        
        
        // to report
        private var _report:TextField;
        private function setup():void {
            addChild( _report = new TextField() );
            _report.width = _report.height = 465;
            _report.defaultTextFormat = new TextFormat( "_sans", 16, 0x330000, true );
        }
        private function report( label:String, message:String ):void{
             _report.appendText(
                [
                    label, "\n",
                    message, "\n",
                    "\n"
                    ].join("")
            );
        }
    }
}


import flash.errors.IllegalOperationError;
class API {
    public static const USER_INFO:String = "/api/userinfo";
    public static const MEMBERS:String = "/api/members";
}
class APIServer {
    private namespace www;
    private namespace stg;
    private namespace dev;
    private namespace local;
    
    www static const DOMAIN:String = "http://example.com";
    stg static const DOMAIN:String = "http://stg.example.com";
    dev static const DOMAIN:String = "http://test.example.com";
    local static const DOMAIN:String = "http://localhost";
    
    private static var server:Namespace;
    {
        server = www;
    }
    
    public static function setWWW():void {
        server = www;
        trace("WebServer.setWWW");
    }
    public static function setSTG():void {
        server = stg;
        trace("WebServer.setSTG");
    }
    public static function setDEV():void {
        server = dev;
        trace("WebServer.setDEV");
    }
    public static function setLOCAL():void {
        server = local;
        trace("WebServer.setLOCAL");
    }
    
    public static function get isLocal():Boolean {
        return server == local;
    }
    
    public static function get isDev():Boolean {
        return server == dev;
    }
    
    public static function get isWWW():Boolean {
        return server == www;
    }
    
    public static function getDomain():String {
        return server::DOMAIN;
    }
    
    public static function getURL( api:String ):String {
        return getDomain()+ api;
    }
        
    public function APIServer () {
        new IllegalOperationError("APIServer クラスはインスタンスを生成できません。");
    }
}