/**
 * Copyright katopz ( http://wonderfl.net/user/katopz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e5jr
 */

package
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;

	/**
	 * 
	 * http://actionsnippet.com/?p=1519
	 * @author Zevan | June 10, 2009
	 *
	 */
	public class VectorparkStyleHemisphere extends Sprite
	{
		private const TWO_PI:Number = Math.PI * 2;
		private const PI_HALF_PI:Number = Math.PI + Math.PI / 2;
		private var bg:Sprite;
		private var scol:uint;
		private var slice:Sprite;
		private var colA:uint;
		private var colB:uint;
		private var s:Sprite;
		private var size:Number;
		private var dx:Number = 0;
		private var dy:Number = 0;
		
		public function VectorparkStyleHemisphere()
		{
			x = stage.stageWidth / 2;
			y = stage.stageHeight / 2;
			makeHemisphere(0, 0, 100, 0xFF0000, 0xFFCC00);
			addEventListener(Event.ENTER_FRAME, onLoop);
		}

		private function onLoop(evt:Event):void
		{
			dx += (mouseX / 50 - dx) / 4;
			dy += (mouseY - dy) / 4;
			
			runHemisphere(dx, dy);
		}
		
		private function runHemisphere(theta:Number, rot:Number):void
		{
			theta %= TWO_PI;
			if (theta < 0)
			{
				theta = TWO_PI - -theta;
			}
			var scale:Number = Math.cos(theta);
			if (theta > 1.57)
			{
				scol = colA;
			}
			else
			{
				scol = colB;
			}
			if (theta > Math.PI)
			{
				bg.rotation = 180;
			}
			else
			{
				bg.rotation = 0;
			}
			if (theta > PI_HALF_PI)
			{
				scol = colB;
			}
			
			slice.graphics.clear();
			slice.graphics.beginFill(scol);
			scaleYcircle(slice.graphics, size, scale);
			
			s.rotation = rot;
		}
		
		private function makeHemisphere(x:Number, y:Number, size:Number, colA:uint, colB:uint):void
		{
			this.colA = colA; 
			this.colB = colB;
			this.size = size;
			 
			s = new Sprite();
			addChild(s);
			s.x = x;
			s.y = y;
			bg = new Sprite();
			s.addChild(bg);
			bg.graphics.clear();
			bg.graphics.beginFill(colA);
			halfCircle(bg.graphics, 0, 0, size);
			scol = colB;
			slice = new Sprite();
			s.addChild(slice);
		}

		// original circle function by senocular (www.senocular.com) from here http://www.actionscript.org/forums/showthread.php3?s=&threadid=30328
		private function halfCircle(g:Graphics, x:Number, y:Number, r:Number):void
		{
			var c1:Number = r * (Math.SQRT2 - 1);
			var c2:Number = r * Math.SQRT2 / 2;
			var xr:Number = x + r, yr:Number = y + r;
			var x_r:Number = x - r, yc1:Number = y + c1;
			var yc2:Number = y + c2, xc1:Number = x + c1, xc2:Number = x + c2;
			var x_c1:Number = x - c1;
			g.moveTo(xr, y);
			g.curveTo(xr, yc1, xc2, yc2);
			g.curveTo(xc1, yr, x, yr);
			g.curveTo(x - c1, yr, x - c2, yc2);
			g.curveTo(x_r, yc1, x_r, y);
		}

		// circle that can be scaled on the y axis
		private function scaleYcircle(g:Graphics, r:Number, s:Number = 1):void
		{
			var c1:Number = r * (Math.SQRT2 - 1);
			var c2:Number = r * Math.SQRT2 / 2;
			var rs:Number = r * s, c1s:Number = c1 * s, c2s:Number = c2 * s;
			var x_r:Number = -r, y_r:Number = -rs, x_c2:Number = -c2;
			var y_c2:Number = -c2s, x_c1:Number = -c1, y_c1:Number = -c1s
			g.moveTo(r, 0), g.curveTo(r, c1s, c2, c2s);
			g.curveTo(c1, rs, 0, rs), g.curveTo(x_c1, rs, x_c2, c2s);
			g.curveTo(x_r, c1s, x_r, 0), g.curveTo(x_r, y_c1, x_c2, y_c2);
			g.curveTo(x_c1, y_r, 0, y_r), g.curveTo(c1, y_r, c2, y_c2);
			g.curveTo(r, y_c1, r, 0);
		}
	}
}