/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e5HF
 */

package {
    import flash.display.Sprite;
    import com.bit101.components.*;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        
        private var _text: Text;
        private var _charSet: Text;
        private var _output: Label;
        private var _map: Object;
        private const _prime: Vector.<uint> = new Vector.<uint>();
        
        public function FlashTest() {
            _text = new Text();
            _text.text = "abccba";
            _text.height = 20;
            _text.addEventListener( Event.CHANGE, update );
            
            addChild( labelize( "text", _text, 100 ) );
            
            _charSet = new Text();
            _charSet.height = 20;
            _charSet.text = "abc";
            _charSet.addEventListener( Event.CHANGE, update );
            
            addChild( move( labelize( "charset", _charSet, 100 ), 0, 30 ) );
            
            _output = new Label();
            _output.autoSize = true;
            addChild( move( labelize( "goedelized", _output, 100 ), 0, 60 ) );
            _output.textField.selectable = true;
            
            _prime.push(2);
            _prime.push(3);
            
            update();
        }
        
        private function update( e: Event = null ): void {
            if( e ) {
                if( e.target == _charSet ) {
                    _charSet.text = uniqueChar( _charSet.text );
                }
                _text.text = filter( _text.text, _charSet.text );
            }
            var num: uint = _prime[ _prime.length-1 ];
            while( _prime.length < _text.text.length ) {
                var found: Boolean = false;
                while( !found ) {
                    ++num;
                    found = true;
                    for( var j: int = 0; j<_prime.length; ++j) {
                        if( num % _prime[j] == 0 ) {
                            found = false;
                            break;
                        }
                    }
                }
                _prime.push( num );
            }
            var text: String = _text.text;
            num = 1;
            for( var i: int = 0; i< text.length; ++i ) {
                var char: String = text.charAt(i);
                num *= Math.pow( _prime[ i ], _charSet.text.indexOf(char)+1 );
            }
            _output.text = num.toString();
        }
    }
}

import flash.display.Sprite;
import flash.display.DisplayObject;
import com.bit101.components.Label;

function move( dO: DisplayObject, x: Number, y: Number ): DisplayObject {
    dO.x = x;
    dO.y = y;
    return dO;
}


function labelize( name: String, content: DisplayObject, indent: Number = -1 ): Sprite {
    var label: Label = new Label();
    label.text = name;
    if( indent == -1 ) {
        content.x = label.width;
    } else {
        content.x = indent;
    }
    return group( label, content );
}


function group( ... dos: Array ): Sprite {
    var sprite: Sprite = new Sprite;
    for( var i: String in dos ) {
        sprite.addChild( dos[i] );
    }
    return sprite;
}

function filter( text: String, charset: String ): String {
    var result: String = "";
    for( var i: int = 0; i<text.length; ++i ) {
           var char: String = text.charAt(i);
           if( charset.indexOf( char ) != -1 ) {
               result += char;
           }

    }
    return result;
}


function uniqueChar( string: String ): String {
  var chars: Object = {};
  var result: String = "";
  for( var i: int = 0; i<string.length; ++i) {
      var char: String = string.charAt(i);
      if( !chars[char] ) {
          chars[char] = true;
          result += char;
      }
  }
  return result;
}