/**
 * Copyright tshinchi38 ( http://wonderfl.net/user/tshinchi38 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e55p
 */

package {
	
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.net.URLRequest;
	import flash.filters.GlowFilter;
	import flash.filters.BlurFilter;
	
	import flash.events.Event
	import flash.events.MouseEvent;
	
	[SWF(backgroundColor=0x000000)]
    public class FlashTest extends Sprite {
		
		private var image:Loader;
		private var ifilters:Array;
		private var deg:Number = 0;
		private var DEGREETORADIAN:Number = Math.PI / 180;
		private var COUNT:uint = 360;
		private var DEGOFFSET:uint = 360 / COUNT;
		
        public function FlashTest() {
			
			image = new Loader();
			image.load(new URLRequest("http://isearch.c.yimg.jp/image?id=de6393c269fda3106bbe338f54751779"));
			addChild(image);
			var glow:GlowFilter = new GlowFilter(0x9999ff, 2, 6, 6, 2, 1);
			var blur:BlurFilter = new BlurFilter(4, 4, 1);
			ifilters = new Array();
			ifilters.push(glow);
			ifilters.push(blur);
			image.filters = ifilters;
			image.x = 100;
			image.y = 100;
			
			image.addEventListener(MouseEvent.MOUSE_OVER,resetFilters);
			image.addEventListener(MouseEvent.MOUSE_OUT, addFilters);
			
			addEventListener(Event.ENTER_FRAME, loop);
		}

		private function resetFilters(event:MouseEvent):void{
			image.filters = [];
		}

		private function addFilters(event:MouseEvent):void{
			image.filters = ifilters;
		}

		private function loop(event:Event):void{
			
			deg = Math.floor(deg%360);
			image.x = Math.cos(deg * DEGREETORADIAN) * COUNT;
			image.y = Math.sin(deg * DEGREETORADIAN) * COUNT;
			deg += DEGOFFSET;
			
			image.filters = [];
			ifilters = [];
			
			var seed:Number = Math.sin(deg * DEGREETORADIAN);
			
			var glow:GlowFilter = new GlowFilter(0x9999ff, 1, 120*seed, 120*seed, 2, 1);
			var blur:BlurFilter = new BlurFilter(12*seed, 12*seed, 1 );
			ifilters.push(glow);
			ifilters.push(blur);
			image.filters = ifilters;
            
        }
    }
}