/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e4lD
 */

package {
	
	import flash.display.Sprite;
	import flash.text.*;
	import flash.events.MouseEvent;
	
	/**
	 * ...
	 * @author ...
	 */
	public class MyTextField extends Sprite {
		public var btn:Sprite;
		public var tf:TextField;
		public var format:TextFormat;
		
		// コンストラクタ
		public function MyTextField() {
			btn = new Sprite();
			// font,size,color
			format = makeTextFormat( "_typewriter", 18, 0x000000 );
			
			tf = new TextField();
			tf.x = 100;
			tf.y = 100;
			tf.autoSize = TextFieldAutoSize.LEFT;
			tf.background = true;
			tf.defaultTextFormat = format;
			tf.text = "こんにちは";
			
			// テキストを選択できないようにする
			tf.selectable = false;
			
			// マウスをハンドカーソルに
			btn.buttonMode = true;
			
			// falseにするとマウスイベントを受け取らなくなる
			// 表示リスト上のこのインスタンスの子は影響を受けません
			tf.mouseEnabled = false;
						
			// falseにすると、設定したMCに入れ子になってるものにはマウスが効かなくなる
			mouseChildren = true; 
			
			addChild( btn );
			btn.addChild( tf )
			
			btn.addEventListener( MouseEvent.ROLL_OVER, rollOverHandler );
			btn.addEventListener( MouseEvent.ROLL_OUT, rollOutHandler );
		}
		
		public function rollOverHandler( e:MouseEvent ):void { 
			tf.backgroundColor = 0x000066;
			tf.textColor = 0xffffff;
		}
		
		public function rollOutHandler( e:MouseEvent ):void {
			tf.backgroundColor = 0xffffff;
			tf.textColor = 0x000000;
		}
		
		// 書式の設定
		public function makeTextFormat( font:String, size:uint, color:uint ):TextFormat {
			var format:TextFormat = new TextFormat();
			format.font = font;
			format.size = size;
			format.color = color;
			return format;
		}
	}
	
}