/**
 * Copyright makc3d ( http://wonderfl.net/user/makc3d )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e4bv
 */

// forked from makc3d's forked from: treeui
// forked from lizhi's treeui
package  
{
	import flash.display.Sprite;
	/**
	 * ...
	 * @author lizhi
	 */
	public class TreeUI extends Sprite
	{
		private var rootTree:TreeNode=new TreeNode;
		private var treeUI:Sprite = new Sprite;
		private var pen:GradientLinesPen = new GradientLinesPen(treeUI.graphics, [0, 0], [1, 0], [1, 4], 0);
		public function TreeUI() 
		{
			addChild(treeUI);
			rootTree.closed = false;
			render();

                        addEventListener("enterFrame", loop);
		}
		
		public function render():void {
			treeUI.graphics.clear();
			while (treeUI.numChildren > 0) treeUI.removeChildAt(0);
			treeUI.graphics.lineStyle(0, 0xff0000);

                        lowestVisibleY = 0;
			renderCell(rootTree, 0, 0);
		}

                private var lowestVisibleY:Number;
                private var lowestVisibleNode:TreeNode;
                
                private function loop(...dahoop):void {
for(var c:int = 0; c < 123; c++) {
                    if (lowestVisibleNode && lowestVisibleNode.closed) {
                        lowestVisibleNode.closed = false;
                        render();
                    }
}
                }
		
		private function renderCell(tree:TreeNode, x:Number, y:Number):Number {
			var sy:Number = y;
			treeUI.addChild(new TreeNodeUI(tree, x, y,this));
			y += 20;
			if (!tree.closed) {
				var vx:Number = x + 10;
				var vy:Number = y;
				for each(var child:TreeNode in tree.children) {
					pen.moveTo(vx, y+10);
					pen.lineTo(vx + 20, y + 10);
					vy = y;
// just to speed it up
if (y > stage.stageHeight + 100) return y;
					y = renderCell(child, x + 20, y);
				}
				pen.moveTo(vx, sy+15);
				pen.lineTo(vx, vy+10);
			} else {
                            if ((y < stage.stageHeight) && (y > lowestVisibleY)) {
                                lowestVisibleY = y;
                                lowestVisibleNode = tree;
                            }
                        }
			return y;
		}
	}

}

import flash.events.MouseEvent;
import flash.text.TextField;
import flash.display.CapsStyle;
    import flash.display.GradientType;
    import flash.display.Graphics;
    import flash.display.SpreadMethod;
    import flash.geom.Matrix;
class TreeNodeUI extends flash.display.Sprite {
	public var node:TreeNode;
	public var treeUI:TreeUI;
	public function TreeNodeUI(node:TreeNode,x:Number,y:Number,main:TreeUI) {
		this.node = node;
		this.treeUI = main;
		var tf:TextField = new TextField();
		tf.autoSize = "left";
		tf.text = node.name;
		tf.mouseEnabled = tf.selectable = tf.mouseWheelEnabled = false;
		buttonMode = true;
		addChild(tf);
		this.x = x;
		this.y = y;
		addEventListener(MouseEvent.CLICK, click);
	}
	
	private function click(e:MouseEvent):void 
	{
		node.closed = !node.closed;
		treeUI.render();
	}
}

class TreeNode {
	public static var ID:int = 0;
	public var parent:TreeNode;
	public var closed:Boolean = true;
	public var name:String = "node" + (ID++);
	private var _children:Vector.<TreeNode>;
	public function get children():Vector.<TreeNode> 
	{
		if(_children==null){
			var c:int = 2 + 5 * Math.random();
			_children = new Vector.<TreeNode>;
			while (c-->0) {
				_children.push(new TreeNode);
			}
		}
		return _children;
	}
}
class GradientLinesPen
    {
        private var g:Graphics;
        private var colors:Array;
        private var alphas:Array;
        private var ratios:Array;
        private var m:Matrix = new Matrix();
        private var thickness:Number;
        private var sx:Number;
        private var sy:Number;
        private var w:Number;
        public function GradientLinesPen(g:Graphics,colors:Array,alphas:Array,widths:Array,thickness:Number) 
        {
            this.g = g;
            setGradientLines(colors, alphas, widths, thickness);
        }
        public function setGradientLines(colors:Array,alphas:Array,widths:Array,thickness:Number):void {
            for (var i:int = colors.length-2; i > 0;i-- ) {
                colors.splice(i, 0, colors[i]);
            }
            this.colors = colors;
            for (i = alphas.length-2; i > 0;i-- ) {
                alphas.splice(i, 0, alphas[i]);
            }
            this.alphas = alphas;
            w = 0;
            for each(var value:Number in widths) {
                w += value;
            }
            ratios = [];
            var cw:Number = 0;
            for (i = 0; i < widths.length - 1; i++ ) {
                cw += 0xff * widths[i] / w;
                ratios.push(cw);
                ratios.push(cw);
            }
            this.thickness = thickness;
        }
        public function moveTo(x:Number, y:Number):void {
            g.moveTo(x, y);
            sx = x;
            sy = y;
        }
        public function lineTo(x:Number, y:Number):void {
            var dx:Number = x - sx;
            var dy:Number = y - sy;
            var a:Number = Math.atan2(dy, dx);
            var m:Matrix = new Matrix();
            m.createGradientBox(w, w, a);
            g.lineStyle(thickness, 0, 0, false, null, CapsStyle.SQUARE);
            g.lineGradientStyle(GradientType.LINEAR, colors, alphas, ratios, m, SpreadMethod.REPEAT);
            g.lineTo(x, y);
            sx = x;
            sy = y;
        }
    }