/**
 * Copyright hacker_9p8x8mco ( http://wonderfl.net/user/hacker_9p8x8mco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e3lF
 */

package{
	import flash.display.Sprite;
	import flash.events.Event;
	
	public class AnimationExample extends Sprite{
		private var _car:Car;
		
		public function AnimationExample(){
			_car = new Car(0x000000);
			_car.putGas(50);
			_car.y = 200;
			addChild(_car);
			
			addEventListener(Event.ENTER_FRAME,moveCar);
		}
		
		private function moveCar(e:Event):void{
			_car.move();
		}
	}
}

import flash.display.Sprite;

class Car extends Sprite{
	private var _gas:int = 0;
	
	public function Car(_fillColor:uint){
		_draw(_fillColor);
	}
	
	public function putGas(_amount:int):void{
		if(_amount < 0){
			return;
		}
		
		_gas += _amount;
	}
	
	public function move():void{
		if(_gas > 10){
			x += 5;
		} else {
			x += _gas / 2;
		}
		
		_gas--;
		if (_gas < 0) {
			_gas = 0;
		}
	}
	
	private function _draw(_fillColor:uint):void{
		graphics.beginFill(0x333333);
		graphics.drawCircle(10,20,5);
		graphics.drawCircle(45,20,5);
		graphics.endFill();
		
		graphics.beginFill(_fillColor);
		graphics.moveTo(0,10);
		graphics.lineTo(15,0);
		graphics.lineTo(30,0);
		graphics.lineTo(40,10);
		graphics.lineTo(50,10);
		graphics.lineTo(55,15);
		graphics.lineTo(55,20);
		graphics.lineTo(0,20);
		graphics.endFill();
	}
}