/**
 * Copyright takashi ( http://wonderfl.net/user/takashi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e3hC
 */

package {
	import flash.display.Sprite;
	import flash.geom.Matrix;
	import flash.filters.DisplacementMapFilter;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
	import flash.filters.DisplacementMapFilterMode;
	
    import flash.geom.Point;
    import flash.geom.Rectangle;
	import flash.display.Sprite;
	import flash.events.Event;
	
	public class TestDisplacementMapFilter extends Sprite {
		private var _bm:Bitmap;
		private var _bd:BitmapData;
		private const BD_WIDTH:Number = 440; //BitmapDataWidth
		private const BD_HEIGHT:Number = 270; //BitmapDataHeight
		
		private var _sp:Sprite = new Sprite();
		
		//perlinNoise() args
		private var _nX:Number = 0; 			//x 方向で使用する周波数。
		private var _nY:Number = 0; 			//y 方向で使用する周波数。
		private const PERLIN_OCTAVES:Number = 1; 		//numOctaves このノイズを作成するために組み合わせるオクターブ (つまり個々のノイズ関数) の数
		private const CHANNELS:uint = BitmapDataChannel.RED | BitmapDataChannel.BLUE | BitmapDataChannel.GREEN;//color channelOptions 任意の 4 つのカラーチャンネル値の組み合わせである数値
		private const PERLIN_SEED:int = Math.floor(Math.random() * 10);	//randomSeed ランダムシード (乱数の種) として使用する数値
		private var _offset:Array = new Array(); //各オクターブの x オフセットと y オフセットに対応するポイントの配列
		private var _speed:Array = new Array();
		
		
		private const SCALE_X:int = Math.random() * 1000;
		private const SCALE_Y:int = Math.random() * 1000;
		
		
		public function TestDisplacementMapFilter() {
			doInit();
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			addChild(_sp);
		}

		// 表示の初期化をします。
		private function doInit():void{
			// 関数の数だけ必要
			for (var i:Number = 0; i < PERLIN_OCTAVES; i++) {
				_offset[i] = new Point(Math.random() * BD_WIDTH / 2, Math.random() * BD_HEIGHT / 2);
				_speed[i] = new Point(Math.random() * 2, Math.random() * 2);
			}
			_nX = BD_WIDTH / 2 * Math.random();
			_nY = BD_HEIGHT / 2 * Math.random();
			
			_bd = new BitmapData(BD_WIDTH, BD_HEIGHT, true, 0xFFFFFF);
            _bm = new Bitmap(_bd);
            _sp.addChild(_bm);
		}


		private function onEnterFrame(e:Event):void {
			// オフセット位置の変更
			for (var i:Number = 0; i < PERLIN_OCTAVES; i++) {
				_offset[i].x += _speed[i].x;
				_offset[i].y += _speed[i].y;
			}
			// パーリンノイズ画像生成
			_bd.perlinNoise(_nX,
							_nY,
							PERLIN_OCTAVES,
							PERLIN_SEED,
							false,
							true,
							CHANNELS,
							false,
							_offset);
							
			// 歪みフィルターを作成
			var clickPoint:Point = new Point();
			var pt:Point = new Point(clickPoint.x - _sp.width / 2, clickPoint.y - _sp.height / 2); 
			var copyFilter:Array=new Array(); 
			var filter:DisplacementMapFilter
			= new DisplacementMapFilter(_bd,
										new Point(0, 0),
										CHANNELS,
										CHANNELS,
										100,
										100);
			copyFilter.push (filter);  
			_sp.filters = copyFilter;
			_bd.draw (_sp, new Matrix(1, 0, 0, 1, _sp.width,  _sp.height)); 
		}
	}
}