/**
 * Copyright maxcaffy ( http://wonderfl.net/user/maxcaffy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e36U
 */

//羽田空港に出発の7時間前に着いたのでパソコンコーナーでFlashDevelop。
//筆ラインっぽいものを書こうと思ったら墜落途中の飛行機みたいになった。
//えんぎでもない。

//マウスドラッグで筆線を描けます。
//キーボードの上下または左右でスピード切り替えです。
//以前つくった「じわじわおえかき」の別バージョン。matacatさんのコードをいろいろ参考にさせてもらいました。

//Mouse-Drag. You can draw the line of the brush touch.
//Keyboard "up" and "down" or "right" or "left" is Speed-Change.

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.ui.Keyboard;
	/**
	 * 
	 * @author maxcaffy
	 * (:D)TL < ローカル変数/関数に_をつける癖をつけようと思ったらローカルばっかりで_を打つのが面倒すぎる件
	 * 
	 */
	
	public class ten_0427 extends Sprite{
		
		private var _draw_sprash:Shape;		//飛沫用
		private var _draw_field:Shape;		//実際に線を引くシェイプ
		private var _blur_bm:Bitmap;		//ブラーフィルターをかけるビットマップ
		private var _blur_bmd:BitmapData;	//の、データ
		private var _prev_point:Point;		//一つ前のマウスの位置
		private var _blur:BlurFilter;		//ブラーフィルター
		private var _blur_rect:Rectangle;	//ブラーフィルターをかける範囲の矩形
		private var _blur_point:Point;		//ブラーフィルターをかける左上の座標（なんでxy別々の指定にしてくれないんだろ。めんどい）
		private var _blur_whiten:ColorTransform;	//漂白剤用のカラー変換(matacatさんから教わりました)
		private var _blur_mat:Matrix;		//ビットマップデータを貼り付けるためのマトリクス
		private var _line_size:Number;		//ラインの太さ。ランダムでデコボコ変えてます
		private var _blur_point_spd:Number;	//スクロール速度の倍数
		
		//コンストラクタ
		public function ten_0427(){	
			_initFunc();
		}
		
		//初期設定
		private function _initFunc():void {
			_draw_field = new Shape();
			_draw_sprash = new Shape();
			_draw_sprash.graphics.beginFill(0x000000, 1.0);
			_blur = new BlurFilter(2, 2, 1.0);
			_blur_bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xffffffff);
			_blur_bm = new Bitmap(_blur_bmd);
			_blur_rect = new Rectangle(0, 0, _blur_bmd.width, _blur_bmd.height);
			_blur_point = new Point(0, 0);
			_blur_point_spd = new Number(1);
			_blur_whiten = new ColorTransform(1,1,1,1,5,5,5,0);
			_blur_mat =	new Matrix(1, 0, 0, 1, 0, 0);
			_line_size = new Number(3.0);
			
			stage.addChild(_blur_bm);			
			stage.addChild(_draw_field);
			stage.addChild(_draw_sprash);
			
			stage.addEventListener(Event.ENTER_FRAME, _entFunc);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, _mouseDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, _keyUp);
		}
		
		//マウス押したとき
		private function _mouseDown(event:MouseEvent):void {
			stage.addEventListener(MouseEvent.MOUSE_MOVE, _mouseMove);
			stage.addEventListener(MouseEvent.MOUSE_UP, _mouseUp);
			stage.addEventListener(Event.ENTER_FRAME, _mouseEnt);
			_draw_field.graphics.lineStyle(_line_size, 0x000000, 1.0);
			_prev_point = new Point(mouseX, mouseY);
		}
		
		//マウス動かしたとき
		private function _mouseMove(event:MouseEvent):void {
			_line_size += Math.random() * 5 - 2.5;
			if (_line_size < 0) {
				_line_size = 0;
			}else if (_line_size > 10) {
				_line_size = 10;
			}
			_shapeDraw();
		}
		
		//毎フレーム実行（マウス動かしたときの関数と一部挙動が被るから重いけど、動かしたときの関数だけだとどうもカクカクして綺麗じゃなかったので仕方なく。）
		private function _mouseEnt(event:Event):void {
			_line_size += 0.5;
			_shapeDraw();
			_blur_point = new Point(int((stage.stageWidth / 2 - mouseX) * 0.05*_blur_point_spd), int((stage.stageHeight / 2 - mouseY) * 0.05*_blur_point_spd));
			if (_blur_point.y == 1) {	//なぜかyが1だけズレると上手くいかない。何故だ。
				_blur_point.y = 0;
			}
		}
		
		//線をグネグネ引く。一定確率で飛沫を飛ばす。
		private function _shapeDraw():void {
			_draw_field.graphics.lineStyle(_line_size, 0x000000, 1.0);
			_draw_field.graphics.moveTo(_prev_point.x, _prev_point.y);;
			_draw_field.graphics.lineTo(mouseX + (Math.random() - 0.5), mouseY + (Math.random() - 0.5));
			if (Math.random() < 0.1) {
				_draw_sprash.graphics.drawCircle(mouseX + (Math.random() * 30 - 15), mouseY + (Math.random() * 30 - 15), Math.random() * 5);
			}
			_prev_point = new Point(mouseX, mouseY);
		}
		
		//マウス上げたとき
		private function _mouseUp(event:MouseEvent):void {
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, _mouseMove);
			stage.removeEventListener(MouseEvent.MOUSE_UP, _mouseUp);
			stage.removeEventListener(Event.ENTER_FRAME, _mouseEnt);
			
			_line_size = 3.0;
		}
		
		//毎フレーム実行。ぼかし用ビットマップに描画用シェイプをdraw
		private function _entFunc(event:Event):void {
			_blur_bmd.draw(_draw_field, _blur_mat, null, null);
			_blur_bmd.draw(_draw_sprash, _blur_mat, null, null);
			_blurDraw();
			_draw_field.graphics.clear();
			_draw_sprash.graphics.clear();
			_draw_field.graphics.lineStyle(_line_size, 0x000000, 1.0)
			_draw_sprash.graphics.beginFill(0x000000, 1.0);
		}
		
		//ブラーかけつつ漂白
		private function _blurDraw():void {
			_blur_bmd.applyFilter(_blur_bmd, _blur_rect, _blur_point, _blur);
			_blur_bmd.colorTransform(_blur_rect, _blur_whiten);
		}
		
		//キーボード押したとき
		private function _keyUp(event:KeyboardEvent):void {
			switch(event.keyCode) {
				case Keyboard.LEFT:
				_blur_point_spd --;
				break;
				
				case Keyboard.RIGHT:
				_blur_point_spd ++;
				break;
				
				case Keyboard.UP:
				_blur_point_spd ++;
				break;
				
				case Keyboard.DOWN:
				_blur_point_spd --;
				break;
			}
		}
	}
}