/**
 * Copyright hacker_yk666qry ( http://wonderfl.net/user/hacker_yk666qry )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/e0Xi
 */

// forked from hacker_yk666qry's flash on 2009-12-12
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.text.TextFieldType;

	// LogoGenerator クラス
	public class LogoGenerator extends Sprite {
		// インスタンス変数の宣言
		private var inputText:TextField;   // テキスト入力欄
		private var reflection:Bitmap;     // 反射効果の表示
		private var preview:Sprite;        // プレビュー表示
		private var previewText:TextField; // プレビュー文字
		private var hilight:Sprite;        // 明るくするハイライト

		// コンストラクタ
		public function LogoGenerator():void {
			// 左上に固定して拡大縮小されないよう指定
			stage.scaleMode = "noScale";
			stage.align = "TL";

			// 各コンポーネントを初期化する
			initComponents();

			// 初回の描画を行う
			update();

			// イベント登録を行う
			inputText.addEventListener("change", function(event:Event):void {
				update();
			});
		}

		// 表示オブジェクトの初期化
		private function initComponents():void {
			// テキスト入力欄を作成
			inputText = new TextField();
			inputText.border = true;
			inputText.type = TextFieldType.INPUT;
			inputText.width = 300;
			inputText.height = 18;
			inputText.text = "Web 2.0 Generator";

			// 反射を表示するビットマップを作成
			reflection = new Bitmap();
			reflection.y = 50;

			// プレビュー用表示の Sprite を作成
			preview = new Sprite();
			preview.y = 50;

			// 出力用のテキストフィールドを作成
			previewText = new TextField();
			var tf:TextFormat = new TextFormat();  // TextFormat オブジェクトを作成
			tf.size = 48;                          // 文字サイズを 48px に変更
			tf.color = 0x3292d8;                   // 色を #3292d8 (青色) に変更
			previewText.defaultTextFormat = tf;    // TextFormat を指定
			previewText.autoSize = "left";

			// 明るくするハイライトを作成
			hilight = new Sprite();
			hilight.graphics.beginFill(0xffffff, 0.3);
			hilight.graphics.drawRect(0, 0, 10, 10);
			hilight.graphics.drawEllipse(0, 3, 10, 10);
			hilight.graphics.endFill();
			hilight.x = 2; // TextField の周りにできる2pxのマージンの分、ずらしておく


			// 各パーツを追加していく
			addChild(inputText);
			addChild(reflection);
			addChild(preview);
			preview.addChild(previewText);
			preview.addChild(hilight);
		}

		// 表示を更新する
		private function update():void {
			// 文字列の更新
			previewText.text = inputText.text;

			// 最後の１文字の色を変更する
			var tf:TextFormat = new TextFormat();
			tf.color = 0xfd1e73;
			previewText.setTextFormat(tf, inputText.text.length - 1);

			// ハイライトのサイズを変更する
			hilight.width = previewText.textWidth;
			hilight.height = previewText.textHeight * 1.5;  
	
			updateReflection();
		}

		// 反射を更新する
		private function updateReflection():void {
			// プレビューを BitmapData に描画
			var bmd:BitmapData = new BitmapData(preview.width, previewText.height * 2);
			bmd.fillRect(bmd.rect, 0xffffffff);
			bmd.draw(preview);

			// ロゴ全体の高さを取得
			var textHeight:int = bmd.getColorBoundsRect(0xffffffff, 0xffffffff, false).bottom;

			// 映り込みを描画していく
			for(var i:int = 0; i < textHeight; i++) {
				var multiply:uint = Math.max(1, i/ textHeight * 64);
				bmd.merge(bmd, new Rectangle(0, i, preview.width, 1), 
					new Point(0, textHeight * 2 - i + 2), multiply, multiply, multiply, 256);
			}

			// 反射以外を削除
			bmd.fillRect(new Rectangle(0, 0, preview.width, textHeight), 0xffffffff);

			// 表示
			if(reflection.bitmapData) {
				reflection.bitmapData.dispose();
			}
			reflection.bitmapData = bmd;
		}
	}
}
